/*
 * Decompiled with CFR 0.152.
 */
package com.amap.adapter.opengl;

import com.amap.adapter.opengl.GLMapSurfaceConfigChooser;
import com.amap.adapter.opengl.GLSurfaceView;
import com.amap.adapter.opengl.GlMapSurfaceEglContextFactory;
import com.amap.adapter.util.Log;
import java.util.Optional;
import ohos.agp.graphics.SurfaceOps;
import ohos.agp.render.opengl.EGL;
import ohos.agp.render.opengl.EGLConfig;
import ohos.agp.render.opengl.EGLContext;
import ohos.agp.render.opengl.EGLDisplay;
import ohos.agp.render.opengl.GLES20;

public class GlesUtility {
    private static boolean DEBUG = false;
    public static final int DEFAULT_TEXTUREID = -1;

    public static void checkGlError(String string) {
        int n2 = GLES20.glGetError();
        if (n2 != 0) {
            Log.e("amap", string + ": glError " + n2);
            throw new RuntimeException(string + ": glError " + n2);
        }
    }

    public static void init(GLSurfaceView gLSurfaceView, int n2, int n3, int n4, int n5, int n6, int n7) {
        Optional<SurfaceOps> optional;
        if (n5 > 0 && (optional = gLSurfaceView.getSurfaceOps()) != null) {
            optional.get().setFormat(-3);
        }
        gLSurfaceView.setEGLContextFactory(new ContextFactory());
        gLSurfaceView.setEGLConfigChooser(new ConfigChooser(n2, n3, n4, n5, n6, n7));
    }

    public static class ConfigChooser
    extends GLMapSurfaceConfigChooser {
        private static int EGL_OPENGL_ES2_BIT = 4;
        protected int mRedSize;
        protected int mGreenSize;
        protected int mBlueSize;
        protected int mAlphaSize;
        protected int mDepthSize;
        protected int mStencilSize;
        private int[] mValue = new int[1];

        public ConfigChooser(int n2, int n3, int n4, int n5, int n6, int n7) {
            this.mRedSize = n2;
            this.mGreenSize = n3;
            this.mBlueSize = n4;
            this.mAlphaSize = n5;
            this.mDepthSize = n6;
            this.mStencilSize = n7;
        }

        private int[] getConfigAttribsList(int n2, boolean bl2) {
            int n3 = 2;
            if (n2 == n3) {
                return new int[]{12324, this.mRedSize, 12323, this.mGreenSize, 12322, this.mBlueSize, 12321, this.mAlphaSize, 12325, this.mDepthSize, 12326, this.mStencilSize, 12352, EGL_OPENGL_ES2_BIT, 12344};
            }
            if (bl2) {
                return new int[]{12324, this.mRedSize, 12323, this.mGreenSize, 12322, this.mBlueSize, 12344};
            }
            return new int[]{12324, this.mRedSize, 12323, this.mGreenSize, 12322, this.mBlueSize, 12344};
        }

        private a getConfigAttribs(EGL eGL, EGLDisplay eGLDisplay) {
            a a2 = new a();
            a2.a = this.getConfigAttribsList(2, true);
            EGL.eglChooseConfig((EGLDisplay)eGLDisplay, (int[])a2.a, null, (int)0, (int[])a2.b);
            if (a2.b[0] <= 0) {
                a2.a = this.getConfigAttribsList(2, false);
                EGL.eglChooseConfig((EGLDisplay)eGLDisplay, (int[])a2.a, null, (int)0, (int[])a2.b);
                if (a2.b[0] <= 0) {
                    return null;
                }
            }
            return a2;
        }

        @Override
        public EGLConfig chooseConfig(EGL eGL, EGLDisplay eGLDisplay) {
            a a2 = this.getConfigAttribs(eGL, eGLDisplay);
            if (a2 == null || a2.a == null) {
                return null;
            }
            EGLConfig[] eGLConfigArray = new EGLConfig[a2.b[0]];
            EGL.eglChooseConfig((EGLDisplay)eGLDisplay, (int[])a2.a, (EGLConfig[])eGLConfigArray, (int)a2.b[0], (int[])a2.b);
            EGLConfig eGLConfig = this.chooseConfig(eGL, eGLDisplay, eGLConfigArray);
            if (eGLConfig == null) {
                this.mRedSize = 8;
                this.mGreenSize = 8;
                this.mBlueSize = 8;
                a2 = this.getConfigAttribs(eGL, eGLDisplay);
                if (a2 != null && a2.a != null) {
                    eGLConfigArray = new EGLConfig[a2.b[0]];
                    EGL.eglChooseConfig((EGLDisplay)eGLDisplay, (int[])a2.a, (EGLConfig[])eGLConfigArray, (int)a2.b[0], (int[])a2.b);
                    eGLConfig = this.chooseConfig(eGL, eGLDisplay, eGLConfigArray);
                }
            }
            if (DEBUG) {
                this.printConfigs(eGL, eGLDisplay, eGLConfigArray);
            }
            return eGLConfig;
        }

        public EGLConfig chooseConfig(EGL eGL, EGLDisplay eGLDisplay, EGLConfig[] eGLConfigArray) {
            for (EGLConfig eGLConfig : eGLConfigArray) {
                int n2 = this.findConfigAttrib(eGL, eGLDisplay, eGLConfig, 12325, 0);
                int n3 = this.findConfigAttrib(eGL, eGLDisplay, eGLConfig, 12326, 0);
                if (n2 < this.mDepthSize || n3 < this.mStencilSize) continue;
                int n4 = this.findConfigAttrib(eGL, eGLDisplay, eGLConfig, 12324, 0);
                int n5 = this.findConfigAttrib(eGL, eGLDisplay, eGLConfig, 12323, 0);
                int n6 = this.findConfigAttrib(eGL, eGLDisplay, eGLConfig, 12322, 0);
                int n7 = this.findConfigAttrib(eGL, eGLDisplay, eGLConfig, 12321, 0);
                if (n4 != this.mRedSize || n5 != this.mGreenSize || n6 != this.mBlueSize || n7 != this.mAlphaSize) continue;
                return eGLConfig;
            }
            return null;
        }

        private int findConfigAttrib(EGL eGL, EGLDisplay eGLDisplay, EGLConfig eGLConfig, int n2, int n3) {
            if (EGL.eglGetConfigAttrib((EGLDisplay)eGLDisplay, (EGLConfig)eGLConfig, (int)n2, (int[])this.mValue)) {
                return this.mValue[0];
            }
            return n3;
        }

        private void printConfigs(EGL eGL, EGLDisplay eGLDisplay, EGLConfig[] eGLConfigArray) {
            if (DEBUG) {
                int n2 = eGLConfigArray.length;
                for (int i2 = 0; i2 < n2; ++i2) {
                    this.printConfig(eGL, eGLDisplay, eGLConfigArray[i2]);
                }
            }
        }

        private void printConfig(EGL eGL, EGLDisplay eGLDisplay, EGLConfig eGLConfig) {
            int[] nArray = new int[]{12320, 12321, 12322, 12323, 12324, 12325, 12326, 12329, 12336, 12339, 12345, 12346, 12347, 12348, 12351, 12352, 12354};
            String[] stringArray = new String[]{"EGL_BUFFER_SIZE", "EGL_ALPHA_SIZE", "EGL_BLUE_SIZE", "EGL_GREEN_SIZE", "EGL_RED_SIZE", "EGL_DEPTH_SIZE", "EGL_STENCIL_SIZE", "EGL_CONFIG_CAVEAT", "EGL_CONFIG_ID", "EGL_LEVEL", "EGL_MAX_PBUFFER_HEIGHT", "EGL_MAX_PBUFFER_PIXELS", "EGL_MAX_PBUFFER_WIDTH", "EGL_NATIVE_RENDERABLE", "EGL_NATIVE_VISUAL_ID", "EGL_NATIVE_VISUAL_TYPE", "EGL_PRESERVED_RESOURCES", "EGL_SAMPLES", "EGL_SAMPLE_BUFFERS", "EGL_SURFACE_TYPE", "EGL_TRANSPARENT_TYPE", "EGL_TRANSPARENT_RED_VALUE", "EGL_TRANSPARENT_GREEN_VALUE", "EGL_TRANSPARENT_BLUE_VALUE", "EGL_BIND_TO_TEXTURE_RGB", "EGL_BIND_TO_TEXTURE_RGBA", "EGL_MIN_SWAP_INTERVAL", "EGL_MAX_SWAP_INTERVAL", "EGL_LUMINANCE_SIZE", "EGL_ALPHA_MASK_SIZE", "EGL_COLOR_BUFFER_TYPE", "EGL_RENDERABLE_TYPE", "EGL_CONFORMANT"};
            int[] nArray2 = new int[1];
            for (int i2 = 0; i2 < nArray.length; ++i2) {
                int n2 = nArray[i2];
                String string = stringArray[i2];
                if (EGL.eglGetConfigAttrib((EGLDisplay)eGLDisplay, (EGLConfig)eGLConfig, (int)n2, (int[])nArray2)) continue;
                while (eGL.eglGetError() != 12288) {
                }
            }
        }
    }

    private static class a {
        public int[] a = null;
        public int[] b = new int[1];

        private a() {
        }
    }

    public static class ContextFactory
    extends GlMapSurfaceEglContextFactory {
        public static final int EGL_CONTEXT_CLIENT_VERSION = 12440;

        @Override
        public EGLContext createContext(EGL eGL, EGLDisplay eGLDisplay, EGLConfig eGLConfig) {
            try {
                int[] nArray = new int[]{12440, 2, 12344};
                EGLContext eGLContext = EGL.eglCreateContext((EGLDisplay)eGLDisplay, (EGLConfig)eGLConfig, (EGLContext)EGL.EGL_NO_CONTEXT, (int[])nArray);
                return eGLContext;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                return null;
            }
        }

        @Override
        public void destroyContext(EGL eGL, EGLDisplay eGLDisplay, EGLContext eGLContext) {
            EGL.eglDestroyContext((EGLDisplay)eGLDisplay, (EGLContext)eGLContext);
        }
    }
}

