/*
 * Decompiled with CFR 0.152.
 */
package com.amap.adapter.widget;

import com.amap.adapter.content.Context;
import com.amap.adapter.graphics.Bitmap;
import com.amap.adapter.graphics.Matrix;
import com.amap.adapter.graphics.drawable.BitmapDrawable;
import com.amap.adapter.graphics.drawable.Drawable;
import com.amap.adapter.view.View;
import ohos.agp.components.Component;
import ohos.agp.components.Image;
import ohos.agp.render.BlendMode;
import ohos.agp.render.Canvas;
import ohos.agp.render.Paint;
import ohos.agp.render.PixelMapHolder;
import ohos.media.image.PixelMap;

public class ImageView
extends View {
    private Image image;
    private Drawable mDrawable = null;
    private PixelMap pixelMap;
    private Matrix matrix;

    public ImageView(Context context) {
        super(context);
        this.image = new Image(context.getOsContext());
        this.addComponent((Component)this.image);
        this.image.addDrawTask(new Component.DrawTask(){

            public void onDraw(Component component, Canvas canvas) {
                if (ImageView.this.pixelMap != null && ImageView.this.matrix != null) {
                    canvas.drawColor(0, BlendMode.CLEAR);
                    canvas.setMatrix(ImageView.this.matrix.getOsMatrix());
                    PixelMapHolder pixelMapHolder = new PixelMapHolder(ImageView.this.pixelMap);
                    canvas.drawPixelMapHolder(pixelMapHolder, 0.0f, 0.0f, new Paint());
                }
            }
        });
    }

    @Override
    public Component getOsComponent() {
        return this;
    }

    public void setImageBitmap(Bitmap bitmap) {
        if (bitmap != null) {
            this.pixelMap = bitmap.getOsPixelMap();
            this.image.setPixelMap(bitmap.getOsPixelMap());
            this.mDrawable = new BitmapDrawable(bitmap);
        }
    }

    public void setClickable(boolean bl2) {
        this.image.setClickable(bl2);
    }

    public void setPadding(int n2, int n3, int n4, int n5) {
        this.image.setPadding(n2, n3, n4, n5);
    }

    public void setScaleType(ScaleType scaleType) {
        this.image.setScaleMode(this.getOsCaleMode(scaleType));
    }

    private Image.ScaleMode getOsCaleMode(ScaleType scaleType) {
        return Image.ScaleMode.STRETCH;
    }

    @Override
    public Drawable getDrawable() {
        return this.mDrawable;
    }

    public void setImageMatrix(Matrix matrix) {
        this.matrix = matrix;
        this.image.invalidate();
    }

    public static enum ScaleType {
        MATRIX(0);

        final int nativeInt;

        private ScaleType(int n3) {
            this.nativeInt = n3;
        }
    }
}

