/*
 * Decompiled with CFR 0.152.
 */
package com.autonavi.base.ae.gmap.glyph;

import com.amap.adapter.graphics.Bitmap;
import com.amap.adapter.graphics.Canvas;
import com.amap.adapter.graphics.Paint;
import com.amap.adapter.graphics.Rect;
import com.amap.adapter.graphics.Typeface;
import com.amap.adapter.text.TextPaint;
import com.amap.adapter.text.TextUtils;
import com.autonavi.base.ae.gmap.glyph.Font;
import com.autonavi.base.ae.gmap.glyph.FontMetrics;
import com.autonavi.base.ae.gmap.glyph.FontMetricsRequestParam;
import com.autonavi.base.ae.gmap.glyph.FontStyle;
import com.autonavi.base.ae.gmap.glyph.GlyphMetrics;
import com.autonavi.base.ae.gmap.glyph.GlyphRaster;
import com.autonavi.base.ae.gmap.glyph.GlyphRequestParam;
import com.autonavi.base.amap.mapcore.tools.GLConvertUtil;
import java.nio.ByteBuffer;

public class GlyphLoader {
    private static GlyphMetrics loadGlyphMetrics(String string, FontStyle fontStyle, float f2, String string2, boolean bl2, float f3) {
        GlyphMetrics glyphMetrics = new GlyphMetrics();
        if (null == fontStyle) {
            return glyphMetrics;
        }
        if (TextUtils.isEmpty(string)) {
            return glyphMetrics;
        }
        try {
            float f4;
            TextPaint textPaint = GlyphLoader.newTextPaint(fontStyle, f2, string2, bl2, f3);
            Rect rect = new Rect();
            textPaint.getTextBounds(string, 0, string.length(), rect);
            if (rect.width() == 0 && rect.height() == 0) {
                f4 = textPaint.measureText(" ", 0, 1);
                float f5 = Math.abs(textPaint.getFontMetrics().ascent) + Math.abs(textPaint.getFontMetrics().descent);
                rect.top = 0;
                rect.left = 0;
                rect.right = (int)f4;
                rect.bottom = (int)f5;
            }
            if (bl2 && f3 > 0.0f) {
                f4 = f3 / 2.0f;
                rect.top = (int)((float)rect.top - f4);
                rect.left = (int)((float)rect.left - f4);
                rect.right = (int)((float)rect.right + f4);
                rect.bottom = (int)((float)rect.bottom + f4);
            }
            glyphMetrics.bSuccess = true;
            glyphMetrics.fLeft = rect.left;
            glyphMetrics.fTop = Math.abs(textPaint.getFontMetrics().ascent) - (float)Math.abs(rect.top);
            glyphMetrics.nWidth = rect.width();
            glyphMetrics.nHeight = rect.height();
            glyphMetrics.fAdvance = textPaint.measureText(string);
        }
        catch (Exception exception) {
            glyphMetrics.bSuccess = false;
        }
        return glyphMetrics;
    }

    private static GlyphRaster loadGlyphRaster(String string, FontStyle fontStyle, float f2, String string2, boolean bl2, float f3) {
        GlyphRaster glyphRaster = new GlyphRaster();
        if (null == fontStyle) {
            return glyphRaster;
        }
        if (TextUtils.isEmpty(string)) {
            return glyphRaster;
        }
        try {
            float f4;
            TextPaint textPaint = GlyphLoader.newTextPaint(fontStyle, f2, string2, bl2, f3);
            Rect rect = new Rect();
            textPaint.getTextBounds(string, 0, string.length(), rect);
            if (rect.width() == 0 && rect.height() == 0) {
                f4 = textPaint.measureText(" ", 0, 1);
                float f5 = Math.abs(textPaint.getFontMetrics().ascent) + Math.abs(textPaint.getFontMetrics().descent);
                rect.right = (int)f4;
                rect.bottom = (int)f5;
                rect.left = 0;
                rect.top = 0;
            }
            if (bl2 && f3 > 0.0f) {
                f4 = f3 / 2.0f;
                rect.top = (int)((float)rect.top - f4);
                rect.left = (int)((float)rect.left - f4);
                rect.right = (int)((float)rect.right + f4);
                rect.bottom = (int)((float)rect.bottom + f4);
            }
            if (!rect.isEmpty()) {
                Bitmap bitmap = Bitmap.createBitmap(rect.width(), rect.height(), Bitmap.Config.ALPHA_8);
                Canvas canvas = new Canvas(bitmap);
                float f6 = 0 - rect.left;
                float f7 = 0 - rect.top;
                canvas.drawText(string, f6, f7, textPaint);
                byte[] byArray = new byte[rect.width() * rect.height()];
                ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
                glyphRaster.bitmapWidth = rect.width();
                glyphRaster.bitmapHeight = rect.height();
                glyphRaster.bitmapPixelMode = 0;
                glyphRaster.bitmapSize = byArray.length;
                bitmap.copyPixelsToBuffer(byteBuffer);
                bitmap.recycle();
                glyphRaster.bitmapBuffer = byArray;
                glyphRaster.bSuccess = true;
            }
        }
        catch (Exception exception) {
            glyphRaster.bSuccess = false;
        }
        return glyphRaster;
    }

    private static GlyphRequestParam genGlyphRequestParam(byte[] byArray) {
        GlyphRequestParam glyphRequestParam = new GlyphRequestParam();
        int n2 = 0;
        int n3 = 0;
        n3 = GLConvertUtil.getInt(byArray, n2);
        glyphRequestParam.strBuffer = new String(byArray, n2 += 4, n3);
        Font font = new Font();
        font.nFontStyleCode = GLConvertUtil.getInt(byArray, n2 += n3);
        font.nFontSize = GLConvertUtil.getInt(byArray, n2 += 4);
        n3 = GLConvertUtil.getInt(byArray, n2 += 4);
        font.strName = new String(byArray, n2 += 4, n3);
        FontMetrics fontMetrics = new FontMetrics();
        int n4 = GLConvertUtil.getInt(byArray, n2 += n3);
        fontMetrics.fAscent = (float)n4 * 0.001f;
        n4 = GLConvertUtil.getInt(byArray, n2 += 4);
        fontMetrics.fDescent = (float)n4 * 0.001f;
        n4 = GLConvertUtil.getInt(byArray, n2 += 4);
        fontMetrics.fLeading = (float)n4 * 0.001f;
        n4 = GLConvertUtil.getInt(byArray, n2 += 4);
        fontMetrics.fHeight = (float)n4 * 0.001f;
        font.fontMetrics = fontMetrics;
        glyphRequestParam.font = font;
        glyphRequestParam.drawingMode = GLConvertUtil.getInt(byArray, n2 += 4);
        n4 = GLConvertUtil.getInt(byArray, n2 += 4);
        glyphRequestParam.strokeWidth = (float)n4 * 0.001f;
        n3 = GLConvertUtil.getInt(byArray, n2 += 4);
        glyphRequestParam.languageArr = new String(byArray, n2 += 4, n3);
        int n5 = GLConvertUtil.getInt(byArray, n2);
        n2 += 4;
        if (1 == n5) {
            GlyphMetrics glyphMetrics = new GlyphMetrics();
            glyphMetrics.nWidth = GLConvertUtil.getInt(byArray, n2);
            glyphMetrics.nHeight = GLConvertUtil.getInt(byArray, n2 += 4);
            n4 = GLConvertUtil.getInt(byArray, n2 += 4);
            glyphMetrics.fLeft = (float)n4 * 0.001f;
            n4 = GLConvertUtil.getInt(byArray, n2 += 4);
            glyphMetrics.fTop = (float)n4 * 0.001f;
            n4 = GLConvertUtil.getInt(byArray, n2 += 4);
            glyphMetrics.fAdvance = (float)n4 * 0.001f;
            glyphRequestParam.fGlyphMetrics = glyphMetrics;
        }
        return glyphRequestParam;
    }

    private static FontMetricsRequestParam genFontMetricsParam(byte[] byArray) {
        FontMetricsRequestParam fontMetricsRequestParam = new FontMetricsRequestParam();
        int n2 = 0;
        int n3 = 0;
        int n4 = GLConvertUtil.getInt(byArray, n2);
        fontMetricsRequestParam.fFontSize = (float)n4 * 0.001f;
        fontMetricsRequestParam.nFontStyleCode = GLConvertUtil.getInt(byArray, n2 += 4);
        int n5 = GLConvertUtil.getInt(byArray, n2 += 4);
        n2 += 4;
        if (1 == n5) {
            n3 = GLConvertUtil.getInt(byArray, n2);
            fontMetricsRequestParam.strName = new String(byArray, n2 += 4, n3);
            n2 += n3;
        }
        n3 = GLConvertUtil.getInt(byArray, n2);
        fontMetricsRequestParam.languageArr = new String(byArray, n2 += 4, n3);
        return fontMetricsRequestParam;
    }

    private static GlyphMetrics getGlyphMetrics(byte[] byArray) {
        GlyphRequestParam glyphRequestParam = GlyphLoader.genGlyphRequestParam(byArray);
        FontStyle fontStyle = new FontStyle(glyphRequestParam.font.nFontStyleCode);
        boolean bl2 = false;
        if (glyphRequestParam.drawingMode == 1) {
            bl2 = true;
        }
        return GlyphLoader.loadGlyphMetrics(glyphRequestParam.strBuffer, fontStyle, glyphRequestParam.font.nFontSize, glyphRequestParam.languageArr, bl2, glyphRequestParam.strokeWidth);
    }

    private static GlyphRaster getGlyphRaster(byte[] byArray) {
        GlyphRequestParam glyphRequestParam = GlyphLoader.genGlyphRequestParam(byArray);
        FontStyle fontStyle = new FontStyle(glyphRequestParam.font.nFontStyleCode);
        boolean bl2 = false;
        if (glyphRequestParam.drawingMode == 1) {
            bl2 = true;
        }
        return GlyphLoader.loadGlyphRaster(glyphRequestParam.strBuffer, fontStyle, glyphRequestParam.font.nFontSize, glyphRequestParam.languageArr, bl2, glyphRequestParam.strokeWidth);
    }

    private static FontMetrics getFontMetrics(byte[] byArray) {
        FontMetricsRequestParam fontMetricsRequestParam = GlyphLoader.genFontMetricsParam(byArray);
        FontStyle fontStyle = new FontStyle(fontMetricsRequestParam.nFontStyleCode);
        TextPaint textPaint = GlyphLoader.newTextPaint(fontStyle, fontMetricsRequestParam.fFontSize, fontMetricsRequestParam.languageArr, false, 0.0f);
        Paint.FontMetrics fontMetrics = textPaint.getFontMetrics();
        FontMetrics fontMetrics2 = new FontMetrics();
        fontMetrics2.bSuccess = true;
        fontMetrics2.fAscent = Math.abs(fontMetrics.ascent);
        fontMetrics2.fDescent = Math.abs(fontMetrics.descent);
        fontMetrics2.fLeading = Math.abs(fontMetrics.leading);
        fontMetrics2.fHeight = Math.abs(fontMetrics.ascent) + Math.abs(fontMetrics.descent);
        return fontMetrics2;
    }

    private static String decodeUnicode(short s2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append((char)s2);
        return stringBuffer.toString();
    }

    private static String decodeUnicode(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    private static TextPaint newTextPaint(FontStyle fontStyle, float f2, String string, boolean bl2, float f3) {
        TextPaint textPaint = new TextPaint();
        if (null == fontStyle) {
            return textPaint;
        }
        textPaint.setColor(-1);
        textPaint.setAntiAlias(true);
        textPaint.setFilterBitmap(true);
        textPaint.setTextSize(f2);
        textPaint.setTextAlign(Paint.Align.LEFT);
        if (bl2) {
            textPaint.setStyle(Paint.Style.STROKE);
            textPaint.setStrokeWidth(f3);
        } else {
            textPaint.setStyle(Paint.Style.FILL);
        }
        boolean bl3 = false;
        boolean bl4 = false;
        switch (fontStyle.getSlant()) {
            case 0: {
                bl3 = false;
                break;
            }
            case 1: 
            case 2: {
                bl3 = true;
                break;
            }
            default: {
                bl3 = false;
            }
        }
        switch (fontStyle.getWeight()) {
            case 400: {
                bl4 = false;
                break;
            }
            case 0: 
            case 100: 
            case 200: 
            case 300: {
                bl4 = false;
                break;
            }
            case 500: 
            case 600: 
            case 700: 
            case 800: 
            case 900: 
            case 1000: {
                bl4 = true;
                break;
            }
            default: {
                bl4 = false;
            }
        }
        int n2 = 0;
        if (bl4 && bl3) {
            n2 = 3;
        } else if (bl4) {
            n2 = 1;
        } else if (bl3) {
            n2 = 2;
        }
        Typeface typeface = null;
        typeface = string.isEmpty() ? Typeface.create(Typeface.DEFAULT, n2) : Typeface.create(string, n2);
        textPaint.setTypeface(typeface);
        return textPaint;
    }

    public static long createGlyphLoader() {
        return GlyphLoader.nativeCreateGlyphLoader();
    }

    public static void destroyGlyphLoader(long l2) {
        GlyphLoader.nativeDestroyGlyphLoader(l2);
    }

    private static native long nativeCreateGlyphLoader();

    private static native void nativeDestroyGlyphLoader(long var0);
}

