/*
 * Decompiled with CFR 0.152.
 */
package com.amap.adapter.graphics;

import java.util.HashMap;
import java.util.Locale;
import ohos.agp.colors.HsvColor;

public class Color {
    public static final int BLACK = -16777216;
    public static final int DKGRAY = -12303292;
    public static final int GRAY = -7829368;
    public static final int LTGRAY = -3355444;
    public static final int WHITE = -1;
    public static final int RED = -65536;
    public static final int GREEN = -16711936;
    public static final int BLUE = -16776961;
    public static final int YELLOW = -256;
    public static final int CYAN = -16711681;
    public static final int MAGENTA = -65281;
    public static final int TRANSPARENT = 0;
    private static final HashMap<String, Integer> sColorNameMap = new HashMap();

    public static int argb(float f2, float f3, float f4, float f5) {
        return (int)(f2 * 255.0f + 0.5f) << 24 | (int)(f3 * 255.0f + 0.5f) << 16 | (int)(f4 * 255.0f + 0.5f) << 8 | (int)(f5 * 255.0f + 0.5f);
    }

    public static int rgb(float f2, float f3, float f4) {
        return 0xFF000000 | (int)(f2 * 255.0f + 0.5f) << 16 | (int)(f3 * 255.0f + 0.5f) << 8 | (int)(f4 * 255.0f + 0.5f);
    }

    public static int argb(int n2, int n3, int n4, int n5) {
        return n2 << 24 | n3 << 16 | n4 << 8 | n5;
    }

    public static int rgb(int n2, int n3, int n4) {
        return 0xFF000000 | n2 << 16 | n3 << 8 | n4;
    }

    public static int alpha(int n2) {
        return n2 >>> 24;
    }

    public static int red(int n2) {
        return n2 >> 16 & 0xFF;
    }

    public static int green(int n2) {
        return n2 >> 8 & 0xFF;
    }

    public static int blue(int n2) {
        return n2 & 0xFF;
    }

    public static int parseColor(String string) {
        if (string.charAt(0) == '#') {
            long l2 = Long.parseLong(string.substring(1), 16);
            if (string.length() == 7) {
                l2 |= 0xFFFFFFFFFF000000L;
            } else if (string.length() != 9) {
                throw new IllegalArgumentException("Unknown color");
            }
            return (int)l2;
        }
        Integer n2 = sColorNameMap.get(string.toLowerCase(Locale.ROOT));
        if (n2 != null) {
            return n2;
        }
        throw new IllegalArgumentException("Unknown color");
    }

    public static void RGBToHSV(int n2, float[] fArray) {
        HsvColor hsvColor = HsvColor.toHSV((int)n2);
        fArray[0] = hsvColor.getValue();
        fArray[1] = hsvColor.getHue();
        fArray[2] = hsvColor.getSaturation();
    }

    public static int HSVToColor(int n2, float[] fArray) {
        return HsvColor.toColor((int)n2, (float)fArray[1], (float)fArray[2], (float)fArray[0]);
    }

    static {
        sColorNameMap.put("black", -16777216);
        sColorNameMap.put("darkgray", -12303292);
        sColorNameMap.put("gray", -7829368);
        sColorNameMap.put("lightgray", -3355444);
        sColorNameMap.put("white", -1);
        sColorNameMap.put("red", -65536);
        sColorNameMap.put("green", -16711936);
        sColorNameMap.put("blue", -16776961);
        sColorNameMap.put("yellow", -256);
        sColorNameMap.put("cyan", -16711681);
        sColorNameMap.put("magenta", -65281);
        sColorNameMap.put("aqua", -16711681);
        sColorNameMap.put("fuchsia", -65281);
        sColorNameMap.put("darkgrey", -12303292);
        sColorNameMap.put("grey", -7829368);
        sColorNameMap.put("lightgrey", -3355444);
        sColorNameMap.put("lime", -16711936);
        sColorNameMap.put("maroon", -8388608);
        sColorNameMap.put("navy", -16777088);
        sColorNameMap.put("olive", -8355840);
        sColorNameMap.put("purple", -8388480);
        sColorNameMap.put("silver", -4144960);
        sColorNameMap.put("teal", -16744320);
    }
}

