/*
 * Decompiled with CFR 0.152.
 */
package com.amap.adapter.json;

import com.amap.adapter.json.JSONException;
import com.amap.adapter.json.JSONObject;
import com.amap.adapter.json.JSONStringer;
import com.amap.adapter.json.JSONTokener;
import com.amap.adapter.json.a;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class JSONArray {
    private final List<Object> values;

    public JSONArray() {
        this.values = new ArrayList<Object>();
    }

    public JSONArray(Collection collection) {
        this();
        if (collection != null) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                this.put(JSONObject.wrap(iterator.next()));
            }
        }
    }

    public JSONArray(JSONTokener jSONTokener) throws JSONException {
        Object object = jSONTokener.nextValue();
        if (!(object instanceof JSONArray)) {
            throw a.a(object, "JSONArray");
        }
        this.values = ((JSONArray)object).values;
    }

    public JSONArray(String string) throws JSONException {
        this(new JSONTokener(string));
    }

    public JSONArray(Object object) throws JSONException {
        if (!object.getClass().isArray()) {
            throw new JSONException("Not a primitive array: " + object.getClass());
        }
        int n2 = Array.getLength(object);
        this.values = new ArrayList<Object>(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            this.put(JSONObject.wrap(Array.get(object, i2)));
        }
    }

    public int length() {
        return this.values.size();
    }

    public JSONArray put(boolean bl2) {
        this.values.add(bl2);
        return this;
    }

    public JSONArray put(double d2) throws JSONException {
        this.values.add(a.a(d2));
        return this;
    }

    public JSONArray put(int n2) {
        this.values.add(n2);
        return this;
    }

    public JSONArray put(long l2) {
        this.values.add(l2);
        return this;
    }

    public JSONArray put(Object object) {
        this.values.add(object);
        return this;
    }

    void checkedPut(Object object) throws JSONException {
        if (object instanceof Number) {
            a.a(((Number)object).doubleValue());
        }
        this.put(object);
    }

    public JSONArray put(int n2, boolean bl2) throws JSONException {
        return this.put(n2, (Object)bl2);
    }

    public JSONArray put(int n2, double d2) throws JSONException {
        return this.put(n2, (Object)d2);
    }

    public JSONArray put(int n2, int n3) throws JSONException {
        return this.put(n2, (Object)n3);
    }

    public JSONArray put(int n2, long l2) throws JSONException {
        return this.put(n2, (Object)l2);
    }

    public JSONArray put(int n2, Object object) throws JSONException {
        if (object instanceof Number) {
            a.a(((Number)object).doubleValue());
        }
        while (this.values.size() <= n2) {
            this.values.add(null);
        }
        this.values.set(n2, object);
        return this;
    }

    public boolean isNull(int n2) {
        Object object = this.opt(n2);
        return object == null || object == JSONObject.NULL;
    }

    public Object get(int n2) throws JSONException {
        try {
            Object object = this.values.get(n2);
            if (object == null) {
                throw new JSONException("Value at " + n2 + " is null.");
            }
            return object;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new JSONException("Index " + n2 + " out of range [0.." + this.values.size() + ")");
        }
    }

    public Object opt(int n2) {
        if (n2 < 0 || n2 >= this.values.size()) {
            return null;
        }
        return this.values.get(n2);
    }

    public Object remove(int n2) {
        if (n2 < 0 || n2 >= this.values.size()) {
            return null;
        }
        return this.values.remove(n2);
    }

    public boolean getBoolean(int n2) throws JSONException {
        Object object = this.get(n2);
        Boolean bl2 = a.a(object);
        if (bl2 == null) {
            throw a.a(n2, object, "boolean");
        }
        return bl2;
    }

    public boolean optBoolean(int n2) {
        return this.optBoolean(n2, false);
    }

    public boolean optBoolean(int n2, boolean bl2) {
        Object object = this.opt(n2);
        Boolean bl3 = a.a(object);
        return bl3 != null ? bl3 : bl2;
    }

    public double getDouble(int n2) throws JSONException {
        Object object = this.get(n2);
        Double d2 = a.b(object);
        if (d2 == null) {
            throw a.a(n2, object, "double");
        }
        return d2;
    }

    public double optDouble(int n2) {
        return this.optDouble(n2, Double.NaN);
    }

    public double optDouble(int n2, double d2) {
        Object object = this.opt(n2);
        Double d3 = a.b(object);
        return d3 != null ? d3 : d2;
    }

    public int getInt(int n2) throws JSONException {
        Object object = this.get(n2);
        Integer n3 = a.c(object);
        if (n3 == null) {
            throw a.a(n2, object, "int");
        }
        return n3;
    }

    public int optInt(int n2) {
        return this.optInt(n2, 0);
    }

    public int optInt(int n2, int n3) {
        Object object = this.opt(n2);
        Integer n4 = a.c(object);
        return n4 != null ? n4 : n3;
    }

    public long getLong(int n2) throws JSONException {
        Object object = this.get(n2);
        Long l2 = a.d(object);
        if (l2 == null) {
            throw a.a(n2, object, "long");
        }
        return l2;
    }

    public long optLong(int n2) {
        return this.optLong(n2, 0L);
    }

    public long optLong(int n2, long l2) {
        Object object = this.opt(n2);
        Long l3 = a.d(object);
        return l3 != null ? l3 : l2;
    }

    public String getString(int n2) throws JSONException {
        Object object = this.get(n2);
        String string = a.e(object);
        if (string == null) {
            throw a.a(n2, object, "String");
        }
        return string;
    }

    public String optString(int n2) {
        return this.optString(n2, "");
    }

    public String optString(int n2, String string) {
        Object object = this.opt(n2);
        String string2 = a.e(object);
        return string2 != null ? string2 : string;
    }

    public JSONArray getJSONArray(int n2) throws JSONException {
        Object object = this.get(n2);
        if (object instanceof JSONArray) {
            return (JSONArray)object;
        }
        throw a.a(n2, object, "JSONArray");
    }

    public JSONArray optJSONArray(int n2) {
        Object object = this.opt(n2);
        return object instanceof JSONArray ? (JSONArray)object : null;
    }

    public JSONObject getJSONObject(int n2) throws JSONException {
        Object object = this.get(n2);
        if (object instanceof JSONObject) {
            return (JSONObject)object;
        }
        throw a.a(n2, object, "JSONObject");
    }

    public JSONObject optJSONObject(int n2) {
        Object object = this.opt(n2);
        return object instanceof JSONObject ? (JSONObject)object : null;
    }

    public JSONObject toJSONObject(JSONArray jSONArray) throws JSONException {
        JSONObject jSONObject = new JSONObject();
        int n2 = Math.min(jSONArray.length(), this.values.size());
        if (n2 == 0) {
            return null;
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            String string = a.e(jSONArray.opt(i2));
            jSONObject.put(string, this.opt(i2));
        }
        return jSONObject;
    }

    public String join(String string) throws JSONException {
        JSONStringer jSONStringer = new JSONStringer();
        jSONStringer.open(JSONStringer.a.f, "");
        int n2 = this.values.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (i2 > 0) {
                jSONStringer.out.append(string);
            }
            jSONStringer.value(this.values.get(i2));
        }
        jSONStringer.close(JSONStringer.a.f, JSONStringer.a.f, "");
        return jSONStringer.out.toString();
    }

    public String toString() {
        try {
            JSONStringer jSONStringer = new JSONStringer();
            this.writeTo(jSONStringer);
            return jSONStringer.toString();
        }
        catch (JSONException jSONException) {
            return null;
        }
    }

    public String toString(int n2) throws JSONException {
        JSONStringer jSONStringer = new JSONStringer(n2);
        this.writeTo(jSONStringer);
        return jSONStringer.toString();
    }

    void writeTo(JSONStringer jSONStringer) throws JSONException {
        jSONStringer.array();
        for (Object object : this.values) {
            jSONStringer.value(object);
        }
        jSONStringer.endArray();
    }

    public boolean equals(Object object) {
        return object instanceof JSONArray && ((JSONArray)object).values.equals(this.values);
    }

    public int hashCode() {
        return this.values.hashCode();
    }
}

