/*
 * Decompiled with CFR 0.152.
 */
package com.amap.adapter.json;

import com.amap.adapter.json.JSONArray;
import com.amap.adapter.json.JSONException;
import com.amap.adapter.json.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class JSONStringer {
    final StringBuilder out = new StringBuilder();
    private final List<a> stack = new ArrayList<a>();
    private final String indent;

    public JSONStringer() {
        this.indent = null;
    }

    JSONStringer(int n2) {
        char[] cArray = new char[n2];
        Arrays.fill(cArray, ' ');
        this.indent = new String(cArray);
    }

    public JSONStringer array() throws JSONException {
        return this.open(a.a, "[");
    }

    public JSONStringer endArray() throws JSONException {
        return this.close(a.a, a.b, "]");
    }

    public JSONStringer object() throws JSONException {
        return this.open(a.c, "{");
    }

    public JSONStringer endObject() throws JSONException {
        return this.close(a.c, a.e, "}");
    }

    JSONStringer open(a a2, String string) throws JSONException {
        if (this.stack.isEmpty() && this.out.length() > 0) {
            throw new JSONException("Nesting problem: multiple top-level roots");
        }
        this.beforeValue();
        this.stack.add(a2);
        this.out.append(string);
        return this;
    }

    JSONStringer close(a a2, a a3, String string) throws JSONException {
        a a4 = this.peek();
        if (a4 != a3 && a4 != a2) {
            throw new JSONException("Nesting problem");
        }
        this.stack.remove(this.stack.size() - 1);
        if (a4 == a3) {
            this.newline();
        }
        this.out.append(string);
        return this;
    }

    private a peek() throws JSONException {
        if (this.stack.isEmpty()) {
            throw new JSONException("Nesting problem");
        }
        return this.stack.get(this.stack.size() - 1);
    }

    private void replaceTop(a a2) {
        this.stack.set(this.stack.size() - 1, a2);
    }

    public JSONStringer value(Object object) throws JSONException {
        if (this.stack.isEmpty()) {
            throw new JSONException("Nesting problem");
        }
        if (object instanceof JSONArray) {
            ((JSONArray)object).writeTo(this);
            return this;
        }
        if (object instanceof JSONObject) {
            ((JSONObject)object).writeTo(this);
            return this;
        }
        this.beforeValue();
        if (object == null || object instanceof Boolean || object == JSONObject.NULL) {
            this.out.append(object);
        } else if (object instanceof Number) {
            this.out.append(JSONObject.numberToString((Number)object));
        } else {
            this.string(object.toString());
        }
        return this;
    }

    public JSONStringer value(boolean bl2) throws JSONException {
        if (this.stack.isEmpty()) {
            throw new JSONException("Nesting problem");
        }
        this.beforeValue();
        this.out.append(bl2);
        return this;
    }

    public JSONStringer value(double d2) throws JSONException {
        if (this.stack.isEmpty()) {
            throw new JSONException("Nesting problem");
        }
        this.beforeValue();
        this.out.append(JSONObject.numberToString(d2));
        return this;
    }

    public JSONStringer value(long l2) throws JSONException {
        if (this.stack.isEmpty()) {
            throw new JSONException("Nesting problem");
        }
        this.beforeValue();
        this.out.append(l2);
        return this;
    }

    private void string(String string) {
        this.out.append("\"");
        int n2 = string.length();
        block8: for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            switch (c2) {
                case '\"': 
                case '/': 
                case '\\': {
                    this.out.append('\\').append(c2);
                    continue block8;
                }
                case '\t': {
                    this.out.append("\\t");
                    continue block8;
                }
                case '\b': {
                    this.out.append("\\b");
                    continue block8;
                }
                case '\n': {
                    this.out.append("\\n");
                    continue block8;
                }
                case '\r': {
                    this.out.append("\\r");
                    continue block8;
                }
                case '\f': {
                    this.out.append("\\f");
                    continue block8;
                }
                default: {
                    if (c2 <= '\u001f') {
                        this.out.append(String.format("\\u%04x", c2));
                        continue block8;
                    }
                    this.out.append(c2);
                }
            }
        }
        this.out.append("\"");
    }

    private void newline() {
        if (this.indent == null) {
            return;
        }
        this.out.append("\n");
        for (int i2 = 0; i2 < this.stack.size(); ++i2) {
            this.out.append(this.indent);
        }
    }

    public JSONStringer key(String string) throws JSONException {
        if (string == null) {
            throw new JSONException("Names must be non-null");
        }
        this.beforeKey();
        this.string(string);
        return this;
    }

    private void beforeKey() throws JSONException {
        a a2 = this.peek();
        if (a2 == a.e) {
            this.out.append(',');
        } else if (a2 != a.c) {
            throw new JSONException("Nesting problem");
        }
        this.newline();
        this.replaceTop(a.d);
    }

    private void beforeValue() throws JSONException {
        if (this.stack.isEmpty()) {
            return;
        }
        a a2 = this.peek();
        if (a2 == a.a) {
            this.replaceTop(a.b);
            this.newline();
        } else if (a2 == a.b) {
            this.out.append(',');
            this.newline();
        } else if (a2 == a.d) {
            this.out.append(this.indent == null ? ":" : ": ");
            this.replaceTop(a.e);
        } else if (a2 != a.f) {
            throw new JSONException("Nesting problem");
        }
    }

    public String toString() {
        return this.out.length() == 0 ? null : this.out.toString();
    }

    static enum a {
        a,
        b,
        c,
        d,
        e,
        f;

    }
}

