/*
 * Decompiled with CFR 0.152.
 */
package com.amap.adapter.opengl;

public class Matrix {
    private static final float[] sTemp = new float[32];

    @Deprecated
    public Matrix() {
    }

    public static void multiplyMM(float[] fArray, int n2, float[] fArray2, int n3, float[] fArray3, int n4) {
        for (int i2 = 0; i2 < 4; ++i2) {
            float f2 = fArray3[4 * i2 + 0];
            float f3 = fArray2[0] * f2;
            float f4 = fArray2[1] * f2;
            float f5 = fArray2[2] * f2;
            float f6 = fArray2[3] * f2;
            for (int i3 = 1; i3 < 4; ++i3) {
                float f7 = fArray3[4 * i2 + i3];
                f3 += fArray2[4 * i3 + 0] * f7;
                f4 += fArray2[4 * i3 + 1] * f7;
                f5 += fArray2[4 * i3 + 2] * f7;
                f6 += fArray2[4 * i3 + 3] * f7;
            }
            fArray[4 * i2 + 0] = f3;
            fArray[4 * i2 + 1] = f4;
            fArray[4 * i2 + 2] = f5;
            fArray[4 * i2 + 3] = f6;
        }
    }

    public static void multiplyMV(float[] fArray, int n2, float[] fArray2, int n3, float[] fArray3, int n4) {
        Matrix.mx4transform(fArray3[0], fArray3[1], fArray3[2], fArray3[3], fArray2, fArray);
    }

    public static void mx4transform(float f2, float f3, float f4, float f5, float[] fArray, float[] fArray2) {
        fArray2[0] = fArray[0] * f2 + fArray[4] * f3 + fArray[8] * f4 + fArray[12] * f5;
        fArray2[1] = fArray[1] * f2 + fArray[5] * f3 + fArray[9] * f4 + fArray[13] * f5;
        fArray2[2] = fArray[2] * f2 + fArray[6] * f3 + fArray[10] * f4 + fArray[14] * f5;
        fArray2[3] = fArray[3] * f2 + fArray[7] * f3 + fArray[11] * f4 + fArray[15] * f5;
    }

    public static void transposeM(float[] fArray, int n2, float[] fArray2, int n3) {
        for (int i2 = 0; i2 < 4; ++i2) {
            int n4 = i2 * 4 + n3;
            fArray[i2 + n2] = fArray2[n4];
            fArray[i2 + 4 + n2] = fArray2[n4 + 1];
            fArray[i2 + 8 + n2] = fArray2[n4 + 2];
            fArray[i2 + 12 + n2] = fArray2[n4 + 3];
        }
    }

    public static boolean invertM(float[] fArray, int n2, float[] fArray2, int n3) {
        float f2 = fArray2[n3 + 0];
        float f3 = fArray2[n3 + 1];
        float f4 = fArray2[n3 + 2];
        float f5 = fArray2[n3 + 3];
        float f6 = fArray2[n3 + 4];
        float f7 = fArray2[n3 + 5];
        float f8 = fArray2[n3 + 6];
        float f9 = fArray2[n3 + 7];
        float f10 = fArray2[n3 + 8];
        float f11 = fArray2[n3 + 9];
        float f12 = fArray2[n3 + 10];
        float f13 = fArray2[n3 + 11];
        float f14 = fArray2[n3 + 12];
        float f15 = fArray2[n3 + 13];
        float f16 = fArray2[n3 + 14];
        float f17 = fArray2[n3 + 15];
        float f18 = f12 * f17;
        float f19 = f16 * f13;
        float f20 = f8 * f17;
        float f21 = f16 * f9;
        float f22 = f8 * f13;
        float f23 = f12 * f9;
        float f24 = f4 * f17;
        float f25 = f16 * f5;
        float f26 = f4 * f13;
        float f27 = f12 * f5;
        float f28 = f4 * f9;
        float f29 = f8 * f5;
        float f30 = f18 * f7 + f21 * f11 + f22 * f15 - (f19 * f7 + f20 * f11 + f23 * f15);
        float f31 = f19 * f3 + f24 * f11 + f27 * f15 - (f18 * f3 + f25 * f11 + f26 * f15);
        float f32 = f20 * f3 + f25 * f7 + f28 * f15 - (f21 * f3 + f24 * f7 + f29 * f15);
        float f33 = f23 * f3 + f26 * f7 + f29 * f11 - (f22 * f3 + f27 * f7 + f28 * f11);
        float f34 = f19 * f6 + f20 * f10 + f23 * f14 - (f18 * f6 + f21 * f10 + f22 * f14);
        float f35 = f18 * f2 + f25 * f10 + f26 * f14 - (f19 * f2 + f24 * f10 + f27 * f14);
        float f36 = f21 * f2 + f24 * f6 + f29 * f14 - (f20 * f2 + f25 * f6 + f28 * f14);
        float f37 = f22 * f2 + f27 * f6 + f28 * f10 - (f23 * f2 + f26 * f6 + f29 * f10);
        float f38 = f10 * f15;
        float f39 = f14 * f11;
        float f40 = f6 * f15;
        float f41 = f14 * f7;
        float f42 = f6 * f11;
        float f43 = f10 * f7;
        float f44 = f2 * f15;
        float f45 = f14 * f3;
        float f46 = f2 * f11;
        float f47 = f10 * f3;
        float f48 = f2 * f7;
        float f49 = f6 * f3;
        float f50 = f38 * f9 + f41 * f13 + f42 * f17 - (f39 * f9 + f40 * f13 + f43 * f17);
        float f51 = f39 * f5 + f44 * f13 + f47 * f17 - (f38 * f5 + f45 * f13 + f46 * f17);
        float f52 = f40 * f5 + f45 * f9 + f48 * f17 - (f41 * f5 + f44 * f9 + f49 * f17);
        float f53 = f43 * f5 + f46 * f9 + f49 * f13 - (f42 * f5 + f47 * f9 + f48 * f13);
        float f54 = f40 * f12 + f43 * f16 + f39 * f8 - (f42 * f16 + f38 * f8 + f41 * f12);
        float f55 = f46 * f16 + f38 * f4 + f45 * f12 - (f44 * f12 + f47 * f16 + f39 * f4);
        float f56 = f44 * f8 + f49 * f16 + f41 * f4 - (f48 * f16 + f40 * f4 + f45 * f8);
        float f57 = f48 * f12 + f42 * f4 + f47 * f8 - (f46 * f8 + f49 * f12 + f43 * f4);
        float f58 = f2 * f30 + f6 * f31 + f10 * f32 + f14 * f33;
        if (f58 == 0.0f) {
            return false;
        }
        float f59 = 1.0f / f58;
        fArray[n2] = f30 * f59;
        fArray[1 + n2] = f31 * f59;
        fArray[2 + n2] = f32 * f59;
        fArray[3 + n2] = f33 * f59;
        fArray[4 + n2] = f34 * f59;
        fArray[5 + n2] = f35 * f59;
        fArray[6 + n2] = f36 * f59;
        fArray[7 + n2] = f37 * f59;
        fArray[8 + n2] = f50 * f59;
        fArray[9 + n2] = f51 * f59;
        fArray[10 + n2] = f52 * f59;
        fArray[11 + n2] = f53 * f59;
        fArray[12 + n2] = f54 * f59;
        fArray[13 + n2] = f55 * f59;
        fArray[14 + n2] = f56 * f59;
        fArray[15 + n2] = f57 * f59;
        return true;
    }

    public static void orthoM(float[] fArray, int n2, float f2, float f3, float f4, float f5, float f6, float f7) {
        if (f2 == f3) {
            throw new IllegalArgumentException("left == right");
        }
        if (f4 == f5) {
            throw new IllegalArgumentException("bottom == top");
        }
        if (f6 == f7) {
            throw new IllegalArgumentException("near == far");
        }
        float f8 = 1.0f / (f3 - f2);
        float f9 = 1.0f / (f5 - f4);
        float f10 = 1.0f / (f7 - f6);
        float f11 = 2.0f * f8;
        float f12 = 2.0f * f9;
        float f13 = -2.0f * f10;
        float f14 = -(f3 + f2) * f8;
        float f15 = -(f5 + f4) * f9;
        float f16 = -(f7 + f6) * f10;
        fArray[n2 + 0] = f11;
        fArray[n2 + 5] = f12;
        fArray[n2 + 10] = f13;
        fArray[n2 + 12] = f14;
        fArray[n2 + 13] = f15;
        fArray[n2 + 14] = f16;
        fArray[n2 + 15] = 1.0f;
        fArray[n2 + 1] = 0.0f;
        fArray[n2 + 2] = 0.0f;
        fArray[n2 + 3] = 0.0f;
        fArray[n2 + 4] = 0.0f;
        fArray[n2 + 6] = 0.0f;
        fArray[n2 + 7] = 0.0f;
        fArray[n2 + 8] = 0.0f;
        fArray[n2 + 9] = 0.0f;
        fArray[n2 + 11] = 0.0f;
    }

    public static void frustumM(float[] fArray, int n2, float f2, float f3, float f4, float f5, float f6, float f7) {
        if (f2 == f3) {
            throw new IllegalArgumentException("left == right");
        }
        if (f5 == f4) {
            throw new IllegalArgumentException("top == bottom");
        }
        if (f6 == f7) {
            throw new IllegalArgumentException("near == far");
        }
        if (f6 <= 0.0f) {
            throw new IllegalArgumentException("near <= 0.0f");
        }
        if (f7 <= 0.0f) {
            throw new IllegalArgumentException("far <= 0.0f");
        }
        float f8 = 1.0f / (f3 - f2);
        float f9 = 1.0f / (f5 - f4);
        float f10 = 1.0f / (f6 - f7);
        float f11 = 2.0f * (f6 * f8);
        float f12 = 2.0f * (f6 * f9);
        float f13 = (f3 + f2) * f8;
        float f14 = (f5 + f4) * f9;
        float f15 = (f7 + f6) * f10;
        float f16 = 2.0f * (f7 * f6 * f10);
        fArray[n2 + 0] = f11;
        fArray[n2 + 5] = f12;
        fArray[n2 + 8] = f13;
        fArray[n2 + 9] = f14;
        fArray[n2 + 10] = f15;
        fArray[n2 + 14] = f16;
        fArray[n2 + 11] = -1.0f;
        fArray[n2 + 1] = 0.0f;
        fArray[n2 + 2] = 0.0f;
        fArray[n2 + 3] = 0.0f;
        fArray[n2 + 4] = 0.0f;
        fArray[n2 + 6] = 0.0f;
        fArray[n2 + 7] = 0.0f;
        fArray[n2 + 12] = 0.0f;
        fArray[n2 + 13] = 0.0f;
        fArray[n2 + 15] = 0.0f;
    }

    public static void perspectiveM(float[] fArray, int n2, float f2, float f3, float f4, float f5) {
        float f6 = 1.0f / (float)Math.tan((double)f2 * (Math.PI / 360));
        float f7 = 1.0f / (f4 - f5);
        fArray[n2 + 0] = f6 / f3;
        fArray[n2 + 1] = 0.0f;
        fArray[n2 + 2] = 0.0f;
        fArray[n2 + 3] = 0.0f;
        fArray[n2 + 4] = 0.0f;
        fArray[n2 + 5] = f6;
        fArray[n2 + 6] = 0.0f;
        fArray[n2 + 7] = 0.0f;
        fArray[n2 + 8] = 0.0f;
        fArray[n2 + 9] = 0.0f;
        fArray[n2 + 10] = (f5 + f4) * f7;
        fArray[n2 + 11] = -1.0f;
        fArray[n2 + 12] = 0.0f;
        fArray[n2 + 13] = 0.0f;
        fArray[n2 + 14] = 2.0f * f5 * f4 * f7;
        fArray[n2 + 15] = 0.0f;
    }

    public static float length(float f2, float f3, float f4) {
        return (float)Math.sqrt(f2 * f2 + f3 * f3 + f4 * f4);
    }

    public static void setIdentityM(float[] fArray, int n2) {
        int n3;
        for (n3 = 0; n3 < 16; ++n3) {
            fArray[n2 + n3] = 0.0f;
        }
        for (n3 = 0; n3 < 16; n3 += 5) {
            fArray[n2 + n3] = 1.0f;
        }
    }

    public static void scaleM(float[] fArray, int n2, float[] fArray2, int n3, float f2, float f3, float f4) {
        for (int i2 = 0; i2 < 4; ++i2) {
            int n4 = n2 + i2;
            int n5 = n3 + i2;
            fArray[n4] = fArray2[n5] * f2;
            fArray[4 + n4] = fArray2[4 + n5] * f3;
            fArray[8 + n4] = fArray2[8 + n5] * f4;
            fArray[12 + n4] = fArray2[12 + n5];
        }
    }

    public static void scaleM(float[] fArray, int n2, float f2, float f3, float f4) {
        for (int i2 = 0; i2 < 4; ++i2) {
            int n3;
            int n4 = n3 = n2 + i2;
            fArray[n4] = fArray[n4] * f2;
            int n5 = 4 + n3;
            fArray[n5] = fArray[n5] * f3;
            int n6 = 8 + n3;
            fArray[n6] = fArray[n6] * f4;
        }
    }

    public static void translateM(float[] fArray, int n2, float[] fArray2, int n3, float f2, float f3, float f4) {
        int n4;
        for (n4 = 0; n4 < 12; ++n4) {
            fArray[n2 + n4] = fArray2[n3 + n4];
        }
        for (n4 = 0; n4 < 4; ++n4) {
            int n5 = n2 + n4;
            int n6 = n3 + n4;
            fArray[12 + n5] = fArray2[n6] * f2 + fArray2[4 + n6] * f3 + fArray2[8 + n6] * f4 + fArray2[12 + n6];
        }
    }

    public static void translateM(float[] fArray, int n2, float f2, float f3, float f4) {
        for (int i2 = 0; i2 < 4; ++i2) {
            int n3 = n2 + i2;
            int n4 = 12 + n3;
            fArray[n4] = fArray[n4] + (fArray[n3] * f2 + fArray[4 + n3] * f3 + fArray[8 + n3] * f4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void rotateM(float[] fArray, int n2, float[] fArray2, int n3, float f2, float f3, float f4, float f5) {
        float[] fArray3 = sTemp;
        synchronized (sTemp) {
            Matrix.setRotateM(sTemp, 0, f2, f3, f4, f5);
            Matrix.multiplyMM(fArray, n2, fArray2, n3, sTemp, 0);
            // ** MonitorExit[var8_8] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void rotateM(float[] fArray, int n2, float f2, float f3, float f4, float f5) {
        float[] fArray2 = sTemp;
        synchronized (sTemp) {
            Matrix.setRotateM(sTemp, 0, f2, f3, f4, f5);
            Matrix.multiplyMM(sTemp, 16, fArray, n2, sTemp, 0);
            System.arraycopy(sTemp, 16, fArray, n2, 16);
            // ** MonitorExit[var6_6] (shouldn't be in output)
            return;
        }
    }

    public static void setRotateM(float[] fArray, int n2, float f2, float f3, float f4, float f5) {
        fArray[n2 + 3] = 0.0f;
        fArray[n2 + 7] = 0.0f;
        fArray[n2 + 11] = 0.0f;
        fArray[n2 + 12] = 0.0f;
        fArray[n2 + 13] = 0.0f;
        fArray[n2 + 14] = 0.0f;
        fArray[n2 + 15] = 1.0f;
        float f6 = (float)Math.sin(f2 *= (float)Math.PI / 180);
        float f7 = (float)Math.cos(f2);
        if (1.0f == f3 && 0.0f == f4 && 0.0f == f5) {
            fArray[n2 + 5] = f7;
            fArray[n2 + 10] = f7;
            fArray[n2 + 6] = f6;
            fArray[n2 + 9] = -f6;
            fArray[n2 + 1] = 0.0f;
            fArray[n2 + 2] = 0.0f;
            fArray[n2 + 4] = 0.0f;
            fArray[n2 + 8] = 0.0f;
            fArray[n2 + 0] = 1.0f;
        } else if (0.0f == f3 && 1.0f == f4 && 0.0f == f5) {
            fArray[n2 + 0] = f7;
            fArray[n2 + 10] = f7;
            fArray[n2 + 8] = f6;
            fArray[n2 + 2] = -f6;
            fArray[n2 + 1] = 0.0f;
            fArray[n2 + 4] = 0.0f;
            fArray[n2 + 6] = 0.0f;
            fArray[n2 + 9] = 0.0f;
            fArray[n2 + 5] = 1.0f;
        } else if (0.0f == f3 && 0.0f == f4 && 1.0f == f5) {
            fArray[n2 + 0] = f7;
            fArray[n2 + 5] = f7;
            fArray[n2 + 1] = f6;
            fArray[n2 + 4] = -f6;
            fArray[n2 + 2] = 0.0f;
            fArray[n2 + 6] = 0.0f;
            fArray[n2 + 8] = 0.0f;
            fArray[n2 + 9] = 0.0f;
            fArray[n2 + 10] = 1.0f;
        } else {
            float f8;
            float f9 = Matrix.length(f3, f4, f5);
            if (1.0f != f9) {
                f8 = 1.0f / f9;
                f3 *= f8;
                f4 *= f8;
                f5 *= f8;
            }
            f8 = 1.0f - f7;
            float f10 = f3 * f4;
            float f11 = f4 * f5;
            float f12 = f5 * f3;
            float f13 = f3 * f6;
            float f14 = f4 * f6;
            float f15 = f5 * f6;
            fArray[n2 + 0] = f3 * f3 * f8 + f7;
            fArray[n2 + 4] = f10 * f8 - f15;
            fArray[n2 + 8] = f12 * f8 + f14;
            fArray[n2 + 1] = f10 * f8 + f15;
            fArray[n2 + 5] = f4 * f4 * f8 + f7;
            fArray[n2 + 9] = f11 * f8 - f13;
            fArray[n2 + 2] = f12 * f8 - f14;
            fArray[n2 + 6] = f11 * f8 + f13;
            fArray[n2 + 10] = f5 * f5 * f8 + f7;
        }
    }

    public static void setRotateEulerM(float[] fArray, int n2, float f2, float f3, float f4) {
        float f5 = (float)Math.cos(f2 *= (float)Math.PI / 180);
        float f6 = (float)Math.sin(f2);
        float f7 = (float)Math.cos(f3 *= (float)Math.PI / 180);
        float f8 = (float)Math.sin(f3);
        float f9 = (float)Math.cos(f4 *= (float)Math.PI / 180);
        float f10 = (float)Math.sin(f4);
        float f11 = f5 * f8;
        float f12 = f6 * f8;
        fArray[n2 + 0] = f7 * f9;
        fArray[n2 + 1] = -f7 * f10;
        fArray[n2 + 2] = f8;
        fArray[n2 + 3] = 0.0f;
        fArray[n2 + 4] = f11 * f9 + f5 * f10;
        fArray[n2 + 5] = -f11 * f10 + f5 * f9;
        fArray[n2 + 6] = -f6 * f7;
        fArray[n2 + 7] = 0.0f;
        fArray[n2 + 8] = -f12 * f9 + f6 * f10;
        fArray[n2 + 9] = f12 * f10 + f6 * f9;
        fArray[n2 + 10] = f5 * f7;
        fArray[n2 + 11] = 0.0f;
        fArray[n2 + 12] = 0.0f;
        fArray[n2 + 13] = 0.0f;
        fArray[n2 + 14] = 0.0f;
        fArray[n2 + 15] = 1.0f;
    }

    public static void setLookAtM(float[] fArray, int n2, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10) {
        float f11 = f5 - f2;
        float f12 = f6 - f3;
        float f13 = f7 - f4;
        float f14 = 1.0f / Matrix.length(f11, f12, f13);
        float f15 = (f12 *= f14) * f10 - (f13 *= f14) * f9;
        float f16 = f13 * f8 - (f11 *= f14) * f10;
        float f17 = f11 * f9 - f12 * f8;
        float f18 = 1.0f / Matrix.length(f15, f16, f17);
        float f19 = (f16 *= f18) * f13 - (f17 *= f18) * f12;
        float f20 = f17 * f11 - (f15 *= f18) * f13;
        float f21 = f15 * f12 - f16 * f11;
        fArray[n2 + 0] = f15;
        fArray[n2 + 1] = f19;
        fArray[n2 + 2] = -f11;
        fArray[n2 + 3] = 0.0f;
        fArray[n2 + 4] = f16;
        fArray[n2 + 5] = f20;
        fArray[n2 + 6] = -f12;
        fArray[n2 + 7] = 0.0f;
        fArray[n2 + 8] = f17;
        fArray[n2 + 9] = f21;
        fArray[n2 + 10] = -f13;
        fArray[n2 + 11] = 0.0f;
        fArray[n2 + 12] = 0.0f;
        fArray[n2 + 13] = 0.0f;
        fArray[n2 + 14] = 0.0f;
        fArray[n2 + 15] = 1.0f;
        Matrix.translateM(fArray, n2, -f2, -f3, -f4);
    }
}

