/*
 * Decompiled with CFR 0.152.
 */
package com.amap.adapter.view;

import com.amap.adapter.ClassPools;
import com.amap.adapter.view.MotionEvent;
import com.amap.adapter.view.VelocityTrackerAdapter.VelocityTrackerAdapter;

public final class VelocityTracker {
    private static final ClassPools.SynchronizedPool<VelocityTracker> sPool = new ClassPools.SynchronizedPool(2);
    private static final int ACTIVE_POINTER_ID = -1;
    private long mPtr;
    private final String mStrategy;
    VelocityTrackerAdapter mVelocityTrackerAdapter = new VelocityTrackerAdapter();

    public static VelocityTracker obtain() {
        VelocityTracker velocityTracker = sPool.acquire();
        return velocityTracker != null ? velocityTracker : new VelocityTracker(null);
    }

    public static VelocityTracker obtain(String string) {
        if (string == null) {
            return VelocityTracker.obtain();
        }
        return new VelocityTracker(string);
    }

    public void recycle() {
        if (this.mStrategy == null) {
            this.clear();
            sPool.release(this);
        }
    }

    private VelocityTracker(String string) {
        this.mStrategy = string;
    }

    protected void finalize() throws Throwable {
        try {
            if (this.mPtr != 0L) {
                this.mPtr = 0L;
            }
        }
        finally {
            super.finalize();
        }
    }

    public void clear() {
        this.mVelocityTrackerAdapter.clear();
    }

    public void addMovement(MotionEvent motionEvent) {
        if (motionEvent == null) {
            throw new IllegalArgumentException("event must not be null");
        }
        this.mVelocityTrackerAdapter.addMovement(motionEvent);
    }

    public void computeCurrentVelocity(int n2, float f2) {
        this.mVelocityTrackerAdapter.computeCurrentVelocity(n2, f2);
    }

    public float getXVelocity(int n2) {
        float[] fArray = new float[1];
        float[] fArray2 = new float[1];
        this.mVelocityTrackerAdapter.getVelocity(n2, fArray, fArray2);
        return fArray[0];
    }

    public float getYVelocity(int n2) {
        float[] fArray = new float[1];
        float[] fArray2 = new float[1];
        this.mVelocityTrackerAdapter.getVelocity(n2, fArray, fArray2);
        return fArray2[0];
    }
}

