/*
 * Decompiled with CFR 0.152.
 */
package com.amap.adapter.view.VelocityTrackerAdapter;

import com.amap.adapter.util.Log;
import com.amap.adapter.view.VelocityTrackerAdapter.BitSet32;
import com.amap.adapter.view.VelocityTrackerAdapter.Estimator;
import com.amap.adapter.view.VelocityTrackerAdapter.Movement;
import com.amap.adapter.view.VelocityTrackerAdapter.Position;
import com.amap.adapter.view.VelocityTrackerAdapter.VelocityTrackerAdapter;
import com.amap.adapter.view.VelocityTrackerAdapter.Weighting;

public class LeastSquaresVelocityTrackerStrategy {
    static int HISTORY_SIZE = 20;
    static final long HORIZON = 100000000L;
    int mDegree;
    Weighting mWeighting;
    int mIndex;
    Movement[] mMovements;

    public LeastSquaresVelocityTrackerStrategy(int n2) {
        this.mDegree = n2;
        this.mWeighting = Weighting.WEIGHTING_NONE;
        this.mMovements = new Movement[HISTORY_SIZE];
        for (int i2 = 0; i2 < HISTORY_SIZE; ++i2) {
            this.mMovements[i2] = new Movement();
        }
    }

    public void clear() {
        this.mIndex = 0;
        this.mMovements[0].idBits.clear();
    }

    void clearPointers(BitSet32 bitSet32) {
        BitSet32 bitSet322;
        this.mMovements[this.mIndex].idBits = bitSet322 = new BitSet32(this.mMovements[this.mIndex].idBits.value & ~bitSet32.value);
    }

    void addMovement(long l2, BitSet32 bitSet32, Position[] positionArray) {
        if (++this.mIndex == HISTORY_SIZE) {
            this.mIndex = 0;
        }
        Movement movement = this.mMovements[this.mIndex];
        movement.eventTime = l2;
        movement.idBits = bitSet32;
        int n2 = bitSet32.count();
        for (int i2 = 0; i2 < n2; ++i2) {
            movement.positions[i2] = positionArray[i2];
        }
    }

    float chooseWeight(int n2) {
        switch (this.mWeighting) {
            case WEIGHTING_DELTA: {
                if (n2 == this.mIndex) {
                    return 1.0f;
                }
                int n3 = (n2 + 1) % HISTORY_SIZE;
                float f2 = (float)(this.mMovements[n3].eventTime - this.mMovements[n2].eventTime) * 1.0E-6f;
                if (f2 < 0.0f) {
                    return 0.5f;
                }
                if (f2 < 10.0f) {
                    return (float)(0.5 + (double)f2 * 0.05);
                }
                return 1.0f;
            }
            case WEIGHTING_CENTRAL: {
                float f3 = (float)(this.mMovements[this.mIndex].eventTime - this.mMovements[n2].eventTime) * 1.0E-6f;
                if (f3 < 0.0f) {
                    return 0.5f;
                }
                if (f3 < 10.0f) {
                    return (float)(0.5 + (double)f3 * 0.05);
                }
                if (f3 < 50.0f) {
                    return 1.0f;
                }
                if (f3 < 60.0f) {
                    return (float)(0.5 + (double)(60.0f - f3) * 0.05);
                }
                return 0.5f;
            }
            case WEIGHTING_RECENT: {
                float f4 = (float)(this.mMovements[this.mIndex].eventTime - this.mMovements[n2].eventTime) * 1.0E-6f;
                if (f4 < 50.0f) {
                    return 1.0f;
                }
                if (f4 < 100.0f) {
                    return 0.5f + (100.0f - f4) * 0.01f;
                }
                return 0.5f;
            }
        }
        return 1.0f;
    }

    float vectorDot(float[] fArray, float[] fArray2, int n2) {
        float f2 = 0.0f;
        for (int i2 = 0; i2 < n2; ++i2) {
            f2 += fArray[i2] * fArray2[i2];
        }
        return f2;
    }

    float vectorNorm(float[] fArray, int n2) {
        float f2 = 0.0f;
        for (int i2 = 0; i2 < n2; ++i2) {
            float f3 = fArray[i2];
            f2 += f3 * f3;
        }
        return (float)Math.sqrt(f2);
    }

    float solveUnweightedLeastSquaresDeg2(float[] fArray, float[] fArray2, int n2) {
        float f2;
        float f3;
        float f4;
        float f5;
        float f6;
        float f7;
        float f8 = 0.0f;
        float f9 = 0.0f;
        float f10 = 0.0f;
        float f11 = 0.0f;
        float f12 = 0.0f;
        float f13 = 0.0f;
        float f14 = 0.0f;
        for (int i2 = 0; i2 < n2; ++i2) {
            f7 = fArray[i2];
            f6 = fArray2[i2];
            f5 = f7 * f7;
            f4 = f5 * f7;
            f3 = f4 * f7;
            f2 = f5 * f6;
            float f15 = f7 * f6;
            f8 += f7;
            f11 += f5;
            f9 += f15;
            f13 += f2;
            f10 += f6;
            f12 += f4;
            f14 += f3;
        }
        float f16 = f11 - f8 * f8 / (float)n2;
        f7 = f9 - f8 * f10 / (float)n2;
        f6 = f12 - f8 * f11 / (float)n2;
        f5 = f13 - f11 * f10 / (float)n2;
        f4 = f14 - f11 * f11 / (float)n2;
        f3 = f7 * f4 - f5 * f6;
        f2 = f16 * f4 - f6 * f6;
        if (f2 == 0.0f) {
            return 0.0f;
        }
        return f3 / f2;
    }

    boolean solveLeastSquares(float[] fArray, float[] fArray2, float[] fArray3, int n2, int n3, float[] fArray4, float[] fArray5) {
        int n4;
        int n5;
        float[][] fArray6 = new float[n3][n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            fArray6[0][i2] = fArray3[i2];
            for (int i3 = 1; i3 < n3; ++i3) {
                fArray6[i3][i2] = fArray6[i3 - 1][i2] * fArray[i2];
            }
        }
        float[][] fArray7 = new float[n3][n2];
        float[][] fArray8 = new float[n3][n3];
        for (int i4 = 0; i4 < n3; ++i4) {
            int n6;
            for (n6 = 0; n6 < n2; ++n6) {
                fArray7[i4][n6] = fArray6[i4][n6];
            }
            for (n6 = 0; n6 < i4; ++n6) {
                float[] fArray9 = new float[n2];
                float[] fArray10 = new float[n2];
                for (int i5 = 0; i5 < n2; ++i5) {
                    fArray9[i5] = fArray7[i4][i5];
                    fArray10[i5] = fArray7[n6][i5];
                }
                float f2 = this.vectorDot(fArray9, fArray10, n2);
                for (int i6 = 0; i6 < n2; ++i6) {
                    float[] fArray11 = fArray7[i4];
                    int n7 = i6;
                    fArray11[n7] = fArray11[n7] - f2 * fArray7[n6][i6];
                }
            }
            float[] fArray12 = new float[n2];
            for (int i7 = 0; i7 < n2; ++i7) {
                fArray12[i7] = fArray7[i4][i7];
            }
            float f3 = this.vectorNorm(fArray12, n2);
            if (f3 < 1.0E-6f) {
                return false;
            }
            float f4 = 1.0f / f3;
            n5 = 0;
            while (n5 < n2) {
                float[] fArray13 = fArray7[i4];
                int n8 = n5++;
                fArray13[n8] = fArray13[n8] * f4;
            }
            for (n5 = 0; n5 < n3; ++n5) {
                float[] fArray14 = new float[n2];
                float[] fArray15 = new float[n2];
                for (int i8 = 0; i8 < n2; ++i8) {
                    fArray14[i8] = fArray7[i4][i8];
                    fArray15[i8] = fArray7[n5][i8];
                }
                fArray8[i4][n5] = n5 < i4 ? 0.0f : this.vectorDot(fArray14, fArray15, n2);
            }
        }
        float[] fArray16 = new float[n2];
        for (n4 = 0; n4 < n2; ++n4) {
            fArray16[n4] = fArray2[n4] * fArray3[n4];
        }
        n4 = n3;
        while (n4 != 0) {
            int n9;
            --n4;
            float[] fArray17 = new float[n2];
            for (n9 = 0; n9 < n2; ++n9) {
                fArray17[n9] = fArray7[n4][n9];
            }
            fArray4[n4] = this.vectorDot(fArray17, fArray16, n2);
            for (n9 = n3 - 1; n9 > n4; --n9) {
                int n10 = n4;
                fArray4[n10] = fArray4[n10] - fArray8[n4][n9] * fArray4[n9];
            }
            int n11 = n4;
            fArray4[n11] = fArray4[n11] / fArray8[n4][n4];
        }
        float f5 = 0.0f;
        for (int i9 = 0; i9 < n2; ++i9) {
            f5 += fArray2[i9];
        }
        f5 /= (float)n2;
        float f6 = 0.0f;
        float f7 = 0.0f;
        for (n5 = 0; n5 < n2; ++n5) {
            float f8 = fArray2[n5] - fArray4[0];
            float f9 = 1.0f;
            for (int i10 = 1; i10 < n3; ++i10) {
                f8 -= (f9 *= fArray[n5]) * fArray4[i10];
            }
            f6 += fArray3[n5] * fArray3[n5] * f8 * f8;
            float f10 = fArray2[n5] - f5;
            f7 += fArray3[n5] * fArray3[n5] * f10 * f10;
        }
        fArray5[0] = f7 > 1.0E-6f ? 1.0f - f6 / f7 : 1.0f;
        return true;
    }

    boolean getEstimator(int n2, Estimator[] estimatorArray) {
        Estimator estimator = estimatorArray[0];
        estimator.clear();
        float[] fArray = new float[HISTORY_SIZE];
        float[] fArray2 = new float[HISTORY_SIZE];
        float[] fArray3 = new float[HISTORY_SIZE];
        float[] fArray4 = new float[HISTORY_SIZE];
        int n3 = 0;
        int n4 = this.mIndex;
        Movement movement = this.mMovements[this.mIndex];
        do {
            long l2;
            Movement movement2 = this.mMovements[n4];
            if (!movement2.idBits.hasBit(n2) || (l2 = movement.eventTime - movement2.eventTime) > 100000000L) break;
            Position position = movement2.positions[movement2.idBits.getIndexOfBit(n2)];
            fArray[n3] = position.x;
            fArray2[n3] = position.y;
            fArray3[n3] = this.chooseWeight(n4);
            fArray4[n3] = (float)(-l2) * 1.0E-9f;
            Log.d(VelocityTrackerAdapter.class.getSimpleName(), "m=" + n3 + ",x[m]=" + fArray[n3] + ",y[m]=" + fArray2[n3] + ",w[m]=" + fArray3[n3] + ",time[m]=" + fArray4[n3] + ",age=" + l2);
            n4 = (n4 == 0 ? HISTORY_SIZE : n4) - 1;
        } while (++n3 < HISTORY_SIZE);
        if (n3 == 0) {
            return false;
        }
        int n5 = this.mDegree;
        if (n5 > n3 - 1) {
            n5 = n3 - 1;
        }
        if (n5 >= 1) {
            if (n5 == 2 && this.mWeighting == Weighting.WEIGHTING_NONE) {
                estimator.time = movement.eventTime;
                estimator.degree = 2;
                estimator.confidence = 1.0f;
                estimator.xCoeff[0] = 0.0f;
                estimator.yCoeff[0] = 0.0f;
                estimator.xCoeff[1] = this.solveUnweightedLeastSquaresDeg2(fArray4, fArray, n3);
                estimator.yCoeff[1] = this.solveUnweightedLeastSquaresDeg2(fArray4, fArray2, n3);
                estimator.xCoeff[2] = 0.0f;
                estimator.yCoeff[2] = 0.0f;
                return true;
            }
            float f2 = 0.0f;
            float f3 = 0.0f;
            int n6 = n5 + 1;
            float[] fArray5 = new float[]{f2};
            float[] fArray6 = new float[]{f3};
            if (this.solveLeastSquares(fArray4, fArray, fArray3, n3, n6, estimator.xCoeff, fArray5) && this.solveLeastSquares(fArray4, fArray2, fArray3, n3, n6, estimator.yCoeff, fArray6)) {
                estimator.time = movement.eventTime;
                estimator.degree = n5;
                estimator.confidence = f2 * f3;
                return true;
            }
        }
        estimator.xCoeff[0] = fArray[0];
        estimator.yCoeff[0] = fArray2[0];
        estimator.time = movement.eventTime;
        estimator.degree = 0;
        estimator.confidence = 1.0f;
        return true;
    }
}

