/*
 * Decompiled with CFR 0.152.
 */
package com.amap.adapter.view.VelocityTrackerAdapter;

import com.amap.adapter.util.Log;
import com.amap.adapter.view.MotionEvent;
import com.amap.adapter.view.VelocityTrackerAdapter.BitSet32;
import com.amap.adapter.view.VelocityTrackerAdapter.Estimator;
import com.amap.adapter.view.VelocityTrackerAdapter.LeastSquaresVelocityTrackerStrategy;
import com.amap.adapter.view.VelocityTrackerAdapter.Position;
import com.amap.adapter.view.VelocityTrackerAdapter.Velocity;

public class VelocityTrackerAdapter {
    public static final int MAX_POINTERS = 16;
    static final int MAX_POINTER_ID = 31;
    static final long NANOS_PER_MS = 1000000L;
    static final long ASSUME_POINTER_STOPPED_TIME = 40000000L;
    BitSet32 mCurrentPointerIdBits = new BitSet32(0);
    BitSet32 mCalculatedIdBits = new BitSet32(0);
    int mActivePointerId;
    LeastSquaresVelocityTrackerStrategy mStrategy = new LeastSquaresVelocityTrackerStrategy(2);
    long mLastEventTime;
    Velocity[] mCalculatedVelocity = new Velocity[16];

    public VelocityTrackerAdapter() {
        for (int i2 = 0; i2 < 16; ++i2) {
            this.mCalculatedVelocity[i2] = new Velocity();
        }
    }

    void clearPointers(BitSet32 bitSet32) {
        BitSet32 bitSet322;
        this.mCurrentPointerIdBits = bitSet322 = new BitSet32(this.mCurrentPointerIdBits.value & ~bitSet32.value);
        if (this.mActivePointerId >= 0 && bitSet32.hasBit(this.mActivePointerId)) {
            this.mActivePointerId = !bitSet322.isEmpty() ? bitSet322.firstMarkedBit() : -1;
        }
        this.mStrategy.clearPointers(bitSet32);
    }

    public void addMovement(MotionEvent motionEvent) {
        int n2 = motionEvent.getAction() & 0xFF;
        switch (n2) {
            case 1: {
                this.clear();
                break;
            }
            case 4: {
                BitSet32 bitSet32 = new BitSet32(0);
                bitSet32.markBit(motionEvent.getPointerId(motionEvent.getActionIndex()));
                this.clearPointers(bitSet32);
                break;
            }
            case 3: {
                break;
            }
            default: {
                return;
            }
        }
        int n3 = motionEvent.getPointerCount();
        if (n3 > 16) {
            n3 = 16;
        }
        BitSet32 bitSet32 = new BitSet32(0);
        for (int i2 = 0; i2 < n3; ++i2) {
            bitSet32.markBit(motionEvent.getPointerId(i2));
        }
        int[] nArray = new int[16];
        for (int i3 = 0; i3 < n3; ++i3) {
            nArray[i3] = bitSet32.getIndexOfBit(motionEvent.getPointerId(i3));
        }
        Position[] positionArray = new Position[n3];
        for (int i4 = 0; i4 < n3; ++i4) {
            positionArray[i4] = new Position();
        }
        long l2 = motionEvent.getEventTime() * 1000000L;
        for (int i5 = 0; i5 < n3; ++i5) {
            int n4 = nArray[i5];
            positionArray[n4].x = motionEvent.getX(i5);
            positionArray[n4].y = motionEvent.getY(i5);
        }
        Log.d(VelocityTrackerAdapter.class.getSimpleName(), "event=" + motionEvent.toString());
        this.addMovement(l2, bitSet32, positionArray);
    }

    void addMovement(long l2, BitSet32 bitSet32, Position[] positionArray) {
        while (bitSet32.count() > 16) {
            bitSet32.clearLastMarkedBit();
        }
        if ((this.mCurrentPointerIdBits.value & bitSet32.value) > 0 && l2 >= this.mLastEventTime + 40000000L) {
            this.mStrategy.clear();
        }
        this.mLastEventTime = l2;
        this.mCurrentPointerIdBits = bitSet32;
        if (this.mActivePointerId < 0 || !bitSet32.hasBit(this.mActivePointerId)) {
            this.mActivePointerId = bitSet32.isEmpty() ? -1 : bitSet32.firstMarkedBit();
        }
        this.mStrategy.addMovement(l2, bitSet32, positionArray);
    }

    boolean getEstimator(int n2, Estimator[] estimatorArray) {
        return this.mStrategy.getEstimator(n2, estimatorArray);
    }

    boolean getVelocityIn(int n2, float[] fArray, float[] fArray2) {
        Estimator estimator = new Estimator();
        Estimator[] estimatorArray = new Estimator[]{estimator};
        if (this.getEstimator(n2, estimatorArray) && estimator.degree >= 1) {
            fArray[0] = estimator.xCoeff[1];
            fArray2[0] = estimator.yCoeff[1];
            return true;
        }
        fArray[0] = 0.0f;
        fArray2[0] = 0.0f;
        return false;
    }

    public void computeCurrentVelocity(int n2, float f2) {
        BitSet32 bitSet32 = new BitSet32(this.mCurrentPointerIdBits.value);
        this.mCalculatedIdBits = new BitSet32(bitSet32.value);
        int n3 = 0;
        while (!bitSet32.isEmpty()) {
            int n4 = bitSet32.clearFirstMarkedBit();
            float[] fArray = new float[1];
            float[] fArray2 = new float[1];
            this.getVelocityIn(n4, fArray, fArray2);
            float f3 = fArray[0];
            float f4 = fArray2[0];
            f3 = f3 * (float)n2 / 1000.0f;
            f4 = f4 * (float)n2 / 1000.0f;
            if (f3 > f2) {
                f3 = f2;
            } else if (f3 < -f2) {
                f3 = -f2;
            }
            if (f4 > f2) {
                f4 = f2;
            } else if (f4 < -f2) {
                f4 = -f2;
            }
            Velocity velocity = this.mCalculatedVelocity[n3];
            velocity.vx = f3;
            velocity.vy = f4;
            ++n3;
        }
    }

    public void getVelocity(int n2, float[] fArray, float[] fArray2) {
        float f2;
        float f3;
        if (n2 >= 0 && n2 <= 31 && this.mCalculatedIdBits.hasBit(n2)) {
            int n3 = this.mCalculatedIdBits.getIndexOfBit(n2);
            Velocity velocity = this.mCalculatedVelocity[n3];
            f3 = velocity.vx;
            f2 = velocity.vy;
        } else {
            f3 = 0.0f;
            f2 = 0.0f;
        }
        if (fArray != null) {
            fArray[0] = f3;
        }
        if (fArray2 != null) {
            fArray2[0] = f2;
        }
    }

    public void clear() {
        this.clearIn();
        this.mActivePointerId = -1;
        this.mCalculatedIdBits.clear();
    }

    void clearIn() {
        this.mCurrentPointerIdBits.clear();
        this.mActivePointerId = -1;
        this.mStrategy.clear();
    }
}

