/*
 * Decompiled with CFR 0.152.
 */
package com.amap.adapter.view;

import com.amap.adapter.content.Context;
import com.amap.adapter.util.DisplayMetrics;
import java.util.HashMap;

public class ViewConfiguration {
    private static final int EDGE_SLOP = 12;
    private static final int TOUCH_SLOP = 8;
    private static final int DOUBLE_TAP_TOUCH_SLOP = 8;
    private static final int DOUBLE_TAP_SLOP = 100;
    private static final int MINIMUM_FLING_VELOCITY = 50;
    private static final int MAXIMUM_FLING_VELOCITY = 8000;
    private static final int TAP_TIMEOUT = 100;
    private static final int DOUBLE_TAP_MIN_TIME = 40;
    private static final int DOUBLE_TAP_TIMEOUT = 300;
    private static final int DEFAULT_LONG_PRESS_TIMEOUT = 500;
    private final Context mContext;
    private final int mEdgeSlop;
    static final HashMap<Integer, ViewConfiguration> sConfigurations = new HashMap();

    public ViewConfiguration(Context context) {
        this.mContext = context;
        this.mEdgeSlop = 12;
    }

    public static ViewConfiguration get(Context context) {
        DisplayMetrics displayMetrics = context.getResources().getDisplayMetrics();
        int n2 = (int)(100.0f * displayMetrics.density);
        ViewConfiguration viewConfiguration = sConfigurations.get(n2);
        if (viewConfiguration == null) {
            viewConfiguration = new ViewConfiguration(context);
            sConfigurations.put(n2, viewConfiguration);
        }
        return viewConfiguration;
    }

    public static int getLongPressTimeout() {
        return 500;
    }

    public static int getTapTimeout() {
        return 100;
    }

    public static int getDoubleTapTimeout() {
        return 300;
    }

    public static int getDoubleTapMinTime() {
        return 40;
    }

    public float getScaledEdgeSlop() {
        return this.mEdgeSlop;
    }

    public int getScaledTouchSlop() {
        return 8;
    }

    public int getScaledDoubleTapTouchSlop() {
        return 8;
    }

    public int getScaledDoubleTapSlop() {
        return 100;
    }

    public int getScaledMinimumFlingVelocity() {
        return 50;
    }

    public int getScaledMaximumFlingVelocity() {
        return 8000;
    }
}

