/*
 * Decompiled with CFR 0.152.
 */
package com.amap.api.maps;

import com.amap.api.maps.AMapException;
import com.amap.api.maps.model.LatLng;
import java.util.List;

public class AMapUtils {
    private static final String AMAPNAVIURL = "androidamap://navi?sourceApplication=%s&lat=%f&lon=%f&dev=0&style=%d";
    private static final String AMAPPOISEARCHURL = "androidamap://arroundpoi?sourceApplication=%s&keywords=%s&dev=0";
    private static final String AMAPROUTEURL = "androidamap://route?sourceApplication=%s&slat=%f&slon=%f&sname=%s&dlat=%f&dlon=%f&dname=%s&dev=0&t=%d";
    private static final int TRANSIT_ROUTE_MODEL = 1;
    private static final int DRING_ROUTE_MODEL = 2;
    public static final int DRIVING_DEFAULT = 0;
    public static final int DRIVING_SAVE_MONEY = 1;
    public static final int DRIVING_SHORT_DISTANCE = 2;
    public static final int DRIVING_NO_HIGHWAY = 3;
    public static final int DRIVING_AVOID_CONGESTION = 4;
    public static final int DRIVING_NO_HIGHWAY_AVOID_SHORT_MONEY = 5;
    public static final int DRIVING_NO_HIGHWAY_AVOID_CONGESTION = 6;
    public static final int DRIVING_SAVE_MONEY_AVOID_CONGESTION = 7;
    public static final int DRIVING_NO_HIGHWAY_SAVE_MONEY_AVOID_CONGESTION = 8;
    public static final int BUS_TIME_FIRST = 0;
    public static final int BUS_MONEY_LITTLE = 1;
    public static final int BUS_TRANSFER_LITTLE = 2;
    public static final int BUS_WALK_LITTLE = 3;
    public static final int BUS_COMFORT = 4;
    public static final int BUS_NO_SUBWAY = 5;
    private static final double EARTHRADIUS = 6378137.0;
    private static final double DEG_TO_RAD = Math.PI / 180;
    private static final double R = 6378137.0;
    private static final double NF_PI = 0.01745329251994329;

    public static float calculateLineDistance(LatLng latLng, LatLng latLng2) {
        if (latLng == null || latLng2 == null) {
            try {
                throw new AMapException("\u975e\u6cd5\u5750\u6807\u503c");
            }
            catch (AMapException aMapException) {
                aMapException.printStackTrace();
                return 0.0f;
            }
        }
        try {
            double d2 = latLng.longitude;
            double d3 = latLng.latitude;
            double d4 = latLng2.longitude;
            double d5 = latLng2.latitude;
            d4 *= 0.01745329251994329;
            d5 *= 0.01745329251994329;
            double d6 = Math.sin(d2 *= 0.01745329251994329);
            double d7 = Math.sin(d3 *= 0.01745329251994329);
            double d8 = Math.cos(d2);
            double d9 = Math.cos(d3);
            double d10 = Math.sin(d4);
            double d11 = Math.sin(d5);
            double d12 = Math.cos(d4);
            double d13 = Math.cos(d5);
            double[] dArray = new double[3];
            double[] dArray2 = new double[3];
            dArray[0] = d9 * d8;
            dArray[1] = d9 * d6;
            dArray[2] = d7;
            dArray2[0] = d13 * d12;
            dArray2[1] = d13 * d10;
            dArray2[2] = d11;
            double d14 = Math.sqrt((dArray[0] - dArray2[0]) * (dArray[0] - dArray2[0]) + (dArray[1] - dArray2[1]) * (dArray[1] - dArray2[1]) + (dArray[2] - dArray2[2]) * (dArray[2] - dArray2[2]));
            return (float)(Math.asin(d14 / 2.0) * 1.27420015798544E7);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return 0.0f;
        }
    }

    public static float calculateArea(LatLng latLng, LatLng latLng2) {
        if (latLng == null || latLng2 == null) {
            try {
                throw new AMapException("\u975e\u6cd5\u5750\u6807\u503c");
            }
            catch (AMapException aMapException) {
                aMapException.printStackTrace();
                return 0.0f;
            }
        }
        try {
            double d2 = Math.sin(latLng.latitude * Math.PI / 180.0) - Math.sin(latLng2.latitude * Math.PI / 180.0);
            double d3 = (latLng2.longitude - latLng.longitude) / 360.0;
            if (d3 < 0.0) {
                d3 += 1.0;
            }
            return (float)(2.5560394669790553E14 * d2 * d3);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return 0.0f;
        }
    }

    public static float calculateArea(List<LatLng> list) {
        int n2 = 3;
        if (list == null || list.size() < n2) {
            return 0.0f;
        }
        double d2 = 0.0;
        double d3 = 111319.49079327357;
        int n3 = list.size();
        for (int i2 = 0; i2 < n3; ++i2) {
            LatLng latLng = list.get(i2);
            LatLng latLng2 = list.get((i2 + 1) % n3);
            double d4 = latLng.longitude * d3 * Math.cos(latLng.latitude * (Math.PI / 180));
            double d5 = latLng.latitude * d3;
            double d6 = latLng2.longitude * d3 * Math.cos(latLng2.latitude * (Math.PI / 180));
            double d7 = latLng2.latitude * d3;
            d2 += d4 * d7 - d6 * d5;
        }
        return (float)Math.abs(d2 / 2.0);
    }
}

