/*
 * Decompiled with CFR 0.152.
 */
package com.amap.api.maps.model;

import com.amap.adapter.content.Context;
import com.amap.adapter.graphics.Bitmap;
import com.amap.adapter.graphics.BitmapFactory;
import com.amap.adapter.view.View;
import com.amap.adapter.widget.FrameLayout;
import com.amap.api.mapcore.util.ea;
import com.amap.api.mapcore.util.es;
import com.amap.api.mapcore.util.ey;
import com.amap.api.mapcore.util.ez;
import com.amap.api.mapcore.util.t;
import com.amap.api.maps.model.BitmapDescriptor;
import java.io.FileInputStream;
import java.io.InputStream;

public final class BitmapDescriptorFactory {
    private static final String ICON_ID_PREFIX = "com.amap.api.icon_";
    private static int nextId = 0;
    public static final float HUE_RED = 0.0f;
    public static final float HUE_ORANGE = 30.0f;
    public static final float HUE_YELLOW = 60.0f;
    public static final float HUE_GREEN = 120.0f;
    public static final float HUE_CYAN = 180.0f;
    public static final float HUE_AZURE = 210.0f;
    public static final float HUE_BLUE = 240.0f;
    public static final float HUE_VIOLET = 270.0f;
    public static final float HUE_MAGENTA = 300.0f;
    public static final float HUE_ROSE = 330.0f;

    public static BitmapDescriptor fromResource(int n2) {
        try {
            Context context = BitmapDescriptorFactory.getContext();
            if (context != null) {
                InputStream inputStream = context.getResources().openRawResource(n2);
                Bitmap bitmap = BitmapFactory.decodeStream(inputStream);
                BitmapDescriptor bitmapDescriptor = BitmapDescriptorFactory.fromBitmap(bitmap);
                return bitmapDescriptor;
            }
            return null;
        }
        catch (Throwable throwable) {
            es.a(throwable);
            ez.b(ey.f, "read bitmap from res failed " + throwable.getMessage());
            return null;
        }
    }

    public static BitmapDescriptor fromView(View view) {
        try {
            Context context = BitmapDescriptorFactory.getContext();
            if (context != null) {
                FrameLayout frameLayout = new FrameLayout(context);
                frameLayout.addView(view);
                frameLayout.setDrawingCacheEnabled(true);
                Bitmap bitmap = es.a(frameLayout.getView());
                BitmapDescriptor bitmapDescriptor = BitmapDescriptorFactory.fromBitmap(bitmap);
                return bitmapDescriptor;
            }
            return null;
        }
        catch (Throwable throwable) {
            es.a(throwable);
            ez.b(ey.f, "read bitmap from view failed " + throwable.getMessage());
            return null;
        }
    }

    public static BitmapDescriptor fromPath(String string) {
        try {
            Bitmap bitmap = BitmapFactory.decodeFile(string);
            BitmapDescriptor bitmapDescriptor = BitmapDescriptorFactory.fromBitmap(bitmap);
            return bitmapDescriptor;
        }
        catch (Throwable throwable) {
            es.a(throwable);
            ez.b(ey.f, "read bitmap from disk failed " + throwable.getMessage());
            return null;
        }
    }

    public static BitmapDescriptor fromAsset(String string) {
        try {
            Context context = BitmapDescriptorFactory.getContext();
            if (context != null) {
                return BitmapDescriptorFactory.fromBitmap(es.a(context, string));
            }
            InputStream inputStream = BitmapDescriptorFactory.class.getResourceAsStream("/assets/" + string);
            Bitmap bitmap = BitmapFactory.decodeStream(inputStream);
            inputStream.close();
            BitmapDescriptor bitmapDescriptor = BitmapDescriptorFactory.fromBitmap(bitmap);
            return bitmapDescriptor;
        }
        catch (Throwable throwable) {
            es.a(throwable);
            ez.b(ey.f, "read bitmap from assets failed " + throwable.getMessage());
            return null;
        }
    }

    public static BitmapDescriptor fromFile(String string) {
        try {
            Context context = BitmapDescriptorFactory.getContext();
            if (context != null) {
                FileInputStream fileInputStream = context.openFileInput(string);
                Bitmap bitmap = BitmapFactory.decodeStream(fileInputStream);
                fileInputStream.close();
                BitmapDescriptor bitmapDescriptor = BitmapDescriptorFactory.fromBitmap(bitmap);
                es.b(bitmap);
                return bitmapDescriptor;
            }
            return null;
        }
        catch (Throwable throwable) {
            es.a(throwable);
            ez.b(ey.f, "read bitmap from disk failed " + throwable.getMessage());
            return null;
        }
    }

    public static BitmapDescriptor defaultMarker() {
        try {
            return BitmapDescriptorFactory.fromAsset(ea.a.b.name() + ".png");
        }
        catch (Throwable throwable) {
            es.a(throwable);
            return null;
        }
    }

    public static BitmapDescriptor defaultMarker(float f2) {
        try {
            f2 = (int)(f2 + 15.0f) / 30 * 30;
            int n2 = 330;
            if (f2 > (float)n2) {
                f2 = n2;
            } else if (f2 < 0.0f) {
                f2 = 0.0f;
            }
            String string = "";
            if (f2 == 0.0f) {
                string = "RED";
            } else if (f2 == 30.0f) {
                string = "ORANGE";
            } else if (f2 == 60.0f) {
                string = "YELLOW";
            } else if (f2 == 120.0f) {
                string = "GREEN";
            } else if (f2 == 180.0f) {
                string = "CYAN";
            } else if (f2 == 210.0f) {
                string = "AZURE";
            } else if (f2 == 240.0f) {
                string = "BLUE";
            } else if (f2 == 270.0f) {
                string = "VIOLET";
            } else if (f2 == 300.0f) {
                string = "MAGENTA";
            } else if (f2 == 330.0f) {
                string = "ROSE";
            }
            return BitmapDescriptorFactory.fromAsset(string + ".png");
        }
        catch (Throwable throwable) {
            es.a(throwable);
            return null;
        }
    }

    public static BitmapDescriptor fromBitmap(Bitmap bitmap) {
        if (bitmap == null) {
            return null;
        }
        BitmapDescriptor bitmapDescriptor = null;
        try {
            if (nextId == Integer.MAX_VALUE) {
                nextId = 0;
            }
            String string = ICON_ID_PREFIX + ++nextId;
            bitmapDescriptor = new BitmapDescriptor(bitmap, string);
            return bitmapDescriptor;
        }
        catch (Throwable throwable) {
            es.a(throwable);
            ez.b(ey.f, "read bitmap from bitmap failed " + throwable.getMessage());
            return bitmapDescriptor;
        }
    }

    public static Context getContext() {
        Context context = t.a;
        return context;
    }
}

