/*
 * Decompiled with CFR 0.152.
 */
package com.amap.api.maps.model;

import com.amap.adapter.text.TextUtils;
import com.amap.api.maps.interfaces.IGlOverlayLayer;
import com.amap.api.maps.model.BasePointOverlay;
import com.amap.api.maps.model.GL3DModelOptions;
import com.amap.api.maps.model.LatLng;
import com.amap.api.maps.model.animation.Animation;
import com.autonavi.amap.mapcore.IPoint;
import com.autonavi.amap.mapcore.interfaces.IglModel;
import java.lang.ref.WeakReference;

public class GL3DModel
extends BasePointOverlay {
    private IglModel mModel;
    private GL3DModelOptions options;
    private WeakReference<IGlOverlayLayer> glOverlayLayerRef;
    private Object object;

    public GL3DModel(IglModel iglModel) {
        super("");
        this.mModel = iglModel;
    }

    public GL3DModel(IGlOverlayLayer iGlOverlayLayer, GL3DModelOptions gL3DModelOptions, String string) {
        super(string);
        this.glOverlayLayerRef = new WeakReference<IGlOverlayLayer>(iGlOverlayLayer);
        this.options = gL3DModelOptions;
    }

    @Override
    public void setPosition(LatLng latLng) {
        try {
            if (this.mModel != null) {
                this.mModel.setPosition(latLng);
            } else {
                this.options.position(latLng);
                this.a();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void setAngle(float f2) {
        try {
            if (this.mModel != null) {
                this.mModel.setRotateAngle(f2);
            } else {
                this.options.angle(f2);
                this.a();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public float getAngle() {
        try {
            if (this.mModel != null) {
                return this.mModel.getRotateAngle();
            }
            return this.options.getAngle();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return 0.0f;
        }
    }

    @Override
    public LatLng getPosition() {
        try {
            if (this.mModel != null) {
                return this.mModel.getPosition();
            }
            return this.options.getLatLng();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    @Override
    public String getId() {
        try {
            if (this.mModel != null) {
                return this.mModel.getId();
            }
            return this.overlayName;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return "";
        }
    }

    @Override
    public void setAnimation(Animation animation) {
        try {
            if (this.mModel != null) {
                this.mModel.setAnimation(animation);
            } else {
                this.a("setAnimation", new Object[]{animation});
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    @Override
    public boolean startAnimation() {
        if (this.mModel != null) {
            return this.mModel.startAnimation();
        }
        Object object = this.a("startAnimation", null);
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        return false;
    }

    public void setModelFixedLength(int n2) {
        try {
            if (this.mModel != null) {
                this.mModel.setModelFixedLength(n2);
            } else {
                this.options.setModelFixedLength(n2);
                this.a();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public void remove() {
        try {
            if (this.mModel != null) {
                this.mModel.remove();
            } else {
                IGlOverlayLayer iGlOverlayLayer = (IGlOverlayLayer)this.glOverlayLayerRef.get();
                if (iGlOverlayLayer != null) {
                    iGlOverlayLayer.removeOverlay(this.overlayName);
                }
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    @Override
    public boolean isVisible() {
        try {
            if (this.mModel != null) {
                return this.mModel.isVisible();
            }
            return this.options.isVisible();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    @Override
    public void setVisible(boolean bl2) {
        try {
            if (this.mModel != null) {
                this.mModel.setVisible(bl2);
            } else {
                this.options.setVisible(bl2);
                this.a();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public void setObject(Object object) {
        try {
            if (this.mModel != null) {
                this.mModel.setObject(object);
            } else {
                this.object = object;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public Object getObject() {
        if (this.mModel != null) {
            return this.mModel.getObject();
        }
        return this.object;
    }

    @Override
    public void setRotateAngle(float f2) {
        try {
            this.setAngle(f2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public float getRotateAngle() {
        try {
            return this.getAngle();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return 0.0f;
        }
    }

    public void setZoomLimit(float f2) {
        if (this.mModel != null) {
            this.mModel.setZoomLimit(f2);
        }
    }

    @Override
    public void destroy() {
        if (this.mModel != null) {
            this.mModel.destroy();
        } else {
            this.remove();
        }
    }

    @Override
    public void setGeoPoint(IPoint iPoint) {
        if (this.mModel != null) {
            this.mModel.setGeoPoint(iPoint);
        }
    }

    @Override
    public void setTitle(String string) {
        if (this.mModel != null) {
            this.mModel.setTitle(string);
        } else if (this.options != null) {
            this.options.title(string);
            this.a();
        }
    }

    @Override
    public String getTitle() {
        try {
            if (this.mModel != null) {
                return this.mModel.getTitle();
            }
            if (this.options != null) {
                return this.options.getTitle();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return "";
    }

    @Override
    public String getSnippet() {
        try {
            if (this.mModel != null) {
                return this.mModel.getSnippet();
            }
            if (this.options != null) {
                return this.options.getSnippet();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return "";
    }

    @Override
    public void setSnippet(String string) {
        if (this.mModel != null) {
            this.mModel.setSnippet(string);
        } else if (this.options != null) {
            this.options.snippet(string);
            this.a();
        }
    }

    @Override
    public void showInfoWindow() {
        try {
            if (this.mModel != null) {
                this.mModel.showInfoWindow();
            } else {
                IGlOverlayLayer iGlOverlayLayer = (IGlOverlayLayer)this.glOverlayLayerRef.get();
                if (!TextUtils.isEmpty(this.overlayName) && iGlOverlayLayer != null) {
                    iGlOverlayLayer.showInfoWindow(this.overlayName);
                }
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    @Override
    public boolean isInfoWindowEnable() {
        return true;
    }

    private void a() {
        try {
            IGlOverlayLayer iGlOverlayLayer = (IGlOverlayLayer)this.glOverlayLayerRef.get();
            if (!TextUtils.isEmpty(this.overlayName) && iGlOverlayLayer != null && iGlOverlayLayer != null) {
                iGlOverlayLayer.updateOption(this.overlayName, this.options);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private Object a(String string, Object[] objectArray) {
        try {
            IGlOverlayLayer iGlOverlayLayer = (IGlOverlayLayer)this.glOverlayLayerRef.get();
            if (!TextUtils.isEmpty(this.overlayName) && iGlOverlayLayer != null) {
                return iGlOverlayLayer.getNativeProperties(this.overlayName, string, objectArray);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }
}

