/*
 * Decompiled with CFR 0.152.
 */
package com.amap.api.maps.model;

import com.amap.api.maps.model.BaseOptions;
import com.amap.api.maps.model.BitmapDescriptor;
import com.amap.api.maps.model.LatLng;
import com.autonavi.base.amap.mapcore.jbinding.JBindingInclude;
import java.util.ArrayList;
import java.util.List;

@JBindingInclude
public class GL3DModelOptions
extends BaseOptions {
    @JBindingInclude
    private float rotate;
    @JBindingInclude
    private LatLng latLng;
    private List<Float> vertextList = new ArrayList<Float>();
    private List<Float> textrueList = new ArrayList<Float>();
    @JBindingInclude
    private boolean isModeltUpdate = false;
    @JBindingInclude
    private String modelData;
    @JBindingInclude
    private BitmapDescriptor bitmapDescriptor;
    @JBindingInclude
    private int fixedLength = 50;
    @JBindingInclude
    private boolean visibile = true;
    @JBindingInclude
    private String title;
    @JBindingInclude
    private String snippet;

    public GL3DModelOptions() {
        this.type = "GL3DModelOptions";
    }

    public GL3DModelOptions textureDrawable(BitmapDescriptor bitmapDescriptor) {
        this.bitmapDescriptor = bitmapDescriptor;
        return this;
    }

    public GL3DModelOptions vertexData(String string) {
        if (string != null && string.length() > 0) {
            this.modelData = string;
            this.isModeltUpdate = true;
        }
        return this;
    }

    public GL3DModelOptions vertexData(List<Float> list, List<Float> list2) {
        int n2;
        int n3;
        this.vertextList = list;
        this.textrueList = list2;
        StringBuilder stringBuilder = new StringBuilder();
        if (this.vertextList != null) {
            n3 = 3;
            for (n2 = 0; n2 < this.vertextList.size() - n3; n2 += n3) {
                stringBuilder.append("v ");
                stringBuilder.append(this.vertextList.get(n2)).append(" ");
                stringBuilder.append(this.vertextList.get(n2 + 1)).append(" ");
                stringBuilder.append(this.vertextList.get(n2 + 2));
                stringBuilder.append("\n");
            }
        }
        if (this.textrueList != null) {
            n3 = 2;
            for (n2 = 0; n2 < this.textrueList.size() - n3; n2 += n3) {
                stringBuilder.append("vt ");
                stringBuilder.append(this.textrueList.get(n2)).append(" ");
                stringBuilder.append(1.0f - this.textrueList.get(n2 + 1).floatValue());
                stringBuilder.append("\n");
            }
        }
        this.vertexData(stringBuilder.toString());
        return this;
    }

    public GL3DModelOptions position(LatLng latLng) {
        this.latLng = latLng;
        return this;
    }

    public GL3DModelOptions angle(float f2) {
        this.rotate = f2;
        return this;
    }

    public List<Float> getVertext() {
        return this.vertextList;
    }

    public List<Float> getTextrue() {
        return this.textrueList;
    }

    public float getAngle() {
        return this.rotate;
    }

    public LatLng getLatLng() {
        return this.latLng;
    }

    public BitmapDescriptor getBitmapDescriptor() {
        return this.bitmapDescriptor;
    }

    public GL3DModelOptions setModelFixedLength(int n2) {
        this.fixedLength = n2;
        return this;
    }

    public int getModelFixedLength() {
        return this.fixedLength;
    }

    public GL3DModelOptions setVisible(boolean bl2) {
        this.visibile = bl2;
        return this;
    }

    public boolean isVisible() {
        return this.visibile;
    }

    public GL3DModelOptions title(String string) {
        this.title = string;
        return this;
    }

    public GL3DModelOptions snippet(String string) {
        this.snippet = string;
        return this;
    }

    public String getTitle() {
        return this.title;
    }

    public String getSnippet() {
        return this.snippet;
    }
}

