/*
 * Decompiled with CFR 0.152.
 */
package com.amap.api.maps.model;

import com.amap.adapter.graphics.Bitmap;
import com.amap.adapter.graphics.Color;
import com.amap.adapter.util.Log;
import com.amap.adapter.util.LongSparseArray;
import com.amap.api.mapcore.util.dv;
import com.amap.api.maps.AMapException;
import com.amap.api.maps.model.Gradient;
import com.amap.api.maps.model.LatLng;
import com.amap.api.maps.model.Tile;
import com.amap.api.maps.model.TileProvider;
import com.amap.api.maps.model.WeightedLatLng;
import com.amap.api.maps.model.a;
import com.autonavi.amap.mapcore.DPoint;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class HeatmapTileProvider
implements TileProvider {
    public static final int DEFAULT_RADIUS = 12;
    public static final double DEFAULT_OPACITY = 0.6;
    private static final int[] DEFAULT_GRADIENT_COLORS = new int[]{Color.rgb(102, 225, 0), Color.rgb(255, 0, 0)};
    private static final float[] DEFAULT_GRADIENT_START_POINTS = new float[]{0.2f, 1.0f};
    public static final Gradient DEFAULT_GRADIENT = new Gradient(DEFAULT_GRADIENT_COLORS, DEFAULT_GRADIENT_START_POINTS);
    private static final int TILE_DIM = 256;
    private static final int SCREEN_SIZE = 1280;
    private static final int DEFAULT_MIN_ZOOM = 5;
    private static final int DEFAULT_MAX_ZOOM = 11;
    private static final int MAX_ZOOM_LEVEL = 21;
    private static final int MIN_RADIUS = 10;
    private static final int MAX_RADIUS = 50;
    private a mTree;
    private Collection<WeightedLatLng> mData;
    private dv mBounds;
    private int mRadius;
    private Gradient mGradient;
    private int[] mColorMap;
    private double[] mKernel;
    private double mOpacity;
    private double[] mMaxIntensity;

    private HeatmapTileProvider(Builder builder) {
        this.mData = builder.data;
        this.mRadius = builder.radius;
        this.mGradient = builder.gradient;
        if (this.mGradient == null || !this.mGradient.isAvailable()) {
            this.mGradient = DEFAULT_GRADIENT;
        }
        this.mOpacity = builder.opacity;
        this.mKernel = HeatmapTileProvider.a(this.mRadius, (double)this.mRadius / 3.0);
        this.a(this.mGradient);
        this.c(this.mData);
    }

    private void c(Collection<WeightedLatLng> collection) {
        try {
            ArrayList<WeightedLatLng> arrayList = new ArrayList<WeightedLatLng>();
            for (WeightedLatLng weightedLatLng : collection) {
                if (!(weightedLatLng.latLng.latitude < 85.0) || !(weightedLatLng.latLng.latitude > -85.0)) continue;
                arrayList.add(weightedLatLng);
            }
            this.mData = arrayList;
            this.mBounds = HeatmapTileProvider.a(this.mData);
            this.mTree = new a(this.mBounds);
            for (WeightedLatLng weightedLatLng : this.mData) {
                this.mTree.a(weightedLatLng);
            }
            this.mMaxIntensity = this.a(this.mRadius);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    private static Collection<WeightedLatLng> d(Collection<LatLng> collection) {
        ArrayList<WeightedLatLng> arrayList = new ArrayList<WeightedLatLng>();
        for (LatLng latLng : collection) {
            arrayList.add(new WeightedLatLng(latLng));
        }
        return arrayList;
    }

    @Override
    public Tile getTile(int n2, int n3, int n4) {
        int n5;
        int n6;
        DPoint dPoint;
        dv dv2;
        double d2 = 1.0 / Math.pow(2.0, n4);
        double d3 = d2 * (double)this.mRadius / 256.0;
        double d4 = d2 + 2.0 * d3;
        double d5 = d4 / (double)(256 + this.mRadius * 2);
        double d6 = (double)n2 * d2 - d3;
        double d7 = (double)(n2 + 1) * d2 + d3;
        double d8 = (double)n3 * d2 - d3;
        double d9 = (double)(n3 + 1) * d2 + d3;
        double d10 = 0.0;
        Collection<Object> collection = new ArrayList();
        if (d6 < 0.0) {
            dv2 = new dv(d6 + 1.0, 1.0, d8, d9);
            d10 = -1.0;
            collection = this.mTree.a(dv2);
        } else if (d7 > 1.0) {
            dv2 = new dv(0.0, d7 - 1.0, d8, d9);
            d10 = 1.0;
            collection = this.mTree.a(dv2);
        }
        dv2 = new dv(d6, d7, d8, d9);
        dv dv3 = new dv(this.mBounds.a - d3, this.mBounds.c + d3, this.mBounds.b - d3, this.mBounds.d + d3);
        if (!dv2.a(dv3)) {
            return TileProvider.NO_TILE;
        }
        Collection<WeightedLatLng> collection2 = this.mTree.a(dv2);
        if (collection2.isEmpty()) {
            return TileProvider.NO_TILE;
        }
        double[][] dArray = new double[256 + this.mRadius * 2][256 + this.mRadius * 2];
        for (WeightedLatLng object2 : collection2) {
            dPoint = object2.getPoint();
            n6 = (int)((dPoint.x - d6) / d5);
            n5 = (int)((dPoint.y - d8) / d5);
            double[] dArray2 = dArray[n6];
            int n7 = n5;
            dArray2[n7] = dArray2[n7] + object2.intensity;
        }
        for (WeightedLatLng weightedLatLng : collection) {
            dPoint = weightedLatLng.getPoint();
            n6 = (int)((dPoint.x + d10 - d6) / d5);
            n5 = (int)((dPoint.y - d8) / d5);
            double[] dArray3 = dArray[n6];
            int n8 = n5;
            dArray3[n8] = dArray3[n8] + weightedLatLng.intensity;
        }
        Object object3 = HeatmapTileProvider.a(dArray, this.mKernel);
        Bitmap bitmap = HeatmapTileProvider.a((double[][])object3, this.mColorMap, this.mMaxIntensity[n4]);
        return HeatmapTileProvider.a(bitmap);
    }

    private void a(Gradient gradient) {
        this.mGradient = gradient;
        this.mColorMap = gradient.generateColorMap(this.mOpacity);
    }

    private double[] a(int n2) {
        int n3;
        double[] dArray = new double[21];
        for (n3 = 5; n3 < 11; ++n3) {
            dArray[n3] = HeatmapTileProvider.a(this.mData, this.mBounds, n2, (int)(1280.0 * Math.pow(2.0, n3)));
            if (n3 != 5) continue;
            for (int i2 = 0; i2 < n3; ++i2) {
                dArray[i2] = dArray[n3];
            }
        }
        for (n3 = 11; n3 < 21; ++n3) {
            dArray[n3] = dArray[10];
        }
        return dArray;
    }

    private static Tile a(Bitmap bitmap) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        bitmap.compress(Bitmap.CompressFormat.PNG, 100, byteArrayOutputStream);
        byte[] byArray = byteArrayOutputStream.toByteArray();
        return Tile.obtain(256, 256, byArray, bitmap);
    }

    static dv a(Collection<WeightedLatLng> collection) {
        Iterator<WeightedLatLng> iterator = collection.iterator();
        WeightedLatLng weightedLatLng = iterator.next();
        double d2 = weightedLatLng.getPoint().x;
        double d3 = weightedLatLng.getPoint().x;
        double d4 = weightedLatLng.getPoint().y;
        double d5 = weightedLatLng.getPoint().y;
        while (iterator.hasNext()) {
            WeightedLatLng weightedLatLng2 = iterator.next();
            double d6 = weightedLatLng2.getPoint().x;
            double d7 = weightedLatLng2.getPoint().y;
            if (d6 < d2) {
                d2 = d6;
            }
            if (d6 > d3) {
                d3 = d6;
            }
            if (d7 < d4) {
                d4 = d7;
            }
            if (!(d7 > d5)) continue;
            d5 = d7;
        }
        return new dv(d2, d3, d4, d5);
    }

    static double[] a(int n2, double d2) {
        double[] dArray = new double[n2 * 2 + 1];
        for (int i2 = -n2; i2 <= n2; ++i2) {
            dArray[i2 + n2] = Math.exp((double)(-i2 * i2) / (2.0 * d2 * d2));
        }
        return dArray;
    }

    static double[][] a(double[][] dArray, double[] dArray2) {
        int n2;
        double d2;
        int n3;
        int n4;
        int n5 = (int)Math.floor((double)dArray2.length / 2.0);
        int n6 = dArray.length;
        int n7 = n6 - 2 * n5;
        int n8 = n5;
        int n9 = n5 + n7 - 1;
        double[][] dArray3 = new double[n6][n6];
        for (n4 = 0; n4 < n6; ++n4) {
            for (n3 = 0; n3 < n6; ++n3) {
                d2 = dArray[n4][n3];
                if (d2 == 0.0) continue;
                int n10 = (n9 < n4 + n5 ? n9 : n4 + n5) + 1;
                for (int i2 = n2 = n8 > n4 - n5 ? n8 : n4 - n5; i2 < n10; ++i2) {
                    double[] dArray4 = dArray3[i2];
                    int n11 = n3;
                    dArray4[n11] = dArray4[n11] + d2 * dArray2[i2 - (n4 - n5)];
                }
            }
        }
        double[][] dArray5 = new double[n7][n7];
        for (n4 = n8; n4 < n9 + 1; ++n4) {
            for (n3 = 0; n3 < n6; ++n3) {
                d2 = dArray3[n4][n3];
                if (d2 == 0.0) continue;
                int n12 = (n9 < n3 + n5 ? n9 : n3 + n5) + 1;
                for (int i3 = n2 = n8 > n3 - n5 ? n8 : n3 - n5; i3 < n12; ++i3) {
                    double[] dArray6 = dArray5[n4 - n5];
                    int n13 = i3 - n5;
                    dArray6[n13] = dArray6[n13] + d2 * dArray2[i3 - (n3 - n5)];
                }
            }
        }
        return dArray5;
    }

    static Bitmap a(double[][] dArray, int[] nArray, double d2) {
        int n2 = nArray[nArray.length - 1];
        double d3 = (double)(nArray.length - 1) / d2;
        int n3 = dArray.length;
        int[] nArray2 = new int[n3 * n3];
        for (int i2 = 0; i2 < n3; ++i2) {
            for (int i3 = 0; i3 < n3; ++i3) {
                double d4 = dArray[i3][i2];
                int n4 = i2 * n3 + i3;
                int n5 = (int)(d4 * d3);
                if (d4 != 0.0) {
                    if (n5 < nArray.length) {
                        nArray2[n4] = nArray[n5];
                        continue;
                    }
                    nArray2[n4] = n2;
                    continue;
                }
                nArray2[n4] = 0;
            }
        }
        Bitmap bitmap = Bitmap.createBitmap(n3, n3, Bitmap.Config.ARGB_8888);
        bitmap.setPixels(nArray2, 0, n3, 0, 0, n3, n3);
        return bitmap;
    }

    static double a(Collection<WeightedLatLng> collection, dv dv2, int n2, int n3) {
        double d2 = dv2.c;
        double d3 = dv2.a;
        double d4 = dv2.d;
        double d5 = dv2.b;
        double d6 = d2 - d3 > d4 - d5 ? d2 - d3 : d4 - d5;
        int n4 = (int)((double)(n3 / (2 * n2)) + 0.5);
        double d7 = (double)n4 / d6;
        LongSparseArray longSparseArray = new LongSparseArray();
        double d8 = 0.0;
        for (WeightedLatLng weightedLatLng : collection) {
            Double d9;
            double d10 = weightedLatLng.getPoint().x;
            double d11 = weightedLatLng.getPoint().y;
            int n5 = (int)((d10 - d3) * d7);
            int n6 = (int)((d11 - d5) * d7);
            LongSparseArray<Double> longSparseArray2 = (LongSparseArray<Double>)longSparseArray.get(n5);
            if (longSparseArray2 == null) {
                longSparseArray2 = new LongSparseArray<Double>();
                longSparseArray.put(n5, longSparseArray2);
            }
            if ((d9 = (Double)longSparseArray2.get(n6)) == null) {
                d9 = 0.0;
            }
            d9 = d9 + weightedLatLng.intensity;
            longSparseArray2.put(n6, d9);
            if (!(d9 > d8)) continue;
            d8 = d9;
        }
        return d8;
    }

    @Override
    public int getTileHeight() {
        return 256;
    }

    @Override
    public int getTileWidth() {
        return 256;
    }

    public static class Builder {
        private Collection<WeightedLatLng> data;
        private int radius = 12;
        private Gradient gradient = DEFAULT_GRADIENT;
        private double opacity = 0.6;

        public Builder data(Collection<LatLng> collection) {
            return this.weightedData(HeatmapTileProvider.d(collection));
        }

        public Builder weightedData(Collection<WeightedLatLng> collection) {
            this.data = collection;
            return this;
        }

        public Builder radius(int n2) {
            this.radius = Math.max(10, Math.min(n2, 50));
            return this;
        }

        public Builder gradient(Gradient gradient) {
            this.gradient = gradient;
            return this;
        }

        public Builder transparency(double d2) {
            this.opacity = Math.max(0.0, Math.min(d2, 1.0));
            return this;
        }

        public HeatmapTileProvider build() {
            if (this.data == null || this.data.size() == 0) {
                try {
                    throw new AMapException("No input points.");
                }
                catch (AMapException aMapException) {
                    Log.e("amap", aMapException.getErrorMessage());
                    aMapException.printStackTrace();
                    return null;
                }
            }
            try {
                return new HeatmapTileProvider(this);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                return null;
            }
        }
    }
}

