/*
 * Decompiled with CFR 0.152.
 */
package com.amap.api.maps.model;

import com.amap.adapter.text.TextUtils;
import com.amap.adapter.util.Log;
import com.amap.api.mapcore.util.er;
import com.amap.api.maps.interfaces.IGlOverlayLayer;
import com.amap.api.maps.model.BasePointOverlay;
import com.amap.api.maps.model.BitmapDescriptor;
import com.amap.api.maps.model.LatLng;
import com.amap.api.maps.model.MarkerOptions;
import com.amap.api.maps.model.animation.Animation;
import com.autonavi.amap.mapcore.DPoint;
import com.autonavi.amap.mapcore.IPoint;
import com.autonavi.amap.mapcore.VirtualEarthProjection;
import com.autonavi.amap.mapcore.interfaces.IMarker;
import com.autonavi.amap.mapcore.interfaces.IMarkerAction;
import java.lang.ref.WeakReference;
import java.util.ArrayList;

public final class Marker
extends BasePointOverlay {
    private IMarker markerDelegate;
    private MarkerOptions options;
    private WeakReference<IGlOverlayLayer> glOverlayLayerRef;
    private Object object;
    private IPoint geoPoint;
    private boolean isRemoved = false;
    private DPoint viewModeLatLngDp = new DPoint();
    private LatLng viewModeLatLng = null;
    private boolean isUseAnimation = false;
    private Animation mCurAnimation = null;
    private Animation.AnimationListener mCurAnimationListener = null;
    private a mCurInnerAnimationListener = null;
    private boolean isClickable = true;
    private boolean isInfoWindowEnable = true;

    public Marker(IMarker iMarker) {
        super("");
        this.markerDelegate = iMarker;
    }

    public Marker(IGlOverlayLayer iGlOverlayLayer, MarkerOptions markerOptions, String string) {
        super(string);
        this.glOverlayLayerRef = new WeakReference<IGlOverlayLayer>(iGlOverlayLayer);
        this.options = markerOptions;
    }

    public void setPeriod(int n2) {
        try {
            if (this.markerDelegate != null) {
                this.markerDelegate.setPeriod(n2);
            } else {
                this.options.period(n2);
                this.a();
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public int getPeriod() {
        try {
            if (this.markerDelegate != null) {
                return this.markerDelegate.getPeriod();
            }
            return this.options.getPeriod();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return 0;
        }
    }

    public void setIcons(ArrayList<BitmapDescriptor> arrayList) {
        try {
            if (this.markerDelegate != null) {
                this.markerDelegate.setIcons(arrayList);
            } else {
                this.options.icons(arrayList);
                this.a();
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public ArrayList<BitmapDescriptor> getIcons() {
        try {
            if (this.markerDelegate != null) {
                return this.markerDelegate.getIcons();
            }
            return this.options.getIcons();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
    }

    @Override
    public void remove() {
        try {
            if (this.markerDelegate != null) {
                this.markerDelegate.remove();
            } else {
                IGlOverlayLayer iGlOverlayLayer;
                if (this.isInfoWindowShown()) {
                    this.hideInfoWindow();
                }
                if ((iGlOverlayLayer = (IGlOverlayLayer)this.glOverlayLayerRef.get()) != null) {
                    iGlOverlayLayer.removeOverlay(this.overlayName);
                }
                this.isRemoved = true;
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    @Override
    public void destroy() {
        try {
            if (this.markerDelegate != null) {
                this.markerDelegate.destroy(true);
            } else {
                this.remove();
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    @Override
    public String getId() {
        try {
            if (this.markerDelegate != null) {
                return this.markerDelegate.getId();
            }
            return this.overlayName;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
    }

    public void setPerspective(boolean bl2) {
    }

    public boolean isPerspective() {
        return false;
    }

    @Override
    public void setPosition(LatLng latLng) {
        try {
            if (this.markerDelegate != null) {
                this.markerDelegate.setPosition(latLng);
            } else if (this.options != null) {
                this.options.position(latLng);
                this.a();
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    @Override
    public LatLng getPosition() {
        try {
            if (this.markerDelegate != null) {
                return this.markerDelegate.getPosition();
            }
            if (this.options != null) {
                Object object;
                if (this.isViewMode()) {
                    ((IGlOverlayLayer)this.glOverlayLayerRef.get()).getMap().getPixel2LatLng(this.options.getScreenX(), this.options.getScreenY(), this.viewModeLatLngDp);
                    if (this.viewModeLatLng != null && this.viewModeLatLng.latitude == this.viewModeLatLngDp.y && this.viewModeLatLng.longitude == this.viewModeLatLngDp.x) {
                        return this.viewModeLatLng;
                    }
                    return new LatLng(this.viewModeLatLngDp.y, this.viewModeLatLngDp.x);
                }
                if (this.isUseAnimation && (object = this.a("getPosition", null)) != null) {
                    return (LatLng)object;
                }
                return this.options.getPosition();
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return null;
    }

    @Override
    public void setTitle(String string) {
        try {
            if (this.markerDelegate != null) {
                this.markerDelegate.setTitle(string);
            } else if (this.options != null) {
                this.options.title(string);
                this.a();
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    @Override
    public String getTitle() {
        try {
            if (this.markerDelegate != null) {
                return this.markerDelegate.getTitle();
            }
            if (this.options != null) {
                return this.options.getTitle();
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return null;
    }

    @Override
    public void setSnippet(String string) {
        try {
            if (this.markerDelegate != null) {
                this.markerDelegate.setSnippet(string);
            } else if (this.options != null) {
                this.options.snippet(string);
                this.a();
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    @Override
    public String getSnippet() {
        try {
            if (this.markerDelegate != null) {
                return this.markerDelegate.getSnippet();
            }
            if (this.options != null) {
                return this.options.getSnippet();
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return null;
    }

    public void setIcon(BitmapDescriptor bitmapDescriptor) {
        try {
            if (bitmapDescriptor != null) {
                if (this.markerDelegate != null) {
                    this.markerDelegate.setIcon(bitmapDescriptor);
                } else if (this.options != null) {
                    this.options.icon(bitmapDescriptor);
                    this.a();
                }
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public void setAnchor(float f2, float f3) {
        try {
            if (this.markerDelegate != null) {
                this.markerDelegate.setAnchor(f2, f3);
            } else if (this.options != null) {
                this.options.anchor(f2, f3);
                this.a();
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public void setDraggable(boolean bl2) {
        try {
            if (this.markerDelegate != null) {
                this.markerDelegate.setDraggable(bl2);
            } else if (this.options != null) {
                this.options.draggable(bl2);
                this.a();
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public boolean isDraggable() {
        if (this.markerDelegate != null) {
            return this.markerDelegate.isDraggable();
        }
        if (this.options != null) {
            return this.options.isDraggable();
        }
        return false;
    }

    @Override
    public void showInfoWindow() {
        try {
            if (this.markerDelegate != null) {
                this.markerDelegate.showInfoWindow();
            } else {
                IGlOverlayLayer iGlOverlayLayer = (IGlOverlayLayer)this.glOverlayLayerRef.get();
                if (!TextUtils.isEmpty(this.overlayName) && iGlOverlayLayer != null) {
                    iGlOverlayLayer.showInfoWindow(this.overlayName);
                }
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public void hideInfoWindow() {
        try {
            if (this.markerDelegate != null) {
                this.markerDelegate.hideInfoWindow();
            } else {
                IGlOverlayLayer iGlOverlayLayer = (IGlOverlayLayer)this.glOverlayLayerRef.get();
                if (!TextUtils.isEmpty(this.overlayName) && iGlOverlayLayer != null) {
                    iGlOverlayLayer.hideInfoWindow(this.overlayName);
                }
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public boolean isInfoWindowShown() {
        Object object;
        if (this.markerDelegate != null) {
            return this.markerDelegate.isInfoWindowShown();
        }
        IGlOverlayLayer iGlOverlayLayer = (IGlOverlayLayer)this.glOverlayLayerRef.get();
        if (!TextUtils.isEmpty(this.overlayName) && iGlOverlayLayer != null && (object = this.a("isInfoWindowShown", null)) instanceof Boolean) {
            return (Boolean)object;
        }
        return false;
    }

    @Override
    public void setVisible(boolean bl2) {
        try {
            if (this.markerDelegate != null) {
                this.markerDelegate.setVisible(bl2);
            } else if (this.options != null) {
                this.options.visible(bl2);
                this.a();
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    @Override
    public boolean isVisible() {
        try {
            if (this.markerDelegate != null) {
                return this.markerDelegate.isVisible();
            }
            if (this.options != null) {
                return this.options.isVisible();
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return false;
    }

    public boolean equals(Object object) {
        try {
            if (object == null || !(object instanceof Marker)) {
                return false;
            }
            if (this.markerDelegate != null) {
                return this.markerDelegate.equalsRemote(((Marker)object).markerDelegate);
            }
            if (this.options != null) {
                return this.options.equals(((Marker)object).options) && this.overlayName.equals(((Marker)object).overlayName);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return false;
    }

    public int hashCode() {
        if (this.markerDelegate != null) {
            return this.markerDelegate.hashCode();
        }
        if (this.options != null) {
            int n2 = 31;
            int n3 = 1;
            n3 = n2 * n3 + (this.overlayName == null ? 0 : this.overlayName.hashCode());
            n3 = n2 * n3 + this.options.hashCode();
            return n3;
        }
        return super.hashCode();
    }

    @Override
    public void setObject(Object object) {
        if (this.markerDelegate != null) {
            this.markerDelegate.setObject(object);
        } else {
            this.object = object;
        }
    }

    @Override
    public Object getObject() {
        if (this.markerDelegate != null) {
            return this.markerDelegate.getObject();
        }
        return this.object;
    }

    @Override
    public void setRotateAngle(float f2) {
        try {
            if (this.markerDelegate != null) {
                this.markerDelegate.setRotateAngle(f2);
            } else if (this.options != null) {
                this.options.rotateAngle(f2);
                this.a();
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    @Override
    public float getRotateAngle() {
        if (this.markerDelegate != null) {
            return this.markerDelegate.getRotateAngle();
        }
        if (this.options != null) {
            if (this.isUseAnimation) {
                Object object = this.a("getRotateAngle", null);
                Log.e("mapcore", "getRotateAngle " + object);
                if (object != null) {
                    return ((Double)object).floatValue();
                }
            }
            return this.options.getRotateAngle();
        }
        return 0.0f;
    }

    public void setToTop() {
        try {
            if (this.markerDelegate != null) {
                this.markerDelegate.set2Top();
            } else {
                IGlOverlayLayer iGlOverlayLayer = (IGlOverlayLayer)this.glOverlayLayerRef.get();
                if (!TextUtils.isEmpty(this.overlayName) && iGlOverlayLayer != null) {
                    iGlOverlayLayer.set2Top(this.overlayName);
                }
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    @Override
    public void setGeoPoint(IPoint iPoint) {
        if (this.markerDelegate != null) {
            this.markerDelegate.setGeoPoint(iPoint);
        } else {
            this.geoPoint = iPoint;
            if (iPoint != null) {
                DPoint dPoint = VirtualEarthProjection.pixelsToLatLong(iPoint.x, iPoint.y, 20);
                LatLng latLng = new LatLng(dPoint.y, dPoint.x, false);
                dPoint.recycle();
                this.options.position(latLng);
                this.a();
            }
        }
    }

    public IPoint getGeoPoint() {
        LatLng latLng;
        if (this.markerDelegate != null) {
            return this.markerDelegate.getGeoPoint();
        }
        if (this.geoPoint == null) {
            this.geoPoint = new IPoint();
        }
        if ((latLng = this.getPosition()) != null) {
            VirtualEarthProjection.latLongToPixels(latLng.latitude, latLng.longitude, 20, this.geoPoint);
        }
        return this.geoPoint;
    }

    public void setFlat(boolean bl2) {
        try {
            if (this.markerDelegate != null) {
                this.markerDelegate.setFlat(bl2);
            } else if (this.options != null) {
                this.options.setFlat(bl2);
                this.a();
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public boolean isFlat() {
        if (this.markerDelegate != null) {
            return this.markerDelegate.isFlat();
        }
        if (this.options != null) {
            return this.options.isFlat();
        }
        return false;
    }

    public void setPositionByPixels(int n2, int n3) {
        if (this.markerDelegate != null) {
            this.markerDelegate.setPositionByPixels(n2, n3);
        } else if (this.options != null) {
            this.options.setScreenPosition(n2, n3);
            this.a();
        }
    }

    public void setZIndex(float f2) {
        if (this.markerDelegate != null) {
            this.markerDelegate.setZIndex(f2);
        } else if (this.options != null) {
            this.options.zIndex(f2);
            this.a();
        }
    }

    public float getZIndex() {
        if (this.markerDelegate != null) {
            return this.markerDelegate.getZIndex();
        }
        if (this.options != null) {
            return this.options.getZIndex();
        }
        return 0.0f;
    }

    @Override
    public void setAnimation(Animation animation) {
        try {
            if (this.markerDelegate != null) {
                this.markerDelegate.setAnimation(animation);
            } else {
                if (animation != null && this.mCurAnimationListener != null) {
                    animation.setAnimationListener(this.mCurAnimationListener);
                }
                this.mCurAnimation = animation;
                this.isUseAnimation = animation != null;
                this.a("setAnimation", new Object[]{animation});
                if (animation != null) {
                    animation.resetUpdateFlags();
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public boolean startAnimation() {
        if (this.markerDelegate != null) {
            return this.markerDelegate.startAnimation();
        }
        Object object = this.a("startAnimation", null);
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        return false;
    }

    public void setAnimationListener(Animation.AnimationListener animationListener) {
        if (this.markerDelegate != null) {
            this.markerDelegate.setAnimationListener(animationListener);
        } else {
            this.mCurAnimationListener = animationListener;
            this.mCurInnerAnimationListener = new a(animationListener);
            if (this.mCurAnimation != null) {
                this.a("setAnimationListener", new Object[]{this.mCurAnimationListener});
            }
        }
    }

    public float getAlpha() {
        if (this.markerDelegate != null) {
            IMarkerAction iMarkerAction = this.markerDelegate.getIMarkerAction();
            if (iMarkerAction != null) {
                return iMarkerAction.getAlpha();
            }
        } else if (this.options != null) {
            Object object;
            if (this.isUseAnimation && (object = this.a("getAlpha", null)) != null) {
                return ((Double)object).floatValue();
            }
            return this.options.getAlpha();
        }
        return 1.0f;
    }

    public void setAlpha(float f2) {
        if (this.markerDelegate != null) {
            IMarkerAction iMarkerAction = this.markerDelegate.getIMarkerAction();
            if (iMarkerAction != null) {
                iMarkerAction.setAlpha(f2);
            }
        } else if (this.options != null) {
            this.options.alpha(f2);
            this.a();
        }
    }

    public int getDisplayLevel() {
        IMarkerAction iMarkerAction;
        if (this.markerDelegate != null && (iMarkerAction = this.markerDelegate.getIMarkerAction()) != null) {
            return iMarkerAction.getDisplayLevel();
        }
        return 5;
    }

    public MarkerOptions getOptions() {
        if (this.markerDelegate != null) {
            IMarkerAction iMarkerAction = this.markerDelegate.getIMarkerAction();
            if (iMarkerAction != null) {
                return iMarkerAction.getOptions();
            }
        } else if (this.options != null) {
            return this.options;
        }
        return null;
    }

    public boolean isClickable() {
        if (this.markerDelegate != null) {
            IMarkerAction iMarkerAction = this.markerDelegate.getIMarkerAction();
            if (iMarkerAction != null) {
                return iMarkerAction.isClickable();
            }
        } else {
            Object object = this.a("isClickable", null);
            if (object instanceof Boolean) {
                return (Boolean)object;
            }
        }
        return this.isClickable;
    }

    public boolean isInfoWindowAutoOverturn() {
        IMarkerAction iMarkerAction;
        if (this.markerDelegate != null && (iMarkerAction = this.markerDelegate.getIMarkerAction()) != null) {
            return iMarkerAction.isInfoWindowAutoOverturn();
        }
        return false;
    }

    @Override
    public boolean isInfoWindowEnable() {
        if (this.markerDelegate != null) {
            IMarkerAction iMarkerAction = this.markerDelegate.getIMarkerAction();
            if (iMarkerAction != null) {
                return iMarkerAction.isInfoWindowEnable();
            }
        } else if (this.options != null) {
            return this.options.isInfoWindowEnable();
        }
        return this.isInfoWindowEnable;
    }

    public void setInfoWindowEnable(boolean bl2) {
        this.isInfoWindowEnable = bl2;
        if (this.markerDelegate != null) {
            IMarkerAction iMarkerAction = this.markerDelegate.getIMarkerAction();
            if (iMarkerAction != null) {
                iMarkerAction.setInfoWindowEnable(bl2);
            }
        } else if (this.options != null) {
            this.options.infoWindowEnable(bl2);
            this.a();
        }
    }

    public void setMarkerOptions(MarkerOptions markerOptions) {
        if (this.markerDelegate != null) {
            IMarkerAction iMarkerAction = this.markerDelegate.getIMarkerAction();
            if (iMarkerAction != null) {
                iMarkerAction.setMarkerOptions(markerOptions);
            }
        } else {
            this.options = markerOptions;
            this.a();
        }
    }

    public void setAutoOverturnInfoWindow(boolean bl2) {
        IMarkerAction iMarkerAction;
        if (this.markerDelegate != null && (iMarkerAction = this.markerDelegate.getIMarkerAction()) != null) {
            iMarkerAction.setAutoOverturnInfoWindow(bl2);
        }
    }

    public void setClickable(boolean bl2) {
        this.isClickable = bl2;
        if (this.markerDelegate != null) {
            IMarkerAction iMarkerAction = this.markerDelegate.getIMarkerAction();
            if (iMarkerAction != null) {
                iMarkerAction.setClickable(bl2);
            }
        } else {
            this.a("setClickable", new Object[]{bl2});
        }
    }

    public void setDisplayLevel(int n2) {
        IMarkerAction iMarkerAction;
        if (this.markerDelegate != null && (iMarkerAction = this.markerDelegate.getIMarkerAction()) != null) {
            iMarkerAction.setDisplayLevel(n2);
        }
    }

    public void setFixingPointEnable(boolean bl2) {
        IMarkerAction iMarkerAction;
        if (this.markerDelegate != null && (iMarkerAction = this.markerDelegate.getIMarkerAction()) != null) {
            iMarkerAction.setFixingPointEnable(bl2);
        }
    }

    public boolean isRemoved() {
        if (this.markerDelegate != null) {
            return this.markerDelegate.isRemoved();
        }
        return this.isRemoved;
    }

    public void setPositionNotUpdate(LatLng latLng) {
        this.setPosition(latLng);
    }

    public void setRotateAngleNotUpdate(float f2) {
        IMarkerAction iMarkerAction;
        if (this.markerDelegate != null && (iMarkerAction = this.markerDelegate.getIMarkerAction()) != null) {
            iMarkerAction.setRotateAngleNotUpdate(f2);
        }
    }

    public void setBelowMaskLayer(boolean bl2) {
        if (this.markerDelegate != null) {
            this.markerDelegate.setBelowMaskLayer(bl2);
        } else if (this.options != null) {
            this.options.belowMaskLayer(bl2);
            this.a();
        }
    }

    public float getAnchorU() {
        if (this.markerDelegate != null) {
            return this.markerDelegate.getAnchorU();
        }
        if (this.options != null) {
            return this.options.getAnchorU();
        }
        return 0.0f;
    }

    public float getAnchorV() {
        if (this.markerDelegate != null) {
            return this.markerDelegate.getAnchorV();
        }
        if (this.options != null) {
            return this.options.getAnchorV();
        }
        return 0.0f;
    }

    private Object a(String string, Object[] objectArray) {
        try {
            IGlOverlayLayer iGlOverlayLayer = (IGlOverlayLayer)this.glOverlayLayerRef.get();
            if (!TextUtils.isEmpty(this.overlayName) && iGlOverlayLayer != null) {
                return iGlOverlayLayer.getNativeProperties(this.overlayName, string, objectArray);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    private void a() {
        try {
            IGlOverlayLayer iGlOverlayLayer = (IGlOverlayLayer)this.glOverlayLayerRef.get();
            if (!TextUtils.isEmpty(this.overlayName) && iGlOverlayLayer != null && iGlOverlayLayer != null) {
                iGlOverlayLayer.updateOption(this.overlayName, this.options);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public boolean isViewMode() {
        if (this.options != null) {
            return this.options.isViewMode();
        }
        return false;
    }

    private class a
    implements Animation.AnimationListener {
        private final Runnable b;
        private final Runnable c;

        private a(final Animation.AnimationListener animationListener) {
            this.b = new Runnable(){

                @Override
                public void run() {
                    try {
                        if (animationListener != null) {
                            animationListener.onAnimationStart();
                        }
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                    }
                }
            };
            this.c = new Runnable(){

                @Override
                public void run() {
                    try {
                        if (animationListener != null) {
                            animationListener.onAnimationEnd();
                        }
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                    }
                }
            };
        }

        @Override
        public void onAnimationStart() {
            er.a().a(this.b);
        }

        @Override
        public void onAnimationEnd() {
            er.a().a(this.c);
        }
    }
}

