/*
 * Decompiled with CFR 0.152.
 */
package com.amap.api.maps.utils.overlay;

import com.amap.api.maps.AMap;
import com.amap.api.maps.AMapUtils;
import com.amap.api.maps.model.BitmapDescriptor;
import com.amap.api.maps.model.CameraPosition;
import com.amap.api.maps.model.LatLng;
import com.amap.api.maps.model.Marker;
import com.amap.api.maps.model.MarkerOptions;
import com.autonavi.amap.mapcore.IPoint;
import com.autonavi.amap.mapcore.MapProjection;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class SmoothMoveMarker {
    public static final float MIN_OFFSET_DISTANCE = 5.0f;
    private AMap mAMap;
    private long duration = 10000L;
    private long mStepDuration = 20L;
    private LinkedList<LatLng> points = new LinkedList();
    private LinkedList<Double> eachDistance = new LinkedList();
    private double totalDistance = 0.0;
    private double remainDistance = 0.0;
    private ExecutorService mThreadPools;
    private Object mLock = new Object();
    private Marker marker = null;
    private BitmapDescriptor descriptor;
    private int index = 0;
    private boolean useDefaultDescriptor = false;
    AtomicBoolean exitFlag = new AtomicBoolean(false);
    private MoveListener moveListener;
    private a moveStatus = a.a;
    private long pauseMillis;
    private long mAnimationBeginTime = System.currentTimeMillis();

    public SmoothMoveMarker(AMap aMap) {
        this.mAMap = aMap;
        this.mThreadPools = new ThreadPoolExecutor(1, 2, 5L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new b());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPoints(List<LatLng> list) {
        Object object = this.mLock;
        synchronized (object) {
            try {
                if (list == null || list.size() < 2) {
                    return;
                }
                this.stopMove();
                this.points.clear();
                for (LatLng latLng : list) {
                    if (latLng == null) continue;
                    this.points.add(latLng);
                }
                this.eachDistance.clear();
                this.totalDistance = 0.0;
                for (int i2 = 0; i2 < this.points.size() - 1; ++i2) {
                    double d2 = AMapUtils.calculateLineDistance(this.points.get(i2), this.points.get(i2 + 1));
                    this.eachDistance.add(d2);
                    this.totalDistance += d2;
                }
                this.remainDistance = this.totalDistance;
                LatLng latLng = this.points.get(0);
                if (this.marker != null) {
                    this.marker.setPosition(latLng);
                    this.checkMarkerIcon();
                } else {
                    if (this.descriptor == null) {
                        this.useDefaultDescriptor = true;
                    }
                    this.marker = this.mAMap.addMarker(new MarkerOptions().belowMaskLayer(true).position(latLng).icon(this.descriptor).title("").anchor(0.5f, 0.5f));
                }
                this.reset();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    private void reset() {
        try {
            if (this.moveStatus == a.c || this.moveStatus == a.d) {
                this.exitFlag.set(true);
                this.mThreadPools.awaitTermination(this.mStepDuration + 20L, TimeUnit.MILLISECONDS);
                if (this.marker != null) {
                    this.marker.setAnimation(null);
                }
                this.moveStatus = a.a;
            }
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    private void checkMarkerIcon() {
        if (this.useDefaultDescriptor) {
            if (this.descriptor == null) {
                this.useDefaultDescriptor = true;
            } else {
                this.marker.setIcon(this.descriptor);
                this.useDefaultDescriptor = false;
            }
        }
    }

    public void setTotalDuration(int n2) {
        this.duration = n2 * 1000;
    }

    public void startSmoothMove() {
        if (this.moveStatus == a.d) {
            this.moveStatus = a.c;
            long l2 = System.currentTimeMillis() - this.pauseMillis;
            this.mAnimationBeginTime += l2;
            return;
        }
        if (this.moveStatus == a.a || this.moveStatus == a.e) {
            if (this.points.size() < 1) {
                return;
            }
            this.index = 0;
            try {
                this.mThreadPools.execute(new c());
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    private IPoint getCurPosition(long l2) {
        if (l2 > this.duration) {
            this.exitFlag.set(true);
            IPoint iPoint = new IPoint();
            this.index = this.points.size() - 1;
            LatLng latLng = this.points.get(this.index);
            --this.index;
            this.index = Math.max(this.index, 0);
            this.remainDistance = 0.0;
            MapProjection.lonlat2Geo(latLng.longitude, latLng.latitude, iPoint);
            if (this.moveListener != null) {
                this.moveListener.move(this.remainDistance);
            }
            return iPoint;
        }
        double d2 = (double)l2 * this.totalDistance / (double)this.duration;
        this.remainDistance = this.totalDistance - d2;
        int n2 = 0;
        double d3 = 1.0;
        for (int i2 = 0; i2 < this.eachDistance.size(); ++i2) {
            double d4 = this.eachDistance.get(i2);
            if (d2 > d4) {
                d2 -= d4;
                continue;
            }
            if (d4 > 0.0) {
                d3 = d2 / d4;
            }
            n2 = i2;
            break;
        }
        if (n2 != this.index && this.moveListener != null) {
            this.moveListener.move(this.remainDistance);
        }
        this.index = n2;
        LatLng latLng = this.points.get(n2);
        LatLng latLng2 = this.points.get(n2 + 1);
        IPoint iPoint = new IPoint();
        MapProjection.lonlat2Geo(latLng.longitude, latLng.latitude, iPoint);
        IPoint iPoint2 = new IPoint();
        MapProjection.lonlat2Geo(latLng2.longitude, latLng2.latitude, iPoint2);
        int n3 = iPoint2.x - iPoint.x;
        int n4 = iPoint2.y - iPoint.y;
        float f2 = AMapUtils.calculateLineDistance(latLng, latLng2);
        if (f2 > 5.0f) {
            CameraPosition cameraPosition;
            float f3 = this.getRotate(iPoint, iPoint2);
            if (this.mAMap != null && (cameraPosition = this.mAMap.getCameraPosition()) != null) {
                this.marker.setRotateAngle(360.0f - f3 + cameraPosition.bearing);
            }
        }
        return new IPoint((int)((double)iPoint.x + (double)n3 * d3), (int)((double)iPoint.y + (double)n4 * d3));
    }

    private float getRotate(IPoint iPoint, IPoint iPoint2) {
        if (iPoint == null || iPoint2 == null) {
            return 0.0f;
        }
        double d2 = iPoint2.y;
        double d3 = iPoint.y;
        double d4 = iPoint.x;
        double d5 = iPoint2.x;
        float f2 = (float)(Math.atan2(d5 - d4, d3 - d2) / Math.PI * 180.0);
        return f2;
    }

    public void stopMove() {
        if (this.moveStatus == a.c) {
            this.moveStatus = a.d;
            this.pauseMillis = System.currentTimeMillis();
        }
    }

    public Marker getMarker() {
        return this.marker;
    }

    public LatLng getPosition() {
        if (this.marker == null) {
            return null;
        }
        return this.marker.getPosition();
    }

    public int getIndex() {
        return this.index;
    }

    public void resetIndex() {
        this.index = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        try {
            this.reset();
            this.mThreadPools.shutdownNow();
            if (this.descriptor != null) {
                this.descriptor.recycle();
            }
            if (this.marker != null) {
                this.marker.destroy();
                this.marker = null;
            }
            Object object = this.mLock;
            synchronized (object) {
                this.points.clear();
                this.eachDistance.clear();
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public void removeMarker() {
        if (this.marker != null) {
            this.marker.remove();
            this.marker = null;
        }
        this.points.clear();
        this.eachDistance.clear();
    }

    public void setPosition(LatLng latLng) {
        if (this.marker != null) {
            this.marker.setPosition(latLng);
            this.checkMarkerIcon();
        } else {
            if (this.descriptor == null) {
                this.useDefaultDescriptor = true;
            }
            this.marker = this.mAMap.addMarker(new MarkerOptions().belowMaskLayer(true).position(latLng).icon(this.descriptor).title("").anchor(0.5f, 0.5f));
        }
    }

    public void setDescriptor(BitmapDescriptor bitmapDescriptor) {
        if (this.descriptor != null) {
            this.descriptor.recycle();
        }
        this.descriptor = bitmapDescriptor;
        if (this.marker != null) {
            this.marker.setIcon(bitmapDescriptor);
        }
    }

    public void setRotate(float f2) {
        CameraPosition cameraPosition;
        if (this.marker != null && this.mAMap != null && this.mAMap != null && (cameraPosition = this.mAMap.getCameraPosition()) != null) {
            this.marker.setRotateAngle(360.0f - f2 + cameraPosition.bearing);
        }
    }

    public void setVisible(boolean bl2) {
        if (this.marker != null) {
            this.marker.setVisible(bl2);
        }
    }

    public void setMoveListener(MoveListener moveListener) {
        this.moveListener = moveListener;
    }

    private class c
    implements Runnable {
        private c() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                SmoothMoveMarker.this.mAnimationBeginTime = System.currentTimeMillis();
                SmoothMoveMarker.this.moveStatus = com.amap.api.maps.utils.overlay.SmoothMoveMarker$a.b;
                SmoothMoveMarker.this.exitFlag.set(false);
                while (!SmoothMoveMarker.this.exitFlag.get() && SmoothMoveMarker.this.index <= SmoothMoveMarker.this.points.size() - 1) {
                    Object object = SmoothMoveMarker.this.mLock;
                    synchronized (object) {
                        if (SmoothMoveMarker.this.exitFlag.get()) {
                            return;
                        }
                        if (SmoothMoveMarker.this.moveStatus != com.amap.api.maps.utils.overlay.SmoothMoveMarker$a.d) {
                            long l2 = System.currentTimeMillis() - SmoothMoveMarker.this.mAnimationBeginTime;
                            IPoint iPoint = SmoothMoveMarker.this.getCurPosition(l2);
                            if (SmoothMoveMarker.this.marker != null) {
                                SmoothMoveMarker.this.marker.setGeoPoint(iPoint);
                            }
                            SmoothMoveMarker.this.moveStatus = com.amap.api.maps.utils.overlay.SmoothMoveMarker$a.c;
                        }
                    }
                    Thread.sleep(SmoothMoveMarker.this.mStepDuration);
                }
                SmoothMoveMarker.this.moveStatus = com.amap.api.maps.utils.overlay.SmoothMoveMarker$a.e;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    private static class b
    implements ThreadFactory {
        private b() {
        }

        @Override
        public Thread newThread(Runnable runnable) {
            Thread thread = new Thread(runnable, "MoveSmoothThread");
            return thread;
        }
    }

    public static interface MoveListener {
        public void move(double var1);
    }

    private static enum a {
        a,
        b,
        c,
        d,
        e;

    }
}

