/*
 * Decompiled with CFR 0.152.
 */
package com.autonavi.amap.mapcore.animation;

import com.amap.adapter.content.Context;
import com.amap.adapter.graphics.RectF;
import com.amap.adapter.os.Handler;
import com.amap.adapter.view.animation.AccelerateDecelerateInterpolator;
import com.amap.adapter.view.animation.AnimationUtils;
import com.amap.adapter.view.animation.Interpolator;
import com.amap.api.maps.model.animation.Animation;
import com.autonavi.amap.mapcore.animation.GLTransformation;

public class GLAnimation
implements Cloneable {
    public static final int INFINITE = -1;
    public static final int RESTART = 1;
    public static final int REVERSE = 2;
    public static final int START_ON_FIRST_FRAME = -1;
    public static final int ABSOLUTE = 0;
    public static final int RELATIVE_TO_SELF = 1;
    public static final int RELATIVE_TO_PARENT = 2;
    public static final int ZORDER_NORMAL = 0;
    public static final int ZORDER_TOP = 1;
    public static final int ZORDER_BOTTOM = -1;
    boolean mEnded = false;
    boolean mStarted = false;
    boolean mCycleFlip = false;
    boolean mInitialized = false;
    boolean mFillBefore = true;
    boolean mFillAfter = false;
    boolean mFillEnabled = false;
    long mStartTime = -1L;
    long mStartOffset;
    long mDuration = 500L;
    int mRepeatCount = 0;
    int mRepeated = 0;
    int mRepeatMode = 1;
    Interpolator mInterpolator;
    Animation.AnimationListener mListener;
    private int mZAdjustment;
    private int mBackgroundColor;
    private float mScaleFactor = 1.0f;
    private boolean mDetachWallpaper = false;
    private boolean mMore = true;
    private boolean mOneMoreTime = true;
    RectF mPreviousRegion = new RectF();
    RectF mRegion = new RectF();
    GLTransformation mPreviousTransformation = new GLTransformation();
    private Handler mListenerHandler;
    private Runnable mOnStart;
    private Runnable mOnEnd;

    public GLAnimation() {
        try {
            this.ensureInterpolator();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public GLAnimation clone() throws CloneNotSupportedException {
        GLAnimation gLAnimation = (GLAnimation)super.clone();
        gLAnimation.mPreviousRegion = new RectF();
        gLAnimation.mRegion = new RectF();
        gLAnimation.mPreviousTransformation = new GLTransformation();
        return gLAnimation;
    }

    public void reset() {
        this.mPreviousRegion.setEmpty();
        this.mPreviousTransformation.clear();
        this.mInitialized = false;
        this.mCycleFlip = false;
        this.mRepeated = 0;
        this.mMore = true;
        this.mOneMoreTime = true;
        this.mListenerHandler = null;
    }

    public void cancel() {
        if (this.mStarted && !this.mEnded) {
            this.fireAnimationEnd();
            this.mEnded = true;
        }
        this.mStartTime = Long.MIN_VALUE;
        this.mOneMoreTime = false;
        this.mMore = false;
    }

    public void detach() {
        if (this.mStarted && !this.mEnded) {
            this.mEnded = true;
            this.fireAnimationEnd();
        }
    }

    public boolean isInitialized() {
        return this.mInitialized;
    }

    public void initialize() {
        this.reset();
        this.mInitialized = true;
    }

    public void setInterpolator(Context context, int n2) {
        this.setInterpolator(AnimationUtils.loadInterpolator(context, n2));
    }

    public void setInterpolator(Interpolator interpolator) {
        this.mInterpolator = interpolator;
    }

    public void setStartOffset(long l2) {
        this.mStartOffset = l2;
    }

    public void setDuration(long l2) {
        if (l2 < 0L) {
            l2 = 0L;
        }
        this.mDuration = l2;
    }

    public void restrictDuration(long l2) {
        if (this.mStartOffset > l2) {
            this.mStartOffset = l2;
            this.mDuration = 0L;
            this.mRepeatCount = 0;
            return;
        }
        long l3 = this.mDuration + this.mStartOffset;
        if (l3 > l2) {
            this.mDuration = l2 - this.mStartOffset;
            l3 = l2;
        }
        if (this.mDuration <= 0L) {
            this.mDuration = 0L;
            this.mRepeatCount = 0;
            return;
        }
        if (this.mRepeatCount < 0 || (long)this.mRepeatCount > l2 || l3 * (long)this.mRepeatCount > l2) {
            this.mRepeatCount = (int)(l2 / l3) - 1;
            if (this.mRepeatCount < 0) {
                this.mRepeatCount = 0;
            }
        }
    }

    public void scaleCurrentDuration(float f2) {
        this.mDuration = (long)((float)this.mDuration * f2);
        this.mStartOffset = (long)((float)this.mStartOffset * f2);
    }

    public void setStartTime(long l2) {
        this.mStartTime = l2;
        this.mEnded = false;
        this.mStarted = false;
        this.mCycleFlip = false;
        this.mRepeated = 0;
        this.mMore = true;
    }

    public void start() {
        this.setStartTime(-1L);
    }

    public void startNow() {
        this.setStartTime(AnimationUtils.currentAnimationTimeMillis());
    }

    public void setRepeatMode(int n2) {
        this.mRepeatMode = n2;
    }

    public void setRepeatCount(int n2) {
        if (n2 < 0) {
            n2 = -1;
        }
        this.mRepeatCount = n2;
    }

    public boolean isFillEnabled() {
        return this.mFillEnabled;
    }

    public void setFillEnabled(boolean bl2) {
        this.mFillEnabled = bl2;
    }

    public void setFillBefore(boolean bl2) {
        this.mFillBefore = bl2;
    }

    public void setFillAfter(boolean bl2) {
        this.mFillAfter = bl2;
    }

    public void setZAdjustment(int n2) {
        this.mZAdjustment = n2;
    }

    public void setBackgroundColor(int n2) {
        this.mBackgroundColor = n2;
    }

    protected float getScaleFactor() {
        return this.mScaleFactor;
    }

    public void setDetachWallpaper(boolean bl2) {
        this.mDetachWallpaper = bl2;
    }

    public Interpolator getInterpolator() {
        return this.mInterpolator;
    }

    public long getStartTime() {
        return this.mStartTime;
    }

    public long getDuration() {
        return this.mDuration;
    }

    public long getStartOffset() {
        return this.mStartOffset;
    }

    public int getRepeatMode() {
        return this.mRepeatMode;
    }

    public int getRepeatCount() {
        return this.mRepeatCount;
    }

    public boolean getFillBefore() {
        return this.mFillBefore;
    }

    public boolean getFillAfter() {
        return this.mFillAfter;
    }

    public int getZAdjustment() {
        return this.mZAdjustment;
    }

    public int getBackgroundColor() {
        return this.mBackgroundColor;
    }

    public boolean getDetachWallpaper() {
        return this.mDetachWallpaper;
    }

    public boolean willChangeTransformationMatrix() {
        return true;
    }

    public boolean willChangeBounds() {
        return true;
    }

    public void setAnimationListener(Animation.AnimationListener animationListener) {
        this.mListener = animationListener;
    }

    protected void ensureInterpolator() {
        if (this.mInterpolator == null) {
            this.mInterpolator = new AccelerateDecelerateInterpolator();
        }
    }

    public long computeDurationHint() {
        return (this.getStartOffset() + this.getDuration()) * (long)(this.getRepeatCount() + 1);
    }

    public boolean getTransformation(long l2, GLTransformation gLTransformation) {
        boolean bl2;
        if (this.mStartTime == -1L) {
            this.mStartTime = l2;
        }
        long l3 = this.getStartOffset();
        long l4 = this.mDuration;
        float f2 = l4 != 0L ? (float)(l2 - (this.mStartTime + l3)) / (float)l4 : (l2 < this.mStartTime ? 0.0f : 1.0f);
        boolean bl3 = f2 >= 1.0f;
        boolean bl4 = this.mMore = !bl3;
        if (!this.mFillEnabled) {
            f2 = Math.max(Math.min(f2, 1.0f), 0.0f);
        }
        boolean bl5 = bl2 = (f2 >= 0.0f || this.mFillBefore) && (f2 <= 1.0f || this.mFillAfter);
        if (bl2) {
            if (!this.mStarted) {
                try {
                    this.fireAnimationStart();
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
                this.mStarted = true;
            }
            if (this.mFillEnabled) {
                f2 = Math.max(Math.min(f2, 1.0f), 0.0f);
            }
            if (this.mCycleFlip) {
                f2 = 1.0f - f2;
            }
            float f3 = this.mInterpolator.getInterpolation(f2);
            this.applyTransformation(f3, gLTransformation);
        }
        if (bl3) {
            if (this.mRepeatCount == this.mRepeated) {
                if (!this.mEnded) {
                    this.mEnded = true;
                    this.fireAnimationEnd();
                }
            } else {
                if (this.mRepeatCount > 0) {
                    ++this.mRepeated;
                }
                if (this.mRepeatMode == 2) {
                    this.mCycleFlip = !this.mCycleFlip;
                }
                this.mStartTime = -1L;
                this.mMore = true;
                this.fireAnimationRepeat();
            }
        }
        if (!this.mMore && this.mOneMoreTime) {
            this.mOneMoreTime = false;
            return true;
        }
        return this.mMore;
    }

    private void fireAnimationStart() {
        if (this.mListener != null) {
            if (this.mListenerHandler == null) {
                this.mListener.onAnimationStart();
            } else {
                this.mListenerHandler.postAtFrontOfQueue(this.mOnStart);
            }
        }
    }

    private void fireAnimationRepeat() {
    }

    private void fireAnimationEnd() {
        if (this.mListener != null) {
            if (this.mListenerHandler == null) {
                this.mListener.onAnimationEnd();
            } else {
                this.mListenerHandler.postAtFrontOfQueue(this.mOnEnd);
            }
        }
    }

    public boolean getTransformation(long l2, GLTransformation gLTransformation, float f2) {
        this.mScaleFactor = f2;
        return this.getTransformation(l2, gLTransformation);
    }

    protected boolean hasStarted() {
        return this.mStarted;
    }

    public boolean hasEnded() {
        return this.mEnded;
    }

    protected void applyTransformation(float f2, GLTransformation gLTransformation) {
    }

    public boolean hasAlpha() {
        return false;
    }
}

