/*
 * Decompiled with CFR 0.152.
 */
package com.autonavi.base.ae.gmap.glanimation;

import com.amap.adapter.os.SystemClock;
import com.autonavi.base.ae.gmap.glanimation.AbstractAdglAnimation;
import com.autonavi.base.ae.gmap.glanimation.AbstractAdglAnimationParam2V;

public class AdglAnimation2V
extends AbstractAdglAnimation {
    private AbstractAdglAnimationParam2V v2Param = null;
    private double curValue1;
    private double curValue2;

    public AdglAnimation2V(int n2) {
        this.reset();
        this.duration = n2;
        this.curValue1 = 0.0;
        this.curValue2 = 0.0;
    }

    public void reset() {
        this.isOver = false;
        this.duration = 0;
        this.curValue1 = 0.0;
        this.curValue2 = 0.0;
        if (this.v2Param != null) {
            this.v2Param.reset();
        }
    }

    public double getCurValue(int n2) {
        if (n2 == 0) {
            return this.curValue1;
        }
        return this.curValue2;
    }

    public double getStartValue(int n2) {
        if (n2 == 0) {
            if (this.v2Param != null) {
                return this.v2Param.getFromXValue();
            }
            return 0.0;
        }
        if (this.v2Param != null) {
            return this.v2Param.getFromYValue();
        }
        return 0.0;
    }

    public double getEndValue(int n2) {
        if (n2 == 0) {
            if (this.v2Param != null) {
                return this.v2Param.getToXValue();
            }
            return 0.0;
        }
        if (this.v2Param != null) {
            return this.v2Param.getToYValue();
        }
        return 0.0;
    }

    @Override
    public void doAnimation(Object object) {
        if (this.isOver) {
            return;
        }
        long l2 = SystemClock.uptimeMillis();
        this.offsetTime = l2 - this.startTime;
        float f2 = (float)this.offsetTime / (float)this.duration;
        if (f2 > 1.0f) {
            f2 = 1.0f;
            this.isOver = true;
        } else if (f2 < 0.0f) {
            this.isOver = true;
            return;
        }
        if (this.v2Param != null) {
            this.v2Param.setNormalizedTime(f2);
            this.curValue1 = this.v2Param.getCurXValue();
            this.curValue2 = this.v2Param.getCurYValue();
        }
    }
}

