/*
 * Decompiled with CFR 0.152.
 */
package com.autonavi.base.ae.gmap.glanimation;

import com.amap.adapter.graphics.Point;
import com.amap.adapter.os.SystemClock;
import com.autonavi.amap.mapcore.IPoint;
import com.autonavi.base.ae.gmap.GLMapState;
import com.autonavi.base.ae.gmap.glanimation.AbstractAdglAnimation;
import com.autonavi.base.ae.gmap.glanimation.AbstractAdglAnimationParam1V;

public class AdglMapAnimPivotZoom
extends AbstractAdglAnimation {
    private boolean hasCheckParams;
    private float mapLevelTo;
    private int beginCenterGeoX;
    private int beginCenterGeoY;
    private int pivotGeoX;
    private int pivotGeoY;
    private boolean zoomCenter;
    private float winPivotX;
    private float winPivotY;
    AbstractAdglAnimationParam1V zoomParam = null;

    public void reset() {
        this.isOver = false;
        this.hasCheckParams = false;
        this.zoomCenter = true;
        this.mapLevelTo = 0.0f;
        this.beginCenterGeoX = 0;
        this.beginCenterGeoY = 0;
        this.pivotGeoX = 0;
        this.pivotGeoY = 0;
        this.winPivotX = 0.0f;
        this.winPivotY = 0.0f;
        if (this.zoomParam != null) {
            this.zoomParam.reset();
        }
    }

    public void commitAnimation(Object object) {
        this.isOver = true;
        this.hasCheckParams = false;
        GLMapState gLMapState = (GLMapState)object;
        if (gLMapState == null) {
            return;
        }
        float f2 = gLMapState.getMapZoomer();
        float f3 = this.mapLevelTo - f2;
        if ((double)Math.abs(f3) < 1.0E-6) {
            this.isOver = true;
            this.hasCheckParams = true;
            return;
        }
        float f4 = f2;
        this.zoomParam.setFromValue(f4);
        this.zoomParam.setToValue(this.mapLevelTo);
        if (!this.zoomCenter) {
            IPoint iPoint = IPoint.obtain();
            gLMapState.getMapGeoCenter(iPoint);
            this.beginCenterGeoX = iPoint.x;
            this.beginCenterGeoY = iPoint.y;
            IPoint iPoint2 = IPoint.obtain();
            gLMapState.screenToP20Point((int)this.winPivotX, (int)this.winPivotY, iPoint2);
            this.pivotGeoX = iPoint2.x;
            this.pivotGeoY = iPoint2.y;
            iPoint.recycle();
            iPoint2.recycle();
        }
        this.hasCheckParams = true;
        this.isOver = false;
        this.startTime = SystemClock.uptimeMillis();
    }

    public AdglMapAnimPivotZoom(int n2) {
        this.reset();
        this.duration = n2;
    }

    public void setToMapZoomAndPivot(float f2, int n2, Point point) {
        this.zoomParam = new AbstractAdglAnimationParam1V();
        this.zoomParam.setInterpolatorType(n2, 1.0f);
        if (f2 > 20.0f) {
            f2 = 20.0f;
        }
        if (f2 < 3.0f) {
            f2 = 3.0f;
        }
        this.mapLevelTo = f2;
        if (point != null) {
            this.winPivotX = point.x;
            this.winPivotY = point.y;
            this.zoomCenter = false;
        }
    }

    @Override
    public void doAnimation(Object object) {
        GLMapState gLMapState = (GLMapState)object;
        if (gLMapState == null) {
            return;
        }
        if (!this.hasCheckParams) {
            this.commitAnimation(object);
        }
        if (this.isOver) {
            return;
        }
        long l2 = SystemClock.uptimeMillis();
        this.offsetTime = l2 - this.startTime;
        float f2 = (float)this.offsetTime / (float)this.duration;
        if (f2 > 1.0f) {
            f2 = 1.0f;
            this.isOver = true;
        }
        if (f2 >= 0.0f && f2 <= 1.0f) {
            this.zoomParam.setNormalizedTime(f2);
            float f3 = this.zoomParam.getCurValue();
            if (f3 > 20.0f) {
                f3 = 20.0f;
                this.isOver = true;
            }
            if (f3 < 3.0f) {
                f3 = 3.0f;
                this.isOver = true;
            }
            if (!this.zoomCenter) {
                float f4 = f3 - this.zoomParam.getFromValue();
                float f5 = (float)Math.pow(2.0, f4);
                int n2 = (int)((float)(this.pivotGeoX - this.beginCenterGeoX) * (1.0f - 1.0f / f5));
                int n3 = (int)((float)(this.pivotGeoY - this.beginCenterGeoY) * (1.0f - 1.0f / f5));
                gLMapState.setMapGeoCenter(this.beginCenterGeoX + n2, this.beginCenterGeoY + n3);
            }
            gLMapState.setMapZoomer(f3);
        }
    }
}

