/*
 * Decompiled with CFR 0.152.
 */
package com.autonavi.base.ae.gmap.gloverlay;

import com.amap.adapter.content.Context;
import com.amap.adapter.graphics.Bitmap;
import com.amap.adapter.graphics.Color;
import com.amap.adapter.graphics.Rect;
import com.amap.adapter.os.Build;
import com.amap.adapter.util.TypedValue;
import com.amap.api.mapcore.util.es;
import com.amap.api.maps.model.BitmapDescriptor;
import com.amap.api.maps.model.BitmapDescriptorFactory;
import com.amap.api.maps.model.CrossOverlay;
import com.autonavi.ae.gmap.gloverlay.AVectorCrossAttr;
import com.autonavi.amap.mapcore.interfaces.IAMap;
import com.autonavi.amap.mapcore.interfaces.ICrossVectorOverlay;
import com.autonavi.base.ae.gmap.gloverlay.BaseMapOverlay;
import com.autonavi.base.ae.gmap.gloverlay.GLCrossVector;
import com.autonavi.base.ae.gmap.gloverlay.GLTextureProperty;
import com.autonavi.base.amap.mapcore.jbinding.JBindingInclude;

@JBindingInclude
public class CrossVectorOverlay
extends BaseMapOverlay<GLCrossVector, Object>
implements ICrossVectorOverlay {
    private boolean isImageMode = false;
    private CrossOverlay.GenerateCrossImageListener imageListener;
    private CrossOverlay.OnCrossVectorUpdateListener updateListener;
    AVectorCrossAttr attr = null;

    public CrossVectorOverlay(int n2, Context context, IAMap iAMap) {
        super(n2, context, iAMap);
    }

    @Override
    protected void iniGLOverlay() {
        if (this.mMapView != null) {
            this.mMapView.queueEvent(new Runnable(){

                @Override
                public void run() {
                    CrossVectorOverlay.this.mGLOverlay = new GLCrossVector(CrossVectorOverlay.this.mEngineID, CrossVectorOverlay.this.mMapView, this.hashCode());
                }
            });
        }
    }

    @Override
    public void addItem(Object object) {
    }

    @Override
    public void resumeMarker(final Bitmap bitmap) {
        if (this.mMapView != null) {
            this.mMapView.queueEvent(new Runnable(){

                @Override
                public void run() {
                    int n2 = 12345;
                    CrossVectorOverlay.this.addOverlayTexture(bitmap, n2, 4);
                    ((GLCrossVector)CrossVectorOverlay.this.mGLOverlay).setArrowResId(false, n2);
                    ((GLCrossVector)CrossVectorOverlay.this.mGLOverlay).setCarResId(n2);
                    n2 = 54321;
                    BitmapDescriptor bitmapDescriptor = BitmapDescriptorFactory.fromAsset("cross/crossing_nigth_bk.data");
                    Bitmap bitmap2 = null;
                    if (bitmapDescriptor != null) {
                        bitmap2 = bitmapDescriptor.getBitmap();
                    }
                    CrossVectorOverlay.this.addOverlayTexture(bitmap2, n2, 0);
                    ((GLCrossVector)CrossVectorOverlay.this.mGLOverlay).setBackgroundResId(n2);
                }
            });
        }
    }

    public void addOverlayTexture(Bitmap bitmap, int n2, int n3) {
        GLTextureProperty gLTextureProperty = new GLTextureProperty();
        gLTextureProperty.mId = n2;
        gLTextureProperty.mAnchor = n3;
        gLTextureProperty.mBitmap = bitmap;
        gLTextureProperty.mXRatio = 0.0f;
        gLTextureProperty.mYRatio = 0.0f;
        gLTextureProperty.isGenMimps = true;
        this.mMapView.addOverlayTexture(this.mEngineID, gLTextureProperty);
    }

    public int dipToPixel(Context context, int n2) {
        if (context == null) {
            return n2;
        }
        try {
            float f2 = TypedValue.applyDimension(1, n2, context.getResources().getDisplayMetrics());
            return (int)f2;
        }
        catch (Exception exception) {
            return n2;
        }
    }

    @Override
    public void setAttribute(AVectorCrossAttr aVectorCrossAttr) {
        this.attr = aVectorCrossAttr;
    }

    @Override
    public void setVisible(final boolean bl2) {
        if (this.mMapView != null) {
            this.mMapView.queueEvent(new Runnable(){

                @Override
                public void run() {
                    if (CrossVectorOverlay.this.mGLOverlay != null) {
                        ((GLCrossVector)CrossVectorOverlay.this.mGLOverlay).setVisible(bl2);
                    }
                }
            });
        }
    }

    @Override
    public int setData(final byte[] byArray) {
        int n2 = -1;
        if (Build.VERSION.SDK_INT < 21) {
            this.drawVectorFailed(n2);
            return n2;
        }
        if (this.attr == null) {
            this.attr = new AVectorCrossAttr();
            this.attr.stAreaRect = new Rect(0, 0, this.mMapView.getMapWidth(), this.mMapView.getMapHeight() * 4 / 11);
            this.attr.stAreaColor = Color.argb(217, 95, 95, 95);
            this.attr.fArrowBorderWidth = this.dipToPixel(this.mContext, 22);
            this.attr.stArrowBorderColor = Color.argb(0, 0, 50, 20);
            this.attr.fArrowLineWidth = this.dipToPixel(this.mContext, 18);
            this.attr.stArrowLineColor = Color.argb(255, 255, 253, 65);
            this.attr.dayMode = false;
        }
        if (null != byArray && this.attr != null && this.mMapView != null) {
            this.mMapView.queueEvent(new Runnable(){

                @Override
                public void run() {
                    CrossVectorOverlay.this.initImageMode(CrossVectorOverlay.this.isImageMode);
                    int n2 = ((GLCrossVector)CrossVectorOverlay.this.mGLOverlay).addVectorItem(CrossVectorOverlay.this.attr, byArray, byArray.length);
                    if (n2 != 0) {
                        CrossVectorOverlay.this.drawVectorFailed(n2);
                    } else if (CrossVectorOverlay.this.updateListener != null) {
                        CrossOverlay.UpdateItem updateItem = new CrossOverlay.UpdateItem();
                        updateItem.dataUpdateFlag = n2;
                        CrossVectorOverlay.this.updateListener.onUpdate(0, updateItem);
                    }
                }
            });
        }
        return n2;
    }

    private void drawVectorFailed(int n2) {
        if (this.isImageMode && this.imageListener != null) {
            this.imageListener.onGenerateComplete(null, n2);
        }
        if (this.updateListener != null) {
            CrossOverlay.UpdateItem updateItem = new CrossOverlay.UpdateItem();
            updateItem.dataUpdateFlag = n2;
            this.updateListener.onUpdate(0, updateItem);
        }
    }

    private void initImageMode(boolean bl2) {
        if (this.mGLOverlay != null) {
            ((GLCrossVector)this.mGLOverlay).initTextureCallback(this, bl2);
        }
    }

    @Override
    public void remove() {
        this.imageListener = null;
        this.setVisible(false);
        if (this.mMapView != null) {
            this.mMapView.queueEvent(new Runnable(){

                @Override
                public void run() {
                    CrossVectorOverlay.this.releaseInstance();
                }
            });
        }
    }

    @Override
    public void setImageMode(boolean bl2) {
        this.isImageMode = bl2;
    }

    @Override
    public void setGenerateCrossImageListener(CrossOverlay.GenerateCrossImageListener generateCrossImageListener) {
        this.imageListener = generateCrossImageListener;
    }

    @Override
    public void setOnCrossVectorUpdateListener(CrossOverlay.OnCrossVectorUpdateListener onCrossVectorUpdateListener) {
        this.updateListener = onCrossVectorUpdateListener;
    }

    @JBindingInclude
    public void imageContentResult(int[] nArray, int n2, int n3) {
        if (nArray == null) {
            this.drawVectorFailed(-1);
            return;
        }
        if (this.imageListener != null) {
            Bitmap bitmap;
            this.imageListener.onGenerateComplete(bitmap, (bitmap = es.a(nArray, n2, n3)) != null ? 0 : -1);
        }
    }
}

