/*
 * Decompiled with CFR 0.152.
 */
package com.autonavi.base.ae.gmap.gloverlay;

import com.autonavi.base.ae.gmap.gloverlay.GLOverlayBundle;
import com.autonavi.base.amap.api.mapcore.IAMapDelegate;

public abstract class GLOverlay {
    protected int mCode;
    protected IAMapDelegate mGLMapView;
    protected int mEngineID;
    protected boolean isNightStyle = false;
    boolean mIsInBundle = false;
    protected long mNativeInstance = 0L;
    protected int mItemPriority = 0;

    public GLOverlay(int n2, IAMapDelegate iAMapDelegate, int n3) {
        this.mEngineID = n2;
        this.mGLMapView = iAMapDelegate;
        this.mCode = n3;
        this.mNativeInstance = 0L;
        this.mItemPriority = 0;
    }

    public long getNativeInstatnce() {
        return this.mNativeInstance;
    }

    public int getCode() {
        return this.mCode;
    }

    public int getType() {
        if (this.mNativeInstance == 0L) {
            return -1;
        }
        return GLOverlay.nativeGetType(this.mNativeInstance);
    }

    public int getSubType() {
        if (this.mNativeInstance == 0L) {
            return -1;
        }
        return GLOverlay.nativeGetSubType(this.mNativeInstance);
    }

    public void removeItem(int n2) {
        if (this.mNativeInstance == 0L) {
            return;
        }
        GLOverlay.nativeRemoveItem(this.mNativeInstance, n2);
    }

    public void removeAll() {
        if (this.mNativeInstance == 0L) {
            return;
        }
        GLOverlay.nativeRemoveAll(this.mNativeInstance);
        if (this.mGLMapView != null) {
            // empty if block
        }
    }

    public int getSize() {
        if (this.mNativeInstance == 0L) {
            return 0;
        }
        return GLOverlay.nativeGetCount(this.mNativeInstance);
    }

    public void setVisible(boolean bl2) {
        if (this.mNativeInstance == 0L) {
            return;
        }
        GLOverlay.nativeSetVisible(this.mNativeInstance, bl2);
    }

    public boolean isVisible() {
        if (this.mNativeInstance == 0L) {
            return false;
        }
        return GLOverlay.nativeIsVisible(this.mNativeInstance);
    }

    public void setClickable(boolean bl2) {
        if (this.mNativeInstance == 0L) {
            return;
        }
        GLOverlay.nativeSetClickable(this.mNativeInstance, bl2);
    }

    public boolean isClickable() {
        if (this.mNativeInstance == 0L) {
            return false;
        }
        return GLOverlay.nativeIsClickable(this.mNativeInstance);
    }

    public void clearFocus() {
    }

    public boolean getIsInBundle() {
        return this.mIsInBundle;
    }

    public void setMaxCountShown(int n2) {
        GLOverlay.nativeSetShownMaxCount(this.mNativeInstance, n2);
    }

    public void setOverlayOnTop(boolean bl2) {
        GLOverlay.nativeSetOverlayOnTop(this.mNativeInstance, bl2);
    }

    public void setMinDisplayLevel(float f2) {
        GLOverlay.nativeSetMinDisplayLevel(this.mNativeInstance, f2);
    }

    public void setMaxDisplayLevel(float f2) {
        GLOverlay.nativeSetMaxDisplayLevel(this.mNativeInstance, f2);
    }

    public void setOverlayPriority(int n2) {
        GLOverlayBundle gLOverlayBundle;
        GLOverlay.nativeSetOverlayPriority(this.mNativeInstance, n2);
        if (this.mGLMapView != null && this.mGLMapView.getGLMapEngine() != null && null != (gLOverlayBundle = this.mGLMapView.getGLMapEngine().getOverlayBundle(this.mEngineID))) {
            gLOverlayBundle.sortOverlay();
        }
    }

    public int getOverlayPriority() {
        return GLOverlay.nativeGetOverlayPriority(this.mNativeInstance);
    }

    public void setOverlayItemPriority(int n2) {
        this.mItemPriority = n2;
    }

    void releaseInstance() {
        if (this.mNativeInstance != 0L) {
            long l2 = this.mNativeInstance;
            this.mNativeInstance = 0L;
        }
    }

    private static native int nativeGetType(long var0);

    private static native int nativeGetSubType(long var0);

    private static native void nativeRemoveItem(long var0, int var2);

    private static native void nativeRemoveAll(long var0);

    private static native int nativeGetCount(long var0);

    protected static native void nativeSetVisible(long var0, boolean var2);

    private static native boolean nativeIsVisible(long var0);

    private static native void nativeSetClickable(long var0, boolean var2);

    private static native boolean nativeIsClickable(long var0);

    private static native void nativeSetOverlayOnTop(long var0, boolean var2);

    private static native void nativeSetMinDisplayLevel(long var0, float var2);

    private static native void nativeSetMaxDisplayLevel(long var0, float var2);

    private static native void nativeSetShownMaxCount(long var0, int var2);

    private static native void nativeSetOverlayPriority(long var0, int var2);

    private static native int nativeGetOverlayPriority(long var0);

    private static native void nativeSetOverlayItemPriority(long var0, int var2);

    public void useNightStyle(boolean bl2) {
        this.isNightStyle = bl2;
    }

    public static enum EAMapOverlayTpye {
        AMAPOVERLAY_POINT,
        AMAPOVERLAY_POLYLINE,
        AMAPOVERLAY_POLYGON,
        AMAPOVERLAY_ARC,
        AMAPOVERLAY_ARROW,
        AMAPOVERLAY_VECTOR,
        AMAPOVERLAY_GROUP,
        AMAPOVERLAY_MODEL,
        AMAPOVERLAY_PLANE;

    }
}

