/*
 * Decompiled with CFR 0.152.
 */
package com.autonavi.base.amap.mapcore;

import com.amap.adapter.util.Log;
import com.amap.api.mapcore.util.df;
import com.amap.api.mapcore.util.ed;
import com.amap.api.maps.model.BaseOptions;
import com.amap.api.maps.model.BitmapDescriptor;
import com.amap.api.maps.model.LatLng;
import com.autonavi.base.amap.mapcore.MapConfig;
import com.autonavi.base.amap.mapcore.NativeBase;
import com.autonavi.base.amap.mapcore.annotations.ParameterIsClass;
import com.autonavi.base.amap.mapcore.jbinding.JBindingInclude;
import java.util.concurrent.locks.ReentrantReadWriteLock;

@JBindingInclude
public class AMapNativeGlOverlayLayer
extends NativeBase {
    @JBindingInclude
    protected long mNative = 0L;
    private NativeFunCallListener nativeFunCallListener;
    private ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();

    @Override
    protected long getNative() {
        return this.mNative;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createOverlay(final String string, final BaseOptions baseOptions) {
        if (!this.isReady()) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    AMapNativeGlOverlayLayer.this.createOverlay(string, baseOptions);
                }
            };
            this.storeUncallFunction(this, runnable, string, baseOptions);
        } else {
            this.callAllFunction();
            try {
                this.readWriteLock.readLock().lock();
                this.nativeCreateOverlay(string, baseOptions);
            }
            finally {
                this.readWriteLock.readLock().unlock();
            }
        }
    }

    @ParameterIsClass
    public void removeOverlay(final String string) {
        if (!this.isReady()) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    AMapNativeGlOverlayLayer.this.removeOverlay(string);
                }
            };
            this.storeUncallFunction(this, runnable, string);
        } else {
            this.callAllFunction();
            try {
                this.readWriteLock.readLock().lock();
                this.nativeRemoveOverlay(string);
            }
            finally {
                this.readWriteLock.readLock().unlock();
            }
        }
    }

    @ParameterIsClass
    public void clear(final String ... stringArray) {
        if (!this.isReady()) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    AMapNativeGlOverlayLayer.this.clear(stringArray);
                }
            };
            this.storeUncallFunctionArray(this, runnable, stringArray);
        } else {
            this.callAllFunction();
            try {
                this.readWriteLock.readLock().lock();
                this.nativeClear(stringArray);
            }
            finally {
                this.readWriteLock.readLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterIsClass
    public void setConfig(final MapConfig mapConfig, final Float f2) {
        if (!this.isReady()) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    AMapNativeGlOverlayLayer.this.setConfig(mapConfig, f2);
                }
            };
            this.storeUncallFunction(this, runnable, mapConfig, f2);
        } else {
            this.callAllFunction();
            try {
                this.readWriteLock.readLock().lock();
                this.nativeUpdateConfig(mapConfig, f2.floatValue());
            }
            finally {
                this.readWriteLock.readLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterIsClass
    public void updateOptions(final String string, final BaseOptions baseOptions) {
        block7: {
            try {
                if (!this.isReady()) {
                    Runnable runnable = new Runnable(){

                        @Override
                        public void run() {
                            AMapNativeGlOverlayLayer.this.updateOptions(string, baseOptions);
                            if (baseOptions != null) {
                                baseOptions.resetUpdateFlags();
                            }
                            AMapNativeGlOverlayLayer.this.setRunLowFrame(false);
                        }
                    };
                    this.storeUncallFunction(this, runnable, string, baseOptions);
                    break block7;
                }
                this.callAllFunction();
                try {
                    this.readWriteLock.readLock().lock();
                    this.nativeUpdateOptions(string, baseOptions);
                    if (baseOptions != null) {
                        baseOptions.resetUpdateFlags();
                    }
                }
                finally {
                    this.readWriteLock.readLock().unlock();
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                Log.d("amapApi", "AMapNativeGlOverlayLayer updateOptions error:" + throwable.getMessage());
            }
        }
    }

    public String contain(LatLng latLng) {
        String string = "";
        if (this.isReady()) {
            this.callAllFunction();
            try {
                this.readWriteLock.readLock().lock();
                string = this.nativeContain(latLng);
            }
            finally {
                this.readWriteLock.readLock().unlock();
            }
        }
        return string;
    }

    public int getCurrentParticleNum(String string) {
        int n2 = 0;
        if (this.isReady()) {
            this.callAllFunction();
            try {
                this.readWriteLock.readLock().lock();
                n2 = this.nativeGetCurrentParticleNum(string);
            }
            finally {
                this.readWriteLock.readLock().unlock();
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getNativeProperties(final String string, final String string2, final Object[] objectArray) {
        if (!this.isReady() || string == null) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    AMapNativeGlOverlayLayer.this.getNativeProperties(string, string2, objectArray);
                }
            };
            this.storeUncallFunction(this, runnable, string, string2, objectArray);
            return null;
        }
        try {
            Object object;
            this.readWriteLock.readLock().lock();
            Object object2 = object = this.nativeGetNativeOverlayProperties(string, string2, objectArray);
            return object2;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render(int n2, int n3, boolean bl2) {
        this.callAllFunction();
        try {
            this.readWriteLock.readLock().lock();
            this.nativeRender(n2, n3, bl2);
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    public void setNativeFunCallListener(NativeFunCallListener nativeFunCallListener) {
        this.nativeFunCallListener = nativeFunCallListener;
    }

    public void setShaderManager(df df2) {
        if (this.mNative != 0L) {
            try {
                this.readWriteLock.readLock().lock();
                if (df2 != null) {
                    this.nativeSetShaderManager(df2.a());
                }
            }
            finally {
                this.readWriteLock.readLock().unlock();
            }
        }
    }

    @Override
    public void destroy() {
        try {
            super.destroy();
            this.readWriteLock.writeLock().lock();
            this.nativeDestroy();
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    @JBindingInclude
    private void setRunLowFrame(boolean bl2) {
        if (this.nativeFunCallListener != null) {
            this.nativeFunCallListener.onSetRunLowFrame(bl2);
        }
    }

    @JBindingInclude
    private void redrawInfoWindow() {
        if (this.nativeFunCallListener != null) {
            this.nativeFunCallListener.onRedrawInfowindow();
        }
    }

    @JBindingInclude
    private BitmapDescriptor getInfoWindow(String string) {
        if (this.nativeFunCallListener != null) {
            return this.nativeFunCallListener.getInfoWindow(string);
        }
        return null;
    }

    @JBindingInclude
    private BitmapDescriptor getInfoContents(String string) {
        if (this.nativeFunCallListener != null) {
            return this.nativeFunCallListener.getInfoContents(string);
        }
        return null;
    }

    @JBindingInclude
    private long getInfoWindowUpdateOffsetTime(String string) {
        if (this.nativeFunCallListener != null) {
            return this.nativeFunCallListener.getInfoWindowUpdateOffsetTime(string);
        }
        return 0L;
    }

    @JBindingInclude
    private BitmapDescriptor getInfoWindowClick(String string) {
        if (this.nativeFunCallListener != null) {
            return this.nativeFunCallListener.getInfoWindowClick(string);
        }
        return null;
    }

    @JBindingInclude
    private BitmapDescriptor getOverturnInfoWindow(String string) {
        if (this.nativeFunCallListener != null) {
            return this.nativeFunCallListener.getOverturnInfoWindow(string);
        }
        return null;
    }

    @JBindingInclude
    private BitmapDescriptor getOverturnInfoWindowClick(String string) {
        if (this.nativeFunCallListener != null) {
            return this.nativeFunCallListener.getOverturnInfoWindowClick(string);
        }
        return null;
    }

    @JBindingInclude
    private BitmapDescriptor getBuildInImageData(int n2) {
        if (this.nativeFunCallListener != null) {
            return this.nativeFunCallListener.getBuildInImageData(n2);
        }
        return null;
    }

    public void setAMapEngine(long l2) {
        try {
            this.readWriteLock.readLock().lock();
            this.nativeSetAMapEngine(l2);
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    @Override
    public void createNative() {
        block8: {
            try {
                if (this.mNative != 0L) break block8;
                try {
                    if (this.readWriteLock != null) {
                        this.readWriteLock.writeLock().lock();
                    }
                    this.nativeCreate();
                }
                catch (Throwable throwable) {
                }
                finally {
                    if (this.readWriteLock != null) {
                        this.readWriteLock.writeLock().unlock();
                    }
                }
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                ed.a(111, this.getClass().getSimpleName(), "execute error: ", unsatisfiedLinkError.toString());
            }
        }
    }

    @Override
    protected void finalizeNative() {
        this.nativeFinalize();
    }

    private native void nativeCreateOverlay(String var1, Object var2);

    private native void nativeRemoveOverlay(String var1);

    private native void nativeUpdateConfig(Object var1, float var2);

    private native void nativeUpdateOptions(String var1, Object var2);

    private native void nativeRender(int var1, int var2, boolean var3);

    private native void nativeClear(String[] var1);

    private native String nativeContain(Object var1);

    private native int nativeGetCurrentParticleNum(String var1);

    private native Object nativeGetNativeOverlayProperties(String var1, String var2, Object[] var3);

    private native void nativeSetAMapEngine(long var1);

    private native void nativeSetShaderManager(long var1);

    private native void nativeDestroy();

    private native void nativeCreate();

    private native void nativeFinalize();

    public static interface NativeFunCallListener {
        public void onSetRunLowFrame(boolean var1);

        public void onRedrawInfowindow();

        public BitmapDescriptor getInfoWindow(String var1);

        public BitmapDescriptor getInfoContents(String var1);

        public long getInfoWindowUpdateOffsetTime(String var1);

        public BitmapDescriptor getInfoWindowClick(String var1);

        public BitmapDescriptor getOverturnInfoWindow(String var1);

        public BitmapDescriptor getOverturnInfoWindowClick(String var1);

        public BitmapDescriptor getBuildInImageData(int var1);
    }
}

