/*
 * Decompiled with CFR 0.152.
 */
package com.autonavi.base.amap.mapcore;

import com.autonavi.base.amap.mapcore.ConvertString;
import java.io.ByteArrayOutputStream;

public class Convert {
    public static int getInt(byte[] byArray, int n2) {
        int n3 = byArray[3 + n2] & 0xFF;
        int n4 = byArray[2 + n2] & 0xFF;
        int n5 = byArray[1 + n2] & 0xFF;
        int n6 = byArray[0 + n2] & 0xFF;
        int n7 = (n3 << 24) + (n4 << 16) + (n5 << 8) + (n6 << 0);
        return n7;
    }

    public static short getShort(byte[] byArray, int n2) {
        int n3 = byArray[n2 + 1] & 0xFF;
        int n4 = byArray[n2 + 0] & 0xFF;
        short s2 = (short)((n3 << 8) + (n4 << 0));
        return s2;
    }

    public static int getUShort(byte[] byArray, int n2) {
        int n3 = byArray[n2 + 1] & 0xFF;
        int n4 = byArray[n2 + 0] & 0xFF;
        int n5 = (n3 << 8) + (n4 << 0);
        return n5;
    }

    public static boolean getBit(byte n2, int n3) {
        int n4 = n2;
        n4 <<= 32 - n3;
        n4 >>>= 32 - n3;
        return (n4 >>>= n3 - 1) > 0;
    }

    public static byte[] copyString(byte[] byArray, int n2, int n3) {
        byte[] byArray2 = new byte[n3];
        System.arraycopy(byArray, n2, byArray2, 0, n3);
        return byArray2;
    }

    public static byte[] covertBytes(byte by2) {
        byte[] byArray = new byte[]{by2};
        return byArray;
    }

    public static byte[] convertInt(int n2) {
        byte[] byArray = new byte[]{(byte)(n2 & 0xFF), (byte)(n2 >> 8 & 0xFF), (byte)(n2 >> 16 & 0xFF), (byte)(n2 >> 24 & 0xFF)};
        return byArray;
    }

    public static int getNum(byte n2, int n3, int n4) {
        int n5 = n2;
        n5 <<= 32 - n4 - 1;
        n5 >>>= 32 - n4 - 1;
        return n5 >>>= n3;
    }

    public static int getNum(short n2, int n3, int n4) {
        int n5 = n2;
        n5 <<= 32 - n4;
        n5 >>>= 32 - n4;
        return n5 >>>= n3 - 1;
    }

    public static byte[] convertShort(int n2) {
        byte[] byArray = new byte[]{(byte)(n2 & 0xFF), (byte)(n2 >> 8 & 0xFF)};
        return byArray;
    }

    public static void writeInt(byte[] byArray, int n2, int n3) {
        byte[] byArray2 = Convert.convertInt(n3);
        System.arraycopy(byArray2, 0, byArray, n2, 4);
    }

    public static void writeShort(byte[] byArray, int n2, short s2) {
        byte[] byArray2 = Convert.convertShort(s2);
        System.arraycopy(byArray2, 0, byArray, n2, 2);
    }

    public static void moveArray(byte[] byArray, int n2, byte[] byArray2, int n3, int n4) {
        byte[] byArray3 = new byte[n4];
        System.arraycopy(byArray, n2, byArray3, 0, n4);
        System.arraycopy(byArray3, 0, byArray2, n3, n4);
    }

    public static String getString(byte[] byArray, int n2, int n3) {
        try {
            return new String(byArray, n2, n3, "UTF-8");
        }
        catch (Exception exception) {
            return "";
        }
    }

    public static byte[] getSubBytes(byte[] byArray, int n2, int n3) {
        byte[] byArray2 = new byte[n3];
        System.arraycopy(byArray, n2, byArray2, 0, n3);
        return byArray2;
    }

    public static byte[] get1BString(String string) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] byArray = string.getBytes("UTF-8");
            byte[] byArray2 = new byte[]{(byte)byArray.length};
            byteArrayOutputStream.write(byArray2);
            byteArrayOutputStream.write(byArray);
            return byteArrayOutputStream.toByteArray();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return new byte[1];
        }
    }

    public static byte[] get2BString(String string) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] byArray = string.getBytes("UTF-8");
            byteArrayOutputStream.write(Convert.convertShort(byArray.length));
            byteArrayOutputStream.write(byArray);
            return byteArrayOutputStream.toByteArray();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return new byte[1];
        }
    }

    public static double convertDouble(byte[] byArray, int n2) {
        long l2 = 0L;
        int n3 = 8;
        for (int i2 = 0; i2 < n3; ++i2) {
            l2 += (long)(byArray[i2 + n2] & 0xFF) << 8 * i2;
        }
        return Double.longBitsToDouble(l2);
    }

    public static byte[] getDouble(double d2) {
        byte[] byArray = new byte[8];
        long l2 = Double.doubleToLongBits(d2);
        String string = Long.toHexString(l2);
        int n2 = 8;
        for (int i2 = 0; i2 < n2; ++i2) {
            String string2 = string.substring(2 * i2, 2 * i2 + 2);
            byArray[7 - i2] = (byte)Integer.parseInt(string2, 16);
        }
        return byArray;
    }

    public static void convert1bString(byte[] byArray, int n2, ConvertString convertString) {
        try {
            convertString.byteLength = byArray[n2];
            convertString.value = new String(byArray, n2 + 1, convertString.byteLength, "UTF-8");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            convertString.byteLength = 0;
            convertString.value = "";
        }
    }

    public static void convert2bString(byte[] byArray, int n2, ConvertString convertString) {
        try {
            convertString.byteLength = Convert.getShort(byArray, n2);
            convertString.value = new String(byArray, n2 + 2, convertString.byteLength, "UTF-8");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            convertString.byteLength = 0;
            convertString.value = "";
        }
    }

    public static final String bytesToHexString(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer(byArray.length);
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            String string = Integer.toHexString(0xFF & byArray[i2]);
            if (string.length() < 2) {
                stringBuffer.append(0);
            }
            stringBuffer.append(string.toUpperCase());
        }
        return stringBuffer.toString();
    }
}

