/*
 * Decompiled with CFR 0.152.
 */
package com.autonavi.base.amap.mapcore;

import com.amap.adapter.graphics.PointF;
import com.autonavi.ae.gmap.maploader.Pools;

public class FPoint
extends PointF {
    private static final Pools.SynchronizedPool<FPoint> M_POOL = new Pools.SynchronizedPool(32);

    public static FPoint obtain() {
        FPoint fPoint = M_POOL.acquire();
        if (fPoint == null) {
            fPoint = new FPoint();
        } else {
            fPoint.set(0.0f, 0.0f);
        }
        return fPoint;
    }

    public static FPoint obtain(float f2, float f3) {
        FPoint fPoint = M_POOL.acquire();
        if (fPoint == null) {
            fPoint = new FPoint(f2, f3);
        } else {
            fPoint.set(f2, f3);
        }
        return fPoint;
    }

    public void recycle() {
        M_POOL.release(this);
    }

    public FPoint() {
    }

    public FPoint(float f2, float f3) {
        this.x = f2;
        this.y = f3;
    }

    public boolean equals(Object object) {
        FPoint fPoint = (FPoint)object;
        if (fPoint == null) {
            return false;
        }
        return this.x == fPoint.x && this.y == fPoint.y;
    }

    public int hashCode() {
        int n2 = 17;
        n2 = 37 * Float.floatToIntBits(this.x);
        n2 = 37 * Float.floatToIntBits(this.y);
        return n2;
    }
}

