/*
 * Decompiled with CFR 0.152.
 */
package com.autonavi.base.amap.mapcore;

import com.amap.adapter.content.Context;
import com.amap.adapter.content.SharedPreferences;
import com.amap.adapter.content.res.AssetManager;
import com.amap.adapter.os.Build;
import com.amap.adapter.os.Environment;
import com.amap.adapter.os.storage.StorageManager;
import com.amap.adapter.text.TextUtils;
import com.amap.adapter.util.Log;
import com.amap.adapter.util.Pair;
import com.amap.api.mapcore.util.es;
import com.amap.api.mapcore.util.ey;
import com.amap.api.mapcore.util.ez;
import com.amap.api.mapcore.util.hd;
import com.amap.api.maps.MapsInitializer;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class FileUtil {
    private static final char UNIX_SEPARATOR = '/';
    private static final char WINDOWS_SEPARATOR = '\\';
    private static final String TAG = "FileUtil";
    private static final int BUFFER = 1024;
    private static final String FILE_PATH_ENTRY_BACK = "..";
    private static final String FILE_PATH_ENTRY_SEPARATOR1 = "\\";
    private static final String FILE_PATH_ENTRY_SEPARATOR2 = "%";

    public static boolean deleteFile(File file) {
        File[] fileArray;
        if (file == null || !file.exists()) {
            return false;
        }
        if (file.isDirectory() && (fileArray = file.listFiles()) != null) {
            for (int i2 = 0; i2 < fileArray.length; ++i2) {
                if (fileArray[i2].isFile()) {
                    if (fileArray[i2].delete()) continue;
                    return false;
                }
                if (!FileUtil.deleteFile(fileArray[i2])) {
                    return false;
                }
                fileArray[i2].delete();
            }
        }
        file.delete();
        return true;
    }

    public static String getMapBaseStorage(Context context) {
        File file;
        if (context == null) {
            return null;
        }
        int n2 = Build.VERSION.SDK_INT;
        String string = "map_base_path";
        int n3 = 18;
        if (n2 > n3) {
            string = "map_base_path_v44";
        }
        String string2 = "";
        SharedPreferences sharedPreferences = context.getSharedPreferences("base_path", 0);
        string2 = MapsInitializer.sdcardDir != null && MapsInitializer.sdcardDir.trim().length() > 0 ? MapsInitializer.sdcardDir + File.separatorChar : sharedPreferences.getString(string, "");
        int n4 = 2;
        if (string2 != null && string2.length() > n4) {
            file = new File(string2);
            if (!file.exists()) {
                file.mkdir();
            }
            if (file.isDirectory()) {
                if (FileUtil.checkCanWrite(file)) {
                    return string2;
                }
                string2 = context.getCacheDir().toString() + "/amap/";
                if (string2 != null && string2.length() > n4) {
                    file = new File(string2);
                    if (!file.exists()) {
                        file.mkdir();
                    }
                    if (file.isDirectory()) {
                        return string2;
                    }
                }
            }
        }
        if ((string2 = FileUtil.getExternalStroragePath(context) + "/amap/") != null && string2.length() > n4) {
            file = new File(string2);
            if (!file.exists()) {
                file.mkdir();
            }
            if (file.isDirectory() && file.canWrite()) {
                SharedPreferences.Editor editor = sharedPreferences.edit();
                editor.putString(string, string2);
                editor.commit();
                FileUtil.createNoMediaFileIfNotExist(string2);
                return string2;
            }
        }
        if ((string2 = context.getCacheDir().toString() + "/amap/") != null && string2.length() > n4) {
            file = new File(string2);
            if (!file.exists()) {
                file.mkdir();
            }
            if (file.isDirectory()) {
                return string2;
            }
        }
        return string2;
    }

    public static boolean checkCanWrite(File file) {
        if (file == null) {
            return false;
        }
        if (!file.canWrite()) {
            return false;
        }
        File file2 = new File(file, "amap.tmp");
        try {
            file2.createNewFile();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return false;
        }
        if (file2 == null || !file2.exists()) {
            return false;
        }
        try {
            file2.delete();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        return true;
    }

    public static String getExternalStroragePath(Context context) {
        int n2 = Build.VERSION.SDK_INT;
        int n3 = 12;
        if (n2 >= n3) {
            try {
                int n4;
                StorageManager storageManager = (StorageManager)context.getSystemService("storage");
                Method method = StorageManager.class.getMethod("getVolumeList", new Class[0]);
                Method method2 = StorageManager.class.getMethod("getVolumeState", String.class);
                Object[] objectArray = (Object[])method.invoke((Object)storageManager, new Object[0]);
                String string = null;
                String string2 = null;
                Boolean bl2 = false;
                String string3 = "";
                String string4 = "";
                String string5 = "";
                String string6 = "";
                String string7 = null;
                for (Object object : objectArray) {
                    Method method3 = object.getClass().getMethod("getPath", new Class[0]);
                    Method method4 = object.getClass().getMethod("isRemovable", new Class[0]);
                    string2 = (String)method3.invoke(object, new Object[0]);
                    string = (String)method2.invoke((Object)storageManager, method3.invoke(object, new Object[0]));
                    bl2 = (Boolean)method4.invoke(object, new Object[0]);
                    if (!TextUtils.isEmpty(string2) && string2.toLowerCase().contains("private")) continue;
                    if (bl2.booleanValue()) {
                        string3 = string2;
                        string5 = string;
                        if (null == string3 || null == string5 || !string5.equals("mounted")) continue;
                        if (n2 <= 18) {
                            string7 = string3;
                            break;
                        }
                        try {
                            File[] fileArray = context.getExternalFilesDirs(null);
                            if (fileArray == null) break;
                            if (fileArray.length > 1) {
                                string7 = fileArray[1].getAbsolutePath();
                                break;
                            }
                            string7 = string2;
                        }
                        catch (Exception exception) {
                            string7 = string3;
                        }
                        break;
                    }
                    string4 = string2;
                    string6 = string;
                }
                if (n2 <= (n4 = 18)) {
                    if (null == string7 && null != string4 && null != string6 && string6.equals("mounted")) {
                        string7 = string4;
                    }
                    return string7;
                }
                if (null != string4 && null != string6 && string6.equals("mounted")) {
                    string7 = string4;
                }
                return string7;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        File file = null;
        boolean bl3 = Environment.getExternalStorageState().equals("mounted");
        if (bl3) {
            file = Environment.getExternalStorageDirectory();
            return file.toString();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeDatasToFile(String string, byte[] byArray) {
        block8: {
            ReentrantReadWriteLock reentrantReadWriteLock = new ReentrantReadWriteLock();
            ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
            writeLock.lock();
            FileOutputStream fileOutputStream = null;
            try {
                if (byArray == null || byArray.length == 0) {
                    return;
                }
                File file = new File(string);
                if (file.exists()) {
                    file.delete();
                }
                file.createNewFile();
                fileOutputStream = new FileOutputStream(file);
                ((OutputStream)fileOutputStream).write(byArray);
                fileOutputStream.flush();
                writeLock.unlock();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                break block8;
            }
            finally {
                writeLock.unlock();
                FileUtil.safelyCloseFile(fileOutputStream);
            }
            FileUtil.safelyCloseFile(fileOutputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static byte[] readFileContents(String string) {
        byte[] byArray;
        File file;
        ByteArrayOutputStream byteArrayOutputStream;
        FileInputStream fileInputStream;
        block6: {
            fileInputStream = null;
            byteArrayOutputStream = null;
            file = new File(string);
            if (file.exists()) break block6;
            byte[] byArray2 = null;
            FileUtil.safelyCloseFile(byteArrayOutputStream);
            FileUtil.safelyCloseFile(fileInputStream);
            return byArray2;
        }
        try {
            fileInputStream = new FileInputStream(file);
            byte[] byArray3 = new byte[1024];
            byteArrayOutputStream = new ByteArrayOutputStream();
            int n2 = 0;
            while ((n2 = fileInputStream.read(byArray3)) != -1) {
                byteArrayOutputStream.write(byArray3, 0, n2);
            }
            byArray = byteArrayOutputStream.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                hd.c(throwable, TAG, "readFileContents");
                es.a(throwable);
                ez.b(ey.f, "read file from disk failed " + throwable.getMessage());
            }
            catch (Throwable throwable2) {
                FileUtil.safelyCloseFile(byteArrayOutputStream);
                FileUtil.safelyCloseFile(fileInputStream);
                throw throwable2;
            }
            FileUtil.safelyCloseFile(byteArrayOutputStream);
            FileUtil.safelyCloseFile(fileInputStream);
            return null;
        }
        FileUtil.safelyCloseFile(byteArrayOutputStream);
        FileUtil.safelyCloseFile(fileInputStream);
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveFileContents(String string, byte[] byArray) {
        FileOutputStream fileOutputStream = null;
        try {
            File file = new File(string);
            fileOutputStream = new FileOutputStream(file);
            fileOutputStream.write(byArray);
        }
        catch (Throwable throwable) {
            try {
                hd.c(throwable, TAG, "saveFileContents");
                es.a(throwable);
                ez.b(ey.f, "save file from disk failed " + throwable.getMessage());
            }
            catch (Throwable throwable2) {
                FileUtil.safelyCloseFile(fileOutputStream);
                throw throwable2;
            }
            FileUtil.safelyCloseFile(fileOutputStream);
        }
        FileUtil.safelyCloseFile(fileOutputStream);
    }

    public static void createNoMediaFileIfNotExist(String string) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void saveFile(String string, String string2, boolean bl2) {
        block8: {
            FileOutputStream fileOutputStream = null;
            try {
                String string3 = Environment.getExternalStorageDirectory().getAbsolutePath();
                File file = new File(string3 + "/" + string2);
                if (!file.exists()) {
                    File file2 = new File(file.getParent());
                    file2.mkdirs();
                    file.createNewFile();
                }
                fileOutputStream = new FileOutputStream(file, bl2);
                fileOutputStream.write(string.getBytes("utf-8"));
                FileUtil.safelyCloseFile(fileOutputStream);
            }
            catch (FileNotFoundException fileNotFoundException) {
                fileNotFoundException.printStackTrace();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                break block8;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                FileUtil.safelyCloseFile(fileOutputStream);
            }
        }
    }

    public static byte[] readFileContentsFromAssetsByPreName(Context context, String string, String string2) {
        if (context == null || string == null || string2 == null) {
            return null;
        }
        AssetManager assetManager = context.getAssets();
        try {
            String[] stringArray = assetManager.list(string);
            if (stringArray == null) {
                return null;
            }
            for (String string3 : stringArray) {
                if (string3 == null || !string3.contains(string2)) continue;
                return FileUtil.readFileContentsFromAssets(context, string + "/" + string3);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static byte[] readFileContentsFromAssets(Context context, String string) {
        byte[] byArray;
        int n2;
        InputStream inputStream;
        block8: {
            AssetManager assetManager = context.getAssets();
            inputStream = null;
            String string2 = string;
            inputStream = assetManager.open(string2);
            n2 = inputStream.available();
            if (n2 != 0) break block8;
            byte[] byArray2 = null;
            FileUtil.safelyCloseFile(inputStream);
            return byArray2;
        }
        try {
            byte[] byArray3 = new byte[n2];
            for (int i2 = 0; i2 < n2; i2 += inputStream.read(byArray3, i2, n2 - i2)) {
            }
            byArray = byArray3;
        }
        catch (IOException iOException) {
            ez.b(ey.f, "read file from assets failed " + iOException.getMessage());
            byte[] byArray4 = null;
            FileUtil.safelyCloseFile(inputStream);
            return byArray4;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            ez.b(ey.f, "read file from assets failed " + outOfMemoryError.getMessage());
            byte[] byArray5 = null;
            {
                catch (Throwable throwable) {
                    FileUtil.safelyCloseFile(inputStream);
                    throw throwable;
                }
            }
            FileUtil.safelyCloseFile(inputStream);
            return byArray5;
        }
        FileUtil.safelyCloseFile(inputStream);
        return byArray;
    }

    public static String getName(String string) {
        if (string == null) {
            return null;
        }
        int n2 = FileUtil.indexOfLastSeparator(string);
        return string.substring(n2 + 1);
    }

    public static int indexOfLastSeparator(String string) {
        if (string == null) {
            return -1;
        }
        int n2 = string.lastIndexOf(47);
        int n3 = string.lastIndexOf(92);
        return Math.max(n2, n3);
    }

    public static boolean isSafeEntryName(String string) {
        return !string.contains(FILE_PATH_ENTRY_BACK) && !string.contains(FILE_PATH_ENTRY_SEPARATOR1) && !string.contains(FILE_PATH_ENTRY_SEPARATOR2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] compress(String string, String string2) {
        if (string == null || string.length() == 0) {
            return null;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        GZIPOutputStream gZIPOutputStream = null;
        try {
            gZIPOutputStream = new GZIPOutputStream(byteArrayOutputStream);
            gZIPOutputStream.write(string.getBytes(string2));
            gZIPOutputStream.close();
        }
        catch (IOException iOException) {
            try {
                Log.e("gzip compress error.", iOException.getMessage());
            }
            catch (Throwable throwable) {
                FileUtil.safelyCloseFile(gZIPOutputStream);
                throw throwable;
            }
            FileUtil.safelyCloseFile(gZIPOutputStream);
        }
        FileUtil.safelyCloseFile(gZIPOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] compress(byte[] byArray) {
        if (byArray == null || byArray.length == 0) {
            return null;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        GZIPOutputStream gZIPOutputStream = null;
        try {
            gZIPOutputStream = new GZIPOutputStream(byteArrayOutputStream);
            gZIPOutputStream.write(byArray);
            gZIPOutputStream.close();
        }
        catch (IOException iOException) {
            try {
                Log.e("gzip compress error.", iOException.getMessage());
            }
            catch (Throwable throwable) {
                FileUtil.safelyCloseFile(gZIPOutputStream);
                throw throwable;
            }
            FileUtil.safelyCloseFile(gZIPOutputStream);
        }
        FileUtil.safelyCloseFile(gZIPOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static String uncompressToString(byte[] byArray) {
        return FileUtil.uncompressToString(byArray, "UTF-8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String uncompressToString(byte[] byArray, String string) {
        if (byArray == null || byArray.length == 0) {
            return null;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        InputStream inputStream = null;
        try {
            inputStream = FileUtil.getZipInputStream(byArray);
            if (inputStream != null) {
                int n2;
                byte[] byArray2 = new byte[256];
                while ((n2 = inputStream.read(byArray2)) >= 0) {
                    byteArrayOutputStream.write(byArray2, 0, n2);
                }
                String string2 = byteArrayOutputStream.toString(string);
                return string2;
            }
        }
        catch (IOException iOException) {
            Log.e("gzip compress error.", iOException.getMessage());
        }
        finally {
            FileUtil.safelyCloseFile(inputStream);
        }
        return null;
    }

    private static InputStream getZipInputStream(byte[] byArray) throws IOException {
        if (byArray == null || byArray.length == 0) {
            return null;
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        if (FileUtil.isGzip(byArray)) {
            return new GZIPInputStream(byteArrayInputStream);
        }
        return new ZipInputStream(byteArrayInputStream);
    }

    private static void safelyCloseFile(InputStream inputStream) {
        try {
            if (inputStream != null) {
                if (inputStream instanceof ZipInputStream) {
                    ((ZipInputStream)inputStream).closeEntry();
                }
                inputStream.close();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void safelyCloseFile(OutputStream outputStream) {
        try {
            if (outputStream != null) {
                outputStream.close();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static byte[] readByteByStream(InputStream inputStream) throws IOException {
        if (inputStream == null) {
            return null;
        }
        byte[] byArray = new byte[1024];
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            int n2 = 0;
            while ((n2 = inputStream.read(byArray)) != -1) {
                byteArrayOutputStream.write(byArray, 0, n2);
            }
            byte[] byArray2 = byteArrayOutputStream.toByteArray();
            return byArray2;
        }
        catch (IOException iOException) {
            throw iOException;
        }
        finally {
            FileUtil.safelyCloseFile(byteArrayOutputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, byte[]> uncompressToByteWithKeys(byte[] byArray, String[] stringArray) {
        HashMap<String, byte[]> hashMap;
        block16: {
            hashMap = new HashMap<String, byte[]>();
            if (byArray == null || byArray.length == 0) {
                return hashMap;
            }
            InputStream inputStream = null;
            try {
                ZipEntry zipEntry;
                inputStream = FileUtil.getZipInputStream(byArray);
                if (!(inputStream instanceof ZipInputStream)) break block16;
                ZipInputStream zipInputStream = (ZipInputStream)inputStream;
                while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                    block18: {
                        if (!zipEntry.isDirectory()) {
                            String string;
                            block17: {
                                string = zipEntry.getName();
                                if (FileUtil.isSafeEntryName(string)) break block17;
                                Log.e("gzip compress error.", "gzip name contains ../ " + string);
                                Map<String, byte[]> map = null;
                                return map;
                            }
                            try {
                                if (stringArray == null) {
                                    byte[] byArray2 = FileUtil.readByteByStream(zipInputStream);
                                    if (byArray2 != null) {
                                        hashMap.put(string, byArray2);
                                    }
                                    break block18;
                                }
                                for (String string2 : stringArray) {
                                    if (!string.equals(string2)) continue;
                                    byte[] byArray3 = FileUtil.readByteByStream(zipInputStream);
                                    if (byArray3 != null) {
                                        hashMap.put(string2, byArray3);
                                    }
                                    break;
                                }
                            }
                            catch (IOException iOException) {
                                iOException.printStackTrace();
                            }
                        }
                    }
                    zipInputStream.closeEntry();
                }
            }
            catch (Throwable throwable) {
                Log.e("gzip compress error.", throwable.getMessage());
            }
            finally {
                FileUtil.safelyCloseFile(inputStream);
            }
        }
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Pair<String, byte[]> uncompressToByte(byte[] byArray) {
        if (byArray == null || byArray.length == 0) {
            return null;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        InputStream inputStream = null;
        String string = "";
        try {
            Object object;
            ZipEntry zipEntry;
            inputStream = FileUtil.getZipInputStream(byArray);
            if (inputStream instanceof ZipInputStream && !FileUtil.isSafeEntryName(string = (zipEntry = ((ZipInputStream)(object = (ZipInputStream)inputStream)).getNextEntry()).getName())) {
                Log.e("gzip compress error.", "gzip name contains ../ " + string);
                Pair<String, byte[]> pair = null;
                return pair;
            }
            if (inputStream != null) {
                int n2;
                object = new byte[256];
                while ((n2 = inputStream.read((byte[])object)) >= 0) {
                    byteArrayOutputStream.write((byte[])object, 0, n2);
                }
                Pair<String, byte[]> pair = new Pair<String, byte[]>(string, byteArrayOutputStream.toByteArray());
                return pair;
            }
        }
        catch (Throwable throwable) {
            Log.e("gzip compress error.", throwable.getMessage());
        }
        finally {
            FileUtil.safelyCloseFile(inputStream);
        }
        return null;
    }

    public static boolean isGzip(byte[] byArray) {
        int n2 = byArray[0] << 8 | byArray[1] & 0xFF;
        return n2 == 8075;
    }

    public static void decompress(InputStream inputStream, String string) throws Exception {
        FileUtil.decompress(inputStream, string, 0L, null);
    }

    private static void decompress(InputStream inputStream, String string, long l2, ZipCompressProgressListener zipCompressProgressListener) throws Exception {
        CheckedInputStream checkedInputStream = new CheckedInputStream(inputStream, new CRC32());
        ZipInputStream zipInputStream = new ZipInputStream(checkedInputStream);
        FileUtil.decompress(null, new File(string), zipInputStream, l2, zipCompressProgressListener, null);
        zipInputStream.close();
        checkedInputStream.close();
    }

    private static void decompress(File file, File file2, ZipInputStream zipInputStream, long l2, ZipCompressProgressListener zipCompressProgressListener, UnZipFileBrake unZipFileBrake) throws Exception {
        ZipEntry zipEntry = null;
        int n2 = 0;
        int n3 = 0;
        boolean bl2 = false;
        while ((zipEntry = zipInputStream.getNextEntry()) != null) {
            if (unZipFileBrake != null && unZipFileBrake.mIsAborted) {
                zipInputStream.closeEntry();
                return;
            }
            String string = zipEntry.getName();
            if (TextUtils.isEmpty(string) || !FileUtil.isSafeEntryName(string)) {
                bl2 = true;
                break;
            }
            String string2 = file2.getPath() + File.separator + string;
            File file3 = new File(string2);
            FileUtil.fileProber(file3);
            if (zipEntry.isDirectory()) {
                file3.mkdirs();
            } else {
                n3 = FileUtil.decompressFile(file3, zipInputStream, n2, l2, zipCompressProgressListener, unZipFileBrake);
                n2 += n3;
            }
            zipInputStream.closeEntry();
        }
        if (bl2) {
            try {
                if (null != file) {
                    file.delete();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static void fileProber(File file) {
        File file2 = file.getParentFile();
        if (!file2.exists()) {
            FileUtil.fileProber(file2);
            file2.mkdir();
        }
    }

    private static int decompressFile(File file, ZipInputStream zipInputStream, long l2, long l3, ZipCompressProgressListener zipCompressProgressListener, UnZipFileBrake unZipFileBrake) throws Exception {
        int n2;
        int n3 = 0;
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
        byte[] byArray = new byte[1024];
        while ((n2 = zipInputStream.read(byArray, 0, 1024)) != -1) {
            if (unZipFileBrake != null && unZipFileBrake.mIsAborted) {
                bufferedOutputStream.close();
                return n3;
            }
            bufferedOutputStream.write(byArray, 0, n2);
            n3 += n2;
            if (l3 <= 0L || zipCompressProgressListener == null) continue;
            long l4 = (l2 + (long)n3) * 100L / l3;
            if (unZipFileBrake != null && unZipFileBrake.mIsAborted) continue;
            zipCompressProgressListener.onFinishProgress(l4);
        }
        bufferedOutputStream.close();
        return n3;
    }

    public static class UnZipFileBrake {
        public boolean mIsAborted = false;
    }

    public static interface ZipCompressProgressListener {
        public void onFinishProgress(long var1);
    }
}

