/*
 * Decompiled with CFR 0.152.
 */
package com.autonavi.base.amap.mapcore.tools;

import com.amap.adapter.graphics.Bitmap;
import com.amap.adapter.graphics.Canvas;
import com.amap.adapter.graphics.Paint;
import com.amap.adapter.graphics.Typeface;
import com.amap.adapter.text.TextPaint;
import com.amap.api.mapcore.util.es;
import java.nio.ByteBuffer;

public class TextTextureGenerator {
    private int TEXT_FONTSIZE = -1;
    private int TEXT_FONTSIZE_TRUE = -1;
    static final int AN_LABEL_MAXCHARINLINE = 7;
    static final int AN_LABEL_MULITYLINE_SPAN = 2;
    private static final int ALIGNCENTER = 51;
    private static final int ALIGNLEFT = 49;
    private static final int ALIGNRIGHT = 50;
    private float base_line = 0.0f;
    private float start_x = 0.0f;
    private Paint text_paint = null;

    public static int GetNearstSize2N(int n2) {
        int n3 = 1;
        while (n2 > n3) {
            n3 *= 2;
        }
        return n3;
    }

    public TextTextureGenerator() {
        this.createTextParam();
    }

    private void createTextParam() {
        float f2;
        this.TEXT_FONTSIZE_TRUE = this.TEXT_FONTSIZE - 2;
        this.text_paint = TextTextureGenerator.newPaint(null, this.TEXT_FONTSIZE_TRUE, 49);
        this.start_x = f2 = (float)(this.TEXT_FONTSIZE - this.TEXT_FONTSIZE_TRUE) / 2.0f;
        float f3 = 7.3242188f;
        float f4 = -27.832031f;
        float f5 = -31.68457f;
        float f6 = 8.129883f;
        float f7 = 0.0f;
        try {
            Paint.FontMetrics fontMetrics = this.text_paint.getFontMetrics();
            f3 = fontMetrics.descent;
            f4 = fontMetrics.ascent;
            f5 = fontMetrics.top;
            f6 = fontMetrics.bottom;
            f7 = fontMetrics.leading;
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.base_line = ((float)this.TEXT_FONTSIZE_TRUE - (f3 + f4)) / 2.0f + f2 + 0.5f;
    }

    public byte[] getTextPixelBuffer(int n2, int n3) {
        if (this.TEXT_FONTSIZE != n3) {
            this.TEXT_FONTSIZE = n3;
            this.createTextParam();
        }
        try {
            char[] cArray = new char[]{(char)n2};
            float f2 = this.base_line;
            Bitmap bitmap = Bitmap.createBitmap(this.TEXT_FONTSIZE, this.TEXT_FONTSIZE, Bitmap.Config.ALPHA_8);
            Canvas canvas = new Canvas(bitmap);
            byte[] byArray = new byte[this.TEXT_FONTSIZE * this.TEXT_FONTSIZE];
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
            float f3 = this.text_paint.measureText(String.valueOf((char)n2));
            if (cArray[0] > '\u0000' && cArray[0] < '\u0100') {
                f2 -= 1.5f;
            }
            Paint.Align align = this.text_paint.getTextAlign();
            float f4 = this.text_paint.getTextSize();
            float f5 = f3 - (float)this.TEXT_FONTSIZE_TRUE;
            if (align != Paint.Align.CENTER && f5 >= 4.0f) {
                this.text_paint.setTextAlign(Paint.Align.CENTER);
                this.text_paint.setTextSize((float)this.TEXT_FONTSIZE_TRUE - f5);
                canvas.drawText(cArray, 0, 1, ((float)this.TEXT_FONTSIZE_TRUE - f5) / 2.0f, f2, this.text_paint);
                this.text_paint.setTextAlign(align);
                this.text_paint.setTextSize(f4);
            } else {
                canvas.drawText(cArray, 0, 1, this.start_x, f2, this.text_paint);
            }
            bitmap.copyPixelsToBuffer(byteBuffer);
            es.b(bitmap);
            bitmap = null;
            byteBuffer = null;
            return byArray;
        }
        catch (OutOfMemoryError outOfMemoryError) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public byte[] getCharsWidths(int[] nArray) {
        int n2 = nArray.length;
        byte[] byArray = new byte[n2];
        float[] fArray = new float[1];
        for (int i2 = 0; i2 < n2; ++i2) {
            fArray[0] = this.text_paint.measureText((char)nArray[i2] + "");
            byArray[i2] = (byte)(fArray[0] + (float)(this.TEXT_FONTSIZE - this.TEXT_FONTSIZE_TRUE));
        }
        return byArray;
    }

    private static Paint newPaint(String string, int n2, int n3) {
        TextPaint textPaint = new TextPaint();
        textPaint.setColor(-1);
        textPaint.setTextSize(n2);
        textPaint.setAntiAlias(true);
        textPaint.setFilterBitmap(true);
        textPaint.setTypeface(Typeface.DEFAULT_BOLD);
        switch (n3) {
            case 51: {
                textPaint.setTextAlign(Paint.Align.CENTER);
                break;
            }
            case 49: {
                textPaint.setTextAlign(Paint.Align.LEFT);
                break;
            }
            case 50: {
                textPaint.setTextAlign(Paint.Align.RIGHT);
                break;
            }
            default: {
                textPaint.setTextAlign(Paint.Align.LEFT);
            }
        }
        return textPaint;
    }

    public static float getFontlength(Paint paint, String string) {
        return paint.measureText(string);
    }

    public static float getFontHeight(Paint paint) {
        Paint.FontMetrics fontMetrics = paint.getFontMetrics();
        return fontMetrics.descent - fontMetrics.ascent;
    }
}

