/*
 * Decompiled with CFR 0.152.
 */
package com.amap.adapter.json;

import com.amap.adapter.json.JSONArray;
import com.amap.adapter.json.JSONException;
import com.amap.adapter.json.JSONStringer;
import com.amap.adapter.json.JSONTokener;
import com.amap.adapter.json.a;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class JSONObject {
    private static final Double NEGATIVE_ZERO = -0.0;
    public static final Object NULL = new Object(){

        public boolean equals(Object object) {
            return object == this || object == null;
        }

        public String toString() {
            return "null";
        }
    };
    private final LinkedHashMap<String, Object> nameValuePairs;

    public JSONObject() {
        this.nameValuePairs = new LinkedHashMap();
    }

    public JSONObject(Map map) {
        this();
        Map map2 = map;
        for (Map.Entry entry : map2.entrySet()) {
            String string = (String)entry.getKey();
            if (string == null) {
                throw new NullPointerException("key == null");
            }
            this.nameValuePairs.put(string, JSONObject.wrap(entry.getValue()));
        }
    }

    public JSONObject(JSONTokener jSONTokener) throws JSONException {
        Object object = jSONTokener.nextValue();
        if (!(object instanceof JSONObject)) {
            throw a.a(object, "JSONObject");
        }
        this.nameValuePairs = ((JSONObject)object).nameValuePairs;
    }

    public JSONObject(String string) throws JSONException {
        this(new JSONTokener(string));
    }

    public JSONObject(JSONObject jSONObject, String[] stringArray) throws JSONException {
        this();
        for (String string : stringArray) {
            Object object = jSONObject.opt(string);
            if (object == null) continue;
            this.nameValuePairs.put(string, object);
        }
    }

    public int length() {
        return this.nameValuePairs.size();
    }

    public JSONObject put(String string, boolean bl2) throws JSONException {
        this.nameValuePairs.put(this.checkName(string), bl2);
        return this;
    }

    public JSONObject put(String string, double d2) throws JSONException {
        this.nameValuePairs.put(this.checkName(string), a.a(d2));
        return this;
    }

    public JSONObject put(String string, int n2) throws JSONException {
        this.nameValuePairs.put(this.checkName(string), n2);
        return this;
    }

    public JSONObject put(String string, long l2) throws JSONException {
        this.nameValuePairs.put(this.checkName(string), l2);
        return this;
    }

    public JSONObject put(String string, Object object) throws JSONException {
        if (object == null) {
            this.nameValuePairs.remove(string);
            return this;
        }
        if (object instanceof Number) {
            a.a(((Number)object).doubleValue());
        }
        this.nameValuePairs.put(this.checkName(string), object);
        return this;
    }

    public JSONObject putOpt(String string, Object object) throws JSONException {
        if (string == null || object == null) {
            return this;
        }
        return this.put(string, object);
    }

    public JSONObject accumulate(String string, Object object) throws JSONException {
        Object object2 = this.nameValuePairs.get(this.checkName(string));
        if (object2 == null) {
            return this.put(string, object);
        }
        if (object2 instanceof JSONArray) {
            JSONArray jSONArray = (JSONArray)object2;
            jSONArray.checkedPut(object);
        } else {
            JSONArray jSONArray = new JSONArray();
            jSONArray.checkedPut(object2);
            jSONArray.checkedPut(object);
            this.nameValuePairs.put(string, jSONArray);
        }
        return this;
    }

    public JSONObject append(String string, Object object) throws JSONException {
        JSONArray jSONArray;
        Object object2 = this.nameValuePairs.get(this.checkName(string));
        if (object2 instanceof JSONArray) {
            jSONArray = (JSONArray)object2;
        } else if (object2 == null) {
            JSONArray jSONArray2 = new JSONArray();
            this.nameValuePairs.put(string, jSONArray2);
            jSONArray = jSONArray2;
        } else {
            throw new JSONException("Key " + string + " is not a JSONArray");
        }
        jSONArray.checkedPut(object);
        return this;
    }

    String checkName(String string) throws JSONException {
        if (string == null) {
            throw new JSONException("Names must be non-null");
        }
        return string;
    }

    public Object remove(String string) {
        return this.nameValuePairs.remove(string);
    }

    public boolean isNull(String string) {
        Object object = this.nameValuePairs.get(string);
        return object == null || object == NULL;
    }

    public boolean has(String string) {
        return this.nameValuePairs.containsKey(string);
    }

    public Object get(String string) throws JSONException {
        Object object = this.nameValuePairs.get(string);
        if (object == null) {
            throw new JSONException("No value for " + string);
        }
        return object;
    }

    public Object opt(String string) {
        return this.nameValuePairs.get(string);
    }

    public boolean getBoolean(String string) throws JSONException {
        Object object = this.get(string);
        Boolean bl2 = a.a(object);
        if (bl2 == null) {
            throw a.a(string, object, "boolean");
        }
        return bl2;
    }

    public boolean optBoolean(String string) {
        return this.optBoolean(string, false);
    }

    public boolean optBoolean(String string, boolean bl2) {
        Object object = this.opt(string);
        Boolean bl3 = a.a(object);
        return bl3 != null ? bl3 : bl2;
    }

    public double getDouble(String string) throws JSONException {
        Object object = this.get(string);
        Double d2 = a.b(object);
        if (d2 == null) {
            throw a.a(string, object, "double");
        }
        return d2;
    }

    public double optDouble(String string) {
        return this.optDouble(string, Double.NaN);
    }

    public double optDouble(String string, double d2) {
        Object object = this.opt(string);
        Double d3 = a.b(object);
        return d3 != null ? d3 : d2;
    }

    public int getInt(String string) throws JSONException {
        Object object = this.get(string);
        Integer n2 = a.c(object);
        if (n2 == null) {
            throw a.a(string, object, "int");
        }
        return n2;
    }

    public int optInt(String string) {
        return this.optInt(string, 0);
    }

    public int optInt(String string, int n2) {
        Object object = this.opt(string);
        Integer n3 = a.c(object);
        return n3 != null ? n3 : n2;
    }

    public long getLong(String string) throws JSONException {
        Object object = this.get(string);
        Long l2 = a.d(object);
        if (l2 == null) {
            throw a.a(string, object, "long");
        }
        return l2;
    }

    public long optLong(String string) {
        return this.optLong(string, 0L);
    }

    public long optLong(String string, long l2) {
        Object object = this.opt(string);
        Long l3 = a.d(object);
        return l3 != null ? l3 : l2;
    }

    public String getString(String string) throws JSONException {
        Object object = this.get(string);
        String string2 = a.e(object);
        if (string2 == null) {
            throw a.a(string, object, "String");
        }
        return string2;
    }

    public String optString(String string) {
        return this.optString(string, "");
    }

    public String optString(String string, String string2) {
        Object object = this.opt(string);
        String string3 = a.e(object);
        return string3 != null ? string3 : string2;
    }

    public JSONArray getJSONArray(String string) throws JSONException {
        Object object = this.get(string);
        if (object instanceof JSONArray) {
            return (JSONArray)object;
        }
        throw a.a(string, object, "JSONArray");
    }

    public JSONArray optJSONArray(String string) {
        Object object = this.opt(string);
        return object instanceof JSONArray ? (JSONArray)object : null;
    }

    public JSONObject getJSONObject(String string) throws JSONException {
        Object object = this.get(string);
        if (object instanceof JSONObject) {
            return (JSONObject)object;
        }
        throw a.a(string, object, "JSONObject");
    }

    public JSONObject optJSONObject(String string) {
        Object object = this.opt(string);
        return object instanceof JSONObject ? (JSONObject)object : null;
    }

    public JSONArray toJSONArray(JSONArray jSONArray) throws JSONException {
        JSONArray jSONArray2 = new JSONArray();
        if (jSONArray == null) {
            return null;
        }
        int n2 = jSONArray.length();
        if (n2 == 0) {
            return null;
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            String string = a.e(jSONArray.opt(i2));
            jSONArray2.put(this.opt(string));
        }
        return jSONArray2;
    }

    public Iterator<String> keys() {
        return this.nameValuePairs.keySet().iterator();
    }

    public Set<String> keySet() {
        return this.nameValuePairs.keySet();
    }

    public JSONArray names() {
        return this.nameValuePairs.isEmpty() ? null : new JSONArray(new ArrayList<String>(this.nameValuePairs.keySet()));
    }

    public String toString() {
        try {
            JSONStringer jSONStringer = new JSONStringer();
            this.writeTo(jSONStringer);
            return jSONStringer.toString();
        }
        catch (JSONException jSONException) {
            return null;
        }
    }

    public String toString(int n2) throws JSONException {
        JSONStringer jSONStringer = new JSONStringer(n2);
        this.writeTo(jSONStringer);
        return jSONStringer.toString();
    }

    void writeTo(JSONStringer jSONStringer) throws JSONException {
        jSONStringer.object();
        for (Map.Entry<String, Object> entry : this.nameValuePairs.entrySet()) {
            jSONStringer.key(entry.getKey()).value(entry.getValue());
        }
        jSONStringer.endObject();
    }

    public static String numberToString(Number number) throws JSONException {
        if (number == null) {
            throw new JSONException("Number must be non-null");
        }
        double d2 = number.doubleValue();
        a.a(d2);
        if (number.equals(NEGATIVE_ZERO)) {
            return "-0";
        }
        long l2 = number.longValue();
        if (d2 == (double)l2) {
            return Long.toString(l2);
        }
        return number.toString();
    }

    public static String quote(String string) {
        if (string == null) {
            return "\"\"";
        }
        try {
            JSONStringer jSONStringer = new JSONStringer();
            jSONStringer.open(JSONStringer.a.f, "");
            jSONStringer.value(string);
            jSONStringer.close(JSONStringer.a.f, JSONStringer.a.f, "");
            return jSONStringer.toString();
        }
        catch (JSONException jSONException) {
            throw new AssertionError();
        }
    }

    public static Object wrap(Object object) {
        if (object == null) {
            return NULL;
        }
        if (object instanceof JSONArray || object instanceof JSONObject) {
            return object;
        }
        if (object.equals(NULL)) {
            return object;
        }
        try {
            if (object instanceof Collection) {
                return new JSONArray((Collection)object);
            }
            if (object.getClass().isArray()) {
                return new JSONArray(object);
            }
            if (object instanceof Map) {
                return new JSONObject((Map)object);
            }
            if (object instanceof Boolean || object instanceof Byte || object instanceof Character || object instanceof Double || object instanceof Float || object instanceof Integer || object instanceof Long || object instanceof Short || object instanceof String) {
                return object;
            }
            if (object.getClass().getPackage().getName().startsWith("java.")) {
                return object.toString();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }
}

