/*
 * Decompiled with CFR 0.152.
 */
package com.amap.adapter.view;

import com.amap.adapter.content.Context;
import com.amap.adapter.os.Handler;
import com.amap.adapter.os.Message;
import com.amap.adapter.view.MotionEvent;
import com.amap.adapter.view.VelocityTracker;
import com.amap.adapter.view.ViewConfiguration;

public class GestureDetector {
    private int mTouchSlopSquare;
    private int mDoubleTapTouchSlopSquare;
    private int mDoubleTapSlopSquare;
    private int mMinimumFlingVelocity;
    private int mMaximumFlingVelocity;
    private static final int LONGPRESS_TIMEOUT = ViewConfiguration.getLongPressTimeout();
    private static final int TAP_TIMEOUT = ViewConfiguration.getTapTimeout();
    private static final int DOUBLE_TAP_TIMEOUT = ViewConfiguration.getDoubleTapTimeout();
    private static final int DOUBLE_TAP_MIN_TIME = ViewConfiguration.getDoubleTapMinTime();
    private static final int SHOW_PRESS = 1;
    private static final int LONG_PRESS = 2;
    private static final int TAP = 3;
    private final Handler mHandler;
    private final OnGestureListener mListener;
    private OnDoubleTapListener mDoubleTapListener;
    private OnContextClickListener mContextClickListener;
    private boolean mStillDown;
    private boolean mDeferConfirmSingleTap;
    private boolean mInLongPress;
    private boolean mInContextClick;
    private boolean mAlwaysInTapRegion;
    private boolean mAlwaysInBiggerTapRegion;
    private boolean mIgnoreNextUpEvent;
    private MotionEvent mCurrentDownEvent;
    private MotionEvent mPreviousUpEvent;
    private boolean mIsDoubleTapping;
    private float mLastFocusX;
    private float mLastFocusY;
    private float mDownFocusX;
    private float mDownFocusY;
    private boolean mIsLongpressEnabled;
    private VelocityTracker mVelocityTracker;

    @Deprecated
    public GestureDetector(OnGestureListener onGestureListener, Handler handler) {
        this(null, onGestureListener, handler);
    }

    @Deprecated
    public GestureDetector(OnGestureListener onGestureListener) {
        this(null, onGestureListener, null);
    }

    public GestureDetector(Context context, OnGestureListener onGestureListener) {
        this(context, onGestureListener, null);
    }

    public GestureDetector(Context context, OnGestureListener onGestureListener, Handler handler) {
        this.mHandler = handler != null ? new a(handler) : new a();
        this.mListener = onGestureListener;
        if (onGestureListener instanceof OnDoubleTapListener) {
            this.setOnDoubleTapListener((OnDoubleTapListener)((Object)onGestureListener));
        }
        if (onGestureListener instanceof OnContextClickListener) {
            this.setContextClickListener((OnContextClickListener)((Object)onGestureListener));
        }
        this.init(context);
    }

    public GestureDetector(Context context, OnGestureListener onGestureListener, Handler handler, boolean bl2) {
        this(context, onGestureListener, handler);
    }

    private void init(Context context) {
        if (this.mListener == null) {
            throw new NullPointerException("OnGestureListener must not be null");
        }
        this.mIsLongpressEnabled = true;
        ViewConfiguration viewConfiguration = ViewConfiguration.get(context);
        int n2 = viewConfiguration.getScaledTouchSlop();
        int n3 = viewConfiguration.getScaledDoubleTapTouchSlop();
        int n4 = viewConfiguration.getScaledDoubleTapSlop();
        this.mMinimumFlingVelocity = viewConfiguration.getScaledMinimumFlingVelocity();
        this.mMaximumFlingVelocity = viewConfiguration.getScaledMaximumFlingVelocity();
        this.mTouchSlopSquare = n2 * n2;
        this.mDoubleTapTouchSlopSquare = n3 * n3;
        this.mDoubleTapSlopSquare = n4 * n4;
    }

    public void setOnDoubleTapListener(OnDoubleTapListener onDoubleTapListener) {
        this.mDoubleTapListener = onDoubleTapListener;
    }

    public void setContextClickListener(OnContextClickListener onContextClickListener) {
        this.mContextClickListener = onContextClickListener;
    }

    public void setIsLongpressEnabled(boolean bl2) {
        this.mIsLongpressEnabled = bl2;
    }

    public boolean isLongpressEnabled() {
        return this.mIsLongpressEnabled;
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        int n2;
        int n3 = motionEvent.getAction();
        if (this.mVelocityTracker == null) {
            this.mVelocityTracker = VelocityTracker.obtain();
        }
        this.mVelocityTracker.addMovement(motionEvent);
        boolean bl2 = (n3 & 0xFF) == 5;
        int n4 = bl2 ? motionEvent.getActionIndex() : -1;
        boolean bl3 = (motionEvent.getFlags() & 1) != 0;
        float f2 = 0.0f;
        float f3 = 0.0f;
        int n5 = motionEvent.getPointerCount();
        for (n2 = 0; n2 < n5; ++n2) {
            if (n4 == n2) continue;
            f2 += motionEvent.getX(n2);
            f3 += motionEvent.getY(n2);
        }
        n2 = bl2 ? n5 - 1 : n5;
        float f4 = f2 / (float)n2;
        float f5 = f3 / (float)n2;
        boolean bl4 = false;
        block0 : switch (n3 & 0xFF) {
            case 4: {
                this.mDownFocusX = this.mLastFocusX = f4;
                this.mDownFocusY = this.mLastFocusY = f5;
                this.cancelTaps();
                break;
            }
            case 5: {
                this.mDownFocusX = this.mLastFocusX = f4;
                this.mDownFocusY = this.mLastFocusY = f5;
                this.mVelocityTracker.computeCurrentVelocity(1000, this.mMaximumFlingVelocity);
                int n6 = motionEvent.getActionIndex();
                int n7 = motionEvent.getPointerId(n6);
                float f6 = this.mVelocityTracker.getXVelocity(n7);
                float f7 = this.mVelocityTracker.getYVelocity(n7);
                for (int i2 = 0; i2 < n5; ++i2) {
                    float f8;
                    int n8;
                    float f9;
                    float f10;
                    if (i2 == n6 || !((f10 = (f9 = f6 * this.mVelocityTracker.getXVelocity(n8 = motionEvent.getPointerId(i2))) + (f8 = f7 * this.mVelocityTracker.getYVelocity(n8))) < 0.0f)) continue;
                    this.mVelocityTracker.clear();
                    break block0;
                }
                break;
            }
            case 1: {
                if (this.mDoubleTapListener != null) {
                    boolean bl5 = this.mHandler.hasMessages(3);
                    if (bl5) {
                        this.mHandler.removeMessages(3);
                    }
                    if (this.mCurrentDownEvent != null && this.mPreviousUpEvent != null && bl5 && this.isConsideredDoubleTap(this.mCurrentDownEvent, this.mPreviousUpEvent, motionEvent)) {
                        this.mIsDoubleTapping = true;
                        bl4 |= this.mDoubleTapListener.onDoubleTap(this.mCurrentDownEvent);
                        bl4 |= this.mDoubleTapListener.onDoubleTapEvent(motionEvent);
                    } else {
                        this.mHandler.sendEmptyMessageDelayed(3, DOUBLE_TAP_TIMEOUT);
                    }
                }
                this.mDownFocusX = this.mLastFocusX = f4;
                this.mDownFocusY = this.mLastFocusY = f5;
                if (this.mCurrentDownEvent != null) {
                    this.mCurrentDownEvent.recycle();
                }
                this.mCurrentDownEvent = MotionEvent.obtain(motionEvent);
                this.mAlwaysInTapRegion = true;
                this.mAlwaysInBiggerTapRegion = true;
                this.mStillDown = true;
                this.mInLongPress = false;
                this.mDeferConfirmSingleTap = false;
                if (this.mIsLongpressEnabled) {
                    this.mHandler.removeMessages(2);
                    this.mHandler.sendEmptyMessageAtTime(2, this.mCurrentDownEvent.getDownTime() + (long)LONGPRESS_TIMEOUT);
                }
                this.mHandler.sendEmptyMessageAtTime(1, this.mCurrentDownEvent.getDownTime() + (long)TAP_TIMEOUT);
                bl4 |= this.mListener.onDown(motionEvent);
                break;
            }
            case 3: {
                if (this.mInLongPress || this.mInContextClick) break;
                float f11 = this.mLastFocusX - f4;
                float f12 = this.mLastFocusY - f5;
                if (this.mIsDoubleTapping) {
                    bl4 |= this.mDoubleTapListener.onDoubleTapEvent(motionEvent);
                    break;
                }
                if (this.mAlwaysInTapRegion) {
                    int n9;
                    int n10;
                    int n11 = (int)(f4 - this.mDownFocusX);
                    int n12 = (int)(f5 - this.mDownFocusY);
                    int n13 = n11 * n11 + n12 * n12;
                    int n14 = n10 = bl3 ? 0 : this.mTouchSlopSquare;
                    if (n13 > n10) {
                        bl4 = this.mListener.onScroll(this.mCurrentDownEvent, motionEvent, f11, f12);
                        this.mLastFocusX = f4;
                        this.mLastFocusY = f5;
                        this.mAlwaysInTapRegion = false;
                        this.mHandler.removeMessages(3);
                        this.mHandler.removeMessages(1);
                        this.mHandler.removeMessages(2);
                    }
                    int n15 = n9 = bl3 ? 0 : this.mDoubleTapTouchSlopSquare;
                    if (n13 <= n9) break;
                    this.mAlwaysInBiggerTapRegion = false;
                    break;
                }
                if (!(Math.abs(f11) >= 1.0f) && !(Math.abs(f12) >= 1.0f)) break;
                bl4 = this.mListener.onScroll(this.mCurrentDownEvent, motionEvent, f11, f12);
                this.mLastFocusX = f4;
                this.mLastFocusY = f5;
                break;
            }
            case 2: {
                this.mStillDown = false;
                MotionEvent motionEvent2 = MotionEvent.obtain(motionEvent);
                if (this.mIsDoubleTapping) {
                    bl4 |= this.mDoubleTapListener.onDoubleTapEvent(motionEvent);
                } else if (this.mInLongPress) {
                    this.mHandler.removeMessages(3);
                    this.mInLongPress = false;
                } else if (this.mAlwaysInTapRegion && !this.mIgnoreNextUpEvent) {
                    bl4 = this.mListener.onSingleTapUp(motionEvent);
                    if (this.mDeferConfirmSingleTap && this.mDoubleTapListener != null) {
                        this.mDoubleTapListener.onSingleTapConfirmed(motionEvent);
                    }
                } else if (!this.mIgnoreNextUpEvent) {
                    VelocityTracker velocityTracker = this.mVelocityTracker;
                    int n16 = motionEvent.getPointerId(0);
                    velocityTracker.computeCurrentVelocity(1000, this.mMaximumFlingVelocity);
                    float f13 = velocityTracker.getYVelocity(n16);
                    float f14 = velocityTracker.getXVelocity(n16);
                    if (Math.abs(f13) > (float)this.mMinimumFlingVelocity || Math.abs(f14) > (float)this.mMinimumFlingVelocity) {
                        bl4 = this.mListener.onFling(this.mCurrentDownEvent, motionEvent, f14, f13);
                    }
                }
                if (this.mPreviousUpEvent != null) {
                    this.mPreviousUpEvent.recycle();
                }
                this.mPreviousUpEvent = motionEvent2;
                if (this.mVelocityTracker != null) {
                    this.mVelocityTracker.recycle();
                    this.mVelocityTracker = null;
                }
                this.mIsDoubleTapping = false;
                this.mDeferConfirmSingleTap = false;
                this.mIgnoreNextUpEvent = false;
                this.mHandler.removeMessages(1);
                this.mHandler.removeMessages(2);
                break;
            }
            case 6: {
                this.cancel();
            }
        }
        return bl4;
    }

    private void cancel() {
        this.mHandler.removeMessages(1);
        this.mHandler.removeMessages(2);
        this.mHandler.removeMessages(3);
        this.mVelocityTracker.recycle();
        this.mVelocityTracker = null;
        this.mIsDoubleTapping = false;
        this.mStillDown = false;
        this.mAlwaysInTapRegion = false;
        this.mAlwaysInBiggerTapRegion = false;
        this.mDeferConfirmSingleTap = false;
        this.mInLongPress = false;
        this.mInContextClick = false;
        this.mIgnoreNextUpEvent = false;
    }

    private void cancelTaps() {
        this.mHandler.removeMessages(1);
        this.mHandler.removeMessages(2);
        this.mHandler.removeMessages(3);
        this.mIsDoubleTapping = false;
        this.mAlwaysInTapRegion = false;
        this.mAlwaysInBiggerTapRegion = false;
        this.mDeferConfirmSingleTap = false;
        this.mInLongPress = false;
        this.mInContextClick = false;
        this.mIgnoreNextUpEvent = false;
    }

    private boolean isConsideredDoubleTap(MotionEvent motionEvent, MotionEvent motionEvent2, MotionEvent motionEvent3) {
        int n2;
        if (!this.mAlwaysInBiggerTapRegion) {
            return false;
        }
        if (motionEvent3.getEventTime() - motionEvent2.getEventTime() > (long)DOUBLE_TAP_TIMEOUT) {
            return false;
        }
        int n3 = (int)motionEvent.getX() - (int)motionEvent3.getX();
        return n3 * n3 + (n2 = (int)motionEvent.getY() - (int)motionEvent3.getY()) * n2 < this.mDoubleTapSlopSquare;
    }

    private void dispatchLongPress() {
        this.mHandler.removeMessages(3);
        this.mDeferConfirmSingleTap = false;
        this.mInLongPress = true;
        this.mListener.onLongPress(this.mCurrentDownEvent);
    }

    private class a
    extends Handler {
        a() {
        }

        a(Handler handler) {
            super(handler.getLooper());
        }

        @Override
        public void handleMessage(Message message) {
            switch (message.what) {
                case 1: {
                    GestureDetector.this.mListener.onShowPress(GestureDetector.this.mCurrentDownEvent);
                    break;
                }
                case 2: {
                    GestureDetector.this.dispatchLongPress();
                    break;
                }
                case 3: {
                    if (GestureDetector.this.mDoubleTapListener == null) break;
                    if (!GestureDetector.this.mStillDown) {
                        GestureDetector.this.mDoubleTapListener.onSingleTapConfirmed(GestureDetector.this.mCurrentDownEvent);
                        break;
                    }
                    GestureDetector.this.mDeferConfirmSingleTap = true;
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown message " + message);
                }
            }
        }
    }

    public static class SimpleOnGestureListener
    implements OnContextClickListener,
    OnDoubleTapListener,
    OnGestureListener {
        @Override
        public boolean onSingleTapUp(MotionEvent motionEvent) {
            return false;
        }

        @Override
        public void onLongPress(MotionEvent motionEvent) {
        }

        @Override
        public boolean onScroll(MotionEvent motionEvent, MotionEvent motionEvent2, float f2, float f3) {
            return false;
        }

        @Override
        public boolean onFling(MotionEvent motionEvent, MotionEvent motionEvent2, float f2, float f3) {
            return false;
        }

        @Override
        public void onShowPress(MotionEvent motionEvent) {
        }

        @Override
        public boolean onDown(MotionEvent motionEvent) {
            return false;
        }

        @Override
        public boolean onDoubleTap(MotionEvent motionEvent) {
            return false;
        }

        @Override
        public boolean onDoubleTapEvent(MotionEvent motionEvent) {
            return false;
        }

        @Override
        public boolean onSingleTapConfirmed(MotionEvent motionEvent) {
            return false;
        }

        @Override
        public boolean onContextClick(MotionEvent motionEvent) {
            return false;
        }
    }

    public static interface OnContextClickListener {
        public boolean onContextClick(MotionEvent var1);
    }

    public static interface OnDoubleTapListener {
        public boolean onSingleTapConfirmed(MotionEvent var1);

        public boolean onDoubleTap(MotionEvent var1);

        public boolean onDoubleTapEvent(MotionEvent var1);
    }

    public static interface OnGestureListener {
        public boolean onDown(MotionEvent var1);

        public void onShowPress(MotionEvent var1);

        public boolean onSingleTapUp(MotionEvent var1);

        public boolean onScroll(MotionEvent var1, MotionEvent var2, float var3, float var4);

        public void onLongPress(MotionEvent var1);

        public boolean onFling(MotionEvent var1, MotionEvent var2, float var3, float var4);
    }
}

