/*
 * Decompiled with CFR 0.152.
 */
package com.amap.api.maps.model;

import com.amap.adapter.os.Parcel;
import com.amap.adapter.os.Parcelable;
import com.amap.api.maps.model.BaseOptions;
import com.amap.api.maps.model.BitmapDescriptor;
import com.amap.api.maps.model.LatLng;
import com.amap.api.maps.model.PolylineOptionsCreator;
import com.autonavi.base.amap.mapcore.jbinding.JBindingExclude;
import com.autonavi.base.amap.mapcore.jbinding.JBindingInclude;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@JBindingInclude
public final class PolylineOptions
extends BaseOptions
implements Parcelable {
    @JBindingExclude
    public static final PolylineOptionsCreator CREATOR = new PolylineOptionsCreator();
    @JBindingExclude
    public static final int DOTTEDLINE_TYPE_SQUARE = 0;
    @JBindingExclude
    public static final int DOTTEDLINE_TYPE_CIRCLE = 1;
    private final List<LatLng> points;
    private float width = 10.0f;
    private int color = -16777216;
    private float zIndex = 0.0f;
    private boolean isVisible = true;
    @JBindingExclude
    String a;
    private BitmapDescriptor customTexture;
    private List<BitmapDescriptor> customTextureList;
    @JBindingExclude
    private List<Integer> colorValues;
    @JBindingExclude
    private List<Integer> customIndexs;
    private boolean isUseTexture = true;
    private boolean isGeodesic = false;
    private boolean isDottedLine = false;
    private boolean isGradient = false;
    private float transparency = 1.0f;
    private boolean isAboveMaskLayer = false;
    private int dottedLineType = 0;
    @JBindingExclude
    private LineCapType lineCapType = LineCapType.LineCapRound;
    @JBindingExclude
    private LineJoinType lineJoinType = LineJoinType.LineJoinBevel;
    private int nLineCapType = 3;
    private int nLineJoinType = 0;
    private float shownRatio = -1.0f;
    private float shownRangeBegin = -1.0f;
    private float shownRangeEnd = -1.0f;
    private BitmapDescriptor footPrintTexture;
    private float footPrintGap = 0.0f;
    private boolean eraseVisible = false;
    private int eraseColor = -7829368;
    private BitmapDescriptor eraseTexture;
    private int[] jniColorValues;
    private int[] jniCustomIndexes;
    private float shownPolylineRangeBegin = 0.0f;
    private float shownPolylineRangeEnd = 0.0f;
    private boolean showPolylineRangeEnable = false;
    private PolylineUpdateFlags updateFlags = new PolylineUpdateFlags();

    public PolylineOptions() {
        this.points = new ArrayList<LatLng>();
        this.type = "PolylineOptions";
    }

    public PolylineOptions setUseTexture(boolean bl2) {
        this.isUseTexture = bl2;
        return this;
    }

    public PolylineOptions setCustomTexture(BitmapDescriptor bitmapDescriptor) {
        this.customTexture = bitmapDescriptor;
        return this;
    }

    public BitmapDescriptor getCustomTexture() {
        return this.customTexture;
    }

    public PolylineOptions setCustomTextureList(List<BitmapDescriptor> list) {
        this.customTextureList = list;
        this.updateFlags.isCustomTextureListUpdated = true;
        this.updateFlags.isCustomIndexesUpdated = true;
        return this;
    }

    public List<BitmapDescriptor> getCustomTextureList() {
        return this.customTextureList;
    }

    public PolylineOptions setCustomTextureIndex(List<Integer> list) {
        try {
            this.customIndexs = list;
            this.jniCustomIndexes = new int[list.size()];
            for (int i2 = 0; i2 < this.jniCustomIndexes.length; ++i2) {
                this.jniCustomIndexes[i2] = list.get(i2);
            }
            this.updateFlags.isCustomIndexesUpdated = true;
            this.updateFlags.isCustomTextureListUpdated = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return this;
    }

    public List<Integer> getCustomTextureIndex() {
        return this.customIndexs;
    }

    public PolylineOptions colorValues(List<Integer> list) {
        try {
            this.colorValues = list;
            this.jniColorValues = new int[list.size()];
            for (int i2 = 0; i2 < this.jniColorValues.length; ++i2) {
                this.jniColorValues[i2] = list.get(i2);
            }
            this.updateFlags.isColorValuesUpdated = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return this;
    }

    public List<Integer> getColorValues() {
        return this.colorValues;
    }

    public PolylineOptions useGradient(boolean bl2) {
        this.isGradient = bl2;
        return this;
    }

    public boolean isUseGradient() {
        return this.isGradient;
    }

    public boolean isUseTexture() {
        return this.isUseTexture;
    }

    public boolean isGeodesic() {
        return this.isGeodesic;
    }

    public PolylineOptions add(LatLng latLng) {
        if (latLng != null) {
            try {
                this.points.add(latLng);
                this.updateFlags.isPointsUpdated = true;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
        return this;
    }

    public PolylineOptions add(LatLng ... latLngArray) {
        if (latLngArray != null) {
            try {
                this.points.addAll(Arrays.asList(latLngArray));
                this.updateFlags.isPointsUpdated = true;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
        return this;
    }

    public PolylineOptions addAll(Iterable<LatLng> iterable) {
        if (iterable != null) {
            try {
                for (LatLng latLng : iterable) {
                    this.points.add(latLng);
                }
                this.updateFlags.isPointsUpdated = true;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
        return this;
    }

    public PolylineOptions width(float f2) {
        this.width = f2;
        return this;
    }

    public PolylineOptions color(int n2) {
        this.color = n2;
        return this;
    }

    public PolylineOptions zIndex(float f2) {
        if (this.zIndex != f2) {
            this.updateFlags.zIndexUpdate = true;
        }
        this.zIndex = f2;
        return this;
    }

    public PolylineOptions visible(boolean bl2) {
        this.isVisible = bl2;
        return this;
    }

    public PolylineOptions geodesic(boolean bl2) {
        this.isGeodesic = bl2;
        return this;
    }

    public PolylineOptions setDottedLine(boolean bl2) {
        this.isDottedLine = bl2;
        return this;
    }

    public boolean isDottedLine() {
        return this.isDottedLine;
    }

    public PolylineOptions setDottedLineType(int n2) {
        this.dottedLineType = n2 == 0 ? 0 : 1;
        return this;
    }

    public PolylineOptions lineCapType(LineCapType lineCapType) {
        if (lineCapType != null) {
            this.lineCapType = lineCapType;
            this.nLineCapType = lineCapType.getTypeValue();
        }
        return this;
    }

    public PolylineOptions lineJoinType(LineJoinType lineJoinType) {
        if (lineJoinType != null) {
            this.lineJoinType = lineJoinType;
            this.nLineJoinType = lineJoinType.getTypeValue();
        }
        return this;
    }

    public LineCapType getLineCapType() {
        return this.lineCapType;
    }

    public LineJoinType getLineJoinType() {
        return this.lineJoinType;
    }

    public int getDottedLineType() {
        return this.dottedLineType;
    }

    public List<LatLng> getPoints() {
        return this.points;
    }

    public float getWidth() {
        return this.width;
    }

    public int getColor() {
        return this.color;
    }

    public float getZIndex() {
        return this.zIndex;
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel parcel, int n2) {
        parcel.writeTypedList(this.points);
        parcel.writeFloat(this.width);
        parcel.writeInt(this.color);
        parcel.writeInt(this.dottedLineType);
        parcel.writeFloat(this.zIndex);
        parcel.writeFloat(this.transparency);
        parcel.writeString(this.a);
        parcel.writeInt(this.lineCapType.getTypeValue());
        parcel.writeInt(this.lineJoinType.getTypeValue());
        parcel.writeBooleanArray(new boolean[]{this.isVisible, this.isDottedLine, this.isGeodesic, this.isGradient, this.isAboveMaskLayer});
        if (this.customTexture != null) {
            parcel.writeParcelable(this.customTexture, n2);
        }
        if (this.customTextureList != null) {
            parcel.writeList(this.customTextureList);
        }
        if (this.customIndexs != null) {
            parcel.writeList(this.customIndexs);
        }
        if (this.colorValues != null) {
            parcel.writeList(this.colorValues);
        }
        parcel.writeFloat(this.shownRatio);
    }

    public PolylineOptions transparency(float f2) {
        this.transparency = f2;
        return this;
    }

    public float getTransparency() {
        return this.transparency;
    }

    public PolylineOptions aboveMaskLayer(boolean bl2) {
        this.isAboveMaskLayer = bl2;
        return this;
    }

    public boolean isAboveMaskLayer() {
        return this.isAboveMaskLayer;
    }

    public void setPoints(List<LatLng> list) {
        if (list != null && this.points != list) {
            try {
                this.points.clear();
                this.points.addAll(list);
                this.updateFlags.isPointsUpdated = true;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    public float getShownRatio() {
        return this.shownRatio;
    }

    public PolylineOptions setShownRatio(float f2) {
        this.shownRatio = f2;
        this.setPolylineShowRange(0.0f, f2);
        this.showPolylineRangeEnabled(true);
        return this;
    }

    public PolylineOptions setShownRange(float f2, float f3) {
        this.shownRangeBegin = f2;
        this.shownRangeEnd = f3;
        this.showPolylineRangeEnabled(true);
        this.setPolylineShowRange(f2, f3);
        return this;
    }

    public float getShownRangeBegin() {
        return this.shownRangeBegin;
    }

    public float getShownRangeEnd() {
        return this.shownRangeEnd;
    }

    public PolylineOptions showPolylineRangeEnabled(boolean bl2) {
        this.showPolylineRangeEnable = bl2;
        return this;
    }

    public boolean isShowPolylineRangeEnable() {
        return this.showPolylineRangeEnable;
    }

    public PolylineOptions setPolylineShowRange(float f2, float f3) {
        this.shownPolylineRangeBegin = f2;
        this.shownPolylineRangeEnd = f3;
        return this;
    }

    public float getPolylineShownRangeBegin() {
        return this.shownPolylineRangeBegin;
    }

    public float getPolylineShownRangeEnd() {
        return this.shownPolylineRangeEnd;
    }

    public PolylineOptions setFootPrintTexture(BitmapDescriptor bitmapDescriptor) {
        this.footPrintTexture = bitmapDescriptor;
        this.updateFlags.footPrintBDUpdate = true;
        return this;
    }

    public BitmapDescriptor getFootPrintTexture() {
        return this.footPrintTexture;
    }

    public PolylineOptions setFootPrintGap(float f2) {
        this.footPrintGap = f2;
        return this;
    }

    public float getFootPrintGap() {
        return this.footPrintGap;
    }

    public PolylineOptions setEraseTexture(boolean bl2, BitmapDescriptor bitmapDescriptor) {
        this.eraseVisible = bl2;
        this.eraseTexture = bitmapDescriptor;
        this.updateFlags.eraseUpdate = true;
        return this;
    }

    public BitmapDescriptor getEraseTexture() {
        return this.eraseTexture;
    }

    public boolean getEraseVisible() {
        return this.eraseVisible;
    }

    public PolylineOptions setEraseColor(boolean bl2, int n2) {
        this.eraseVisible = bl2;
        this.eraseColor = n2;
        this.updateFlags.eraseUpdate = true;
        return this;
    }

    public int getEraseColor() {
        return this.eraseColor;
    }

    @Override
    public void resetUpdateFlags() {
        this.updateFlags.reset();
    }

    @Override
    public PolylineUpdateFlags getUpdateFlags() {
        return this.updateFlags;
    }

    @JBindingInclude
    protected static class PolylineUpdateFlags
    extends BaseOptions.BaseUpdateFlags {
        protected boolean isPointsUpdated = false;
        protected boolean isCustomIndexesUpdated = false;
        protected boolean isCustomTextureListUpdated = false;
        protected boolean isColorValuesUpdated = false;
        protected boolean footPrintBDUpdate = false;
        protected boolean eraseUpdate = false;

        protected PolylineUpdateFlags() {
        }

        @Override
        public void reset() {
            super.reset();
            this.isPointsUpdated = false;
            this.isCustomIndexesUpdated = false;
            this.isCustomTextureListUpdated = false;
            this.isColorValuesUpdated = false;
            this.footPrintBDUpdate = false;
            this.eraseUpdate = false;
        }
    }

    public static enum LineJoinType {
        LineJoinBevel(0),
        LineJoinMiter(1),
        LineJoinRound(2);

        private int type;

        private LineJoinType(int n3) {
            this.type = n3;
        }

        public int getTypeValue() {
            return this.type;
        }

        public static LineJoinType valueOf(int n2) {
            LineJoinType[] lineJoinTypeArray = LineJoinType.values();
            n2 = Math.max(0, Math.min(n2, lineJoinTypeArray.length));
            return lineJoinTypeArray[n2];
        }
    }

    public static enum LineCapType {
        LineCapButt(0),
        LineCapSquare(1),
        LineCapArrow(2),
        LineCapRound(3);

        private int type;

        private LineCapType(int n3) {
            this.type = n3;
        }

        public static LineCapType valueOf(int n2) {
            LineCapType[] lineCapTypeArray = LineCapType.values();
            n2 = Math.max(0, Math.min(n2, lineCapTypeArray.length));
            return lineCapTypeArray[n2];
        }

        public int getTypeValue() {
            return this.type;
        }
    }
}

