/*
 * Decompiled with CFR 0.152.
 */
package com.amap.api.maps.model;

import com.amap.adapter.os.RemoteException;
import com.amap.adapter.text.TextUtils;
import com.amap.api.maps.interfaces.IGlOverlayLayer;
import com.amap.api.maps.model.BaseOverlay;
import com.amap.api.maps.model.TileOverlayOptions;
import com.autonavi.amap.mapcore.interfaces.ITileOverlay;
import com.autonavi.base.ae.gmap.bean.TileProviderInner;
import java.lang.ref.WeakReference;

public final class TileOverlay
extends BaseOverlay {
    private ITileOverlay mTileOverlayDelegate;
    private TileOverlayOptions options;
    private WeakReference<IGlOverlayLayer> glOverlayLayerRef;

    public TileOverlay(ITileOverlay iTileOverlay) {
        super("");
        this.mTileOverlayDelegate = iTileOverlay;
    }

    public TileOverlay(IGlOverlayLayer iGlOverlayLayer, TileOverlayOptions tileOverlayOptions, String string) {
        super(string);
        TileProviderInner tileProviderInner;
        this.glOverlayLayerRef = new WeakReference<IGlOverlayLayer>(iGlOverlayLayer);
        this.options = tileOverlayOptions;
        if (this.options != null && (tileProviderInner = this.options.getTileProviderInner()) != null) {
            tileProviderInner.init(iGlOverlayLayer, string);
        }
    }

    public void remove() {
        if (this.mTileOverlayDelegate != null) {
            this.mTileOverlayDelegate.remove();
        } else {
            try {
                IGlOverlayLayer iGlOverlayLayer = (IGlOverlayLayer)this.glOverlayLayerRef.get();
                if (iGlOverlayLayer != null) {
                    iGlOverlayLayer.removeOverlay(this.overlayName);
                }
            }
            catch (RemoteException remoteException) {
                remoteException.printStackTrace();
            }
        }
    }

    public void clearTileCache() {
        if (this.mTileOverlayDelegate != null) {
            this.mTileOverlayDelegate.clearTileCache();
        } else {
            this.a("clearTileCache", null);
        }
    }

    public String getId() {
        if (this.mTileOverlayDelegate != null) {
            return this.mTileOverlayDelegate.getId();
        }
        return this.overlayName;
    }

    public void setZIndex(float f2) {
        if (this.mTileOverlayDelegate != null) {
            this.mTileOverlayDelegate.setZIndex(f2);
        } else {
            this.options.zIndex(f2);
            this.a();
        }
    }

    public float getZIndex() {
        if (this.mTileOverlayDelegate != null) {
            return this.mTileOverlayDelegate.getZIndex();
        }
        return this.options.getZIndex();
    }

    public void setVisible(boolean bl2) {
        if (this.mTileOverlayDelegate != null) {
            this.mTileOverlayDelegate.setVisible(bl2);
        } else {
            this.options.visible(bl2);
            this.a();
        }
    }

    public boolean isVisible() {
        if (this.mTileOverlayDelegate != null) {
            return this.mTileOverlayDelegate.isVisible();
        }
        return this.options.isVisible();
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof TileOverlay)) {
            return false;
        }
        try {
            if (this.mTileOverlayDelegate != null) {
                return this.mTileOverlayDelegate.equalsRemote(((TileOverlay)object).mTileOverlayDelegate);
            }
            if (this.options != null) {
                return this.options.equals(((TileOverlay)object).options) && this.overlayName.equals(((TileOverlay)object).overlayName);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return false;
    }

    public int hashCode() {
        if (this.mTileOverlayDelegate != null) {
            return this.mTileOverlayDelegate.hashCode();
        }
        if (this.options != null) {
            int n2 = 31;
            int n3 = 1;
            n3 = n2 * n3 + (this.overlayName == null ? 0 : this.overlayName.hashCode());
            n3 = n2 * n3 + this.options.hashCode();
            return n3;
        }
        return super.hashCode();
    }

    private Object a(String string, Object[] objectArray) {
        try {
            IGlOverlayLayer iGlOverlayLayer = (IGlOverlayLayer)this.glOverlayLayerRef.get();
            if (!TextUtils.isEmpty(this.overlayName) && iGlOverlayLayer != null) {
                return iGlOverlayLayer.getNativeProperties(this.overlayName, string, objectArray);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    private void a() {
        try {
            IGlOverlayLayer iGlOverlayLayer = (IGlOverlayLayer)this.glOverlayLayerRef.get();
            if (!TextUtils.isEmpty(this.overlayName) && iGlOverlayLayer != null && iGlOverlayLayer != null) {
                iGlOverlayLayer.updateOption(this.overlayName, this.options);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

