/*
 * Decompiled with CFR 0.152.
 */
package com.amap.adapter.graphics;

import com.amap.adapter.os.Parcel;
import com.amap.adapter.os.Parcelable;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import ohos.media.image.PixelMap;
import ohos.media.image.common.PixelFormat;
import ohos.media.image.common.Position;
import ohos.media.image.common.Rect;
import ohos.media.image.common.Size;

public class Bitmap
implements Parcelable {
    private final Object pixelMap;
    private boolean isAlpha8Config = false;
    private PixelMap tempAlphaPixelMap = null;

    public Bitmap(PixelMap pixelMap) {
        this.pixelMap = pixelMap;
    }

    public Bitmap(PixelMap pixelMap, boolean bl2) {
        this.pixelMap = pixelMap;
        this.isAlpha8Config = bl2;
    }

    public PixelMap getOsPixelMap() {
        return (PixelMap)this.pixelMap;
    }

    private static PixelFormat getOsPixelFormat(Config config) {
        if (config == Config.RGB_565) {
            return PixelFormat.RGB_565;
        }
        if (config == Config.ALPHA_8) {
            return PixelFormat.ARGB_8888;
        }
        return PixelFormat.ARGB_8888;
    }

    private static Config getOsPixelFormat(PixelFormat pixelFormat) {
        if (pixelFormat == PixelFormat.RGB_565) {
            return Config.RGB_565;
        }
        return Config.ARGB_8888;
    }

    public static Bitmap createBitmap(int n2, int n3, Config config) {
        PixelMap.InitializationOptions initializationOptions = new PixelMap.InitializationOptions();
        initializationOptions.size = new Size(n2, n3);
        initializationOptions.pixelFormat = Bitmap.getOsPixelFormat(config);
        initializationOptions.editable = true;
        if (config == Config.ALPHA_8) {
            return new Bitmap(PixelMap.create((PixelMap.InitializationOptions)initializationOptions), true);
        }
        return new Bitmap(PixelMap.create((PixelMap.InitializationOptions)initializationOptions));
    }

    public static Bitmap createBitmap(Bitmap bitmap, int n2, int n3, int n4, int n5) {
        if (bitmap == null) {
            return null;
        }
        PixelMap.InitializationOptions initializationOptions = new PixelMap.InitializationOptions();
        initializationOptions.size = new Size(n4 - n2, n5 - n3);
        initializationOptions.editable = true;
        return new Bitmap(PixelMap.create((PixelMap)bitmap.getOsPixelMap(), (PixelMap.InitializationOptions)initializationOptions));
    }

    public static Bitmap createScaledBitmap(Bitmap bitmap, int n2, int n3, boolean bl2) {
        if (bitmap == null) {
            return null;
        }
        PixelMap.InitializationOptions initializationOptions = new PixelMap.InitializationOptions();
        initializationOptions.size = new Size(n2, n3);
        initializationOptions.editable = true;
        return new Bitmap(PixelMap.create((PixelMap)bitmap.getOsPixelMap(), (PixelMap.InitializationOptions)initializationOptions));
    }

    public int getWidth() {
        if (this.pixelMap != null) {
            PixelMap pixelMap = (PixelMap)this.pixelMap;
            return pixelMap.getImageInfo().size.width;
        }
        return 0;
    }

    public int getHeight() {
        if (this.pixelMap != null) {
            PixelMap pixelMap = (PixelMap)this.pixelMap;
            return pixelMap.getImageInfo().size.height;
        }
        return 0;
    }

    public Config getConfig() {
        if (this.isAlpha8Config) {
            return Config.ALPHA_8;
        }
        if (this.pixelMap != null) {
            PixelMap pixelMap = (PixelMap)this.pixelMap;
            return Bitmap.getOsPixelFormat(pixelMap.getImageInfo().pixelFormat);
        }
        return Config.ARGB_8888;
    }

    public Bitmap copy(Config config, boolean bl2) {
        if (this.pixelMap != null) {
            return Bitmap.createScaledBitmap(this, this.getWidth(), this.getHeight(), bl2);
        }
        return this;
    }

    public boolean isRecycled() {
        if (this.pixelMap != null) {
            PixelMap pixelMap = (PixelMap)this.pixelMap;
            return pixelMap.isReleased();
        }
        return false;
    }

    public boolean sameAs(Bitmap bitmap) {
        if (this.pixelMap != null && bitmap != null) {
            PixelMap pixelMap = (PixelMap)this.pixelMap;
            return pixelMap.isSameImage((PixelMap)bitmap.pixelMap);
        }
        return false;
    }

    public void copyPixelsToBuffer(ByteBuffer byteBuffer) {
        if (this.isAlpha8Config) {
            if (this.pixelMap != null) {
                if (this.tempAlphaPixelMap != null) {
                    this.tempAlphaPixelMap.release();
                }
                PixelMap pixelMap = (PixelMap)this.pixelMap;
                this.tempAlphaPixelMap = pixelMap.createFromAlpha();
                this.tempAlphaPixelMap.readPixels((Buffer)byteBuffer);
            }
        } else if (this.pixelMap != null) {
            PixelMap pixelMap = (PixelMap)this.pixelMap;
            pixelMap.readPixels((Buffer)byteBuffer);
        }
    }

    public void compress(CompressFormat compressFormat, int n2, OutputStream outputStream) {
        if (this.pixelMap != null) {
            byte[] byArray = new byte[this.getByteCount()];
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
            PixelMap pixelMap = (PixelMap)this.pixelMap;
            pixelMap.readPixels((Buffer)byteBuffer);
            try {
                outputStream.write(byteBuffer.array());
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public void setPixels(int[] nArray, int n2, int n3, int n4, int n5, int n6, int n7) {
        if (this.pixelMap != null) {
            PixelMap pixelMap = (PixelMap)this.pixelMap;
            pixelMap.writePixels(nArray, n2, n3, new Rect(n4, n5, n6, n7));
        }
    }

    public byte[] getNinePatchChunk() {
        if (this.pixelMap != null) {
            PixelMap pixelMap = (PixelMap)this.pixelMap;
            return pixelMap.getNinePatchChunk();
        }
        return new byte[0];
    }

    public void getPixels(int[] nArray, int n2, int n3, int n4, int n5, int n6, int n7) {
        if (this.pixelMap != null) {
            PixelMap pixelMap = (PixelMap)this.pixelMap;
            pixelMap.readPixels(nArray, n2, n3, new Rect(n4, n5, n6, n7));
        }
    }

    public void recycle() {
        if (this.pixelMap != null) {
            PixelMap pixelMap = (PixelMap)this.pixelMap;
            pixelMap.release();
        }
        if (this.tempAlphaPixelMap != null) {
            this.tempAlphaPixelMap.release();
        }
    }

    public int getByteCount() {
        if (this.pixelMap != null) {
            PixelMap pixelMap = (PixelMap)this.pixelMap;
            return pixelMap.getBytesNumberPerRow() * this.getHeight();
        }
        return 0;
    }

    public int getRowBytes() {
        if (this.pixelMap != null) {
            PixelMap pixelMap = (PixelMap)this.pixelMap;
            return pixelMap.getBytesNumberPerRow();
        }
        return 0;
    }

    public int getPixel(int n2, int n3) {
        if (this.pixelMap != null) {
            PixelMap pixelMap = (PixelMap)this.pixelMap;
            return pixelMap.readPixel(new Position(n2, n3));
        }
        return 0;
    }

    public boolean hasAlpha() {
        return this.getConfig() != Config.RGB_565;
    }

    public void setPixel(int n2, int n3, int n4) {
        if (this.pixelMap != null) {
            PixelMap pixelMap = (PixelMap)this.pixelMap;
            pixelMap.writePixel(new Position(n2, n3), n4);
        }
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel parcel, int n2) {
    }

    public static enum Config {
        ALPHA_8(1),
        RGB_565(3),
        ARGB_8888(5);

        final int nativeInt;

        private Config(int n3) {
            this.nativeInt = n3;
        }
    }

    public static enum CompressFormat {
        JPEG(0),
        PNG(1),
        WEBP(2);

        final int nativeInt;

        private CompressFormat(int n3) {
            this.nativeInt = n3;
        }
    }
}

