/*
 * Decompiled with CFR 0.152.
 */
package com.amap.adapter.graphics;

import com.amap.adapter.graphics.Rect;
import com.amap.adapter.graphics.Typeface;
import ohos.agp.render.Paint;
import ohos.agp.utils.Color;

public class Paint {
    private final ohos.agp.render.Paint osPaint = new ohos.agp.render.Paint();

    public float measureText(String string) {
        return this.osPaint.measureText(string);
    }

    public Align getTextAlign() {
        int n2 = this.osPaint.getTextAlign();
        if (n2 == 72) {
            return Align.CENTER;
        }
        if (n2 == 4) {
            return Align.LEFT;
        }
        return Align.RIGHT;
    }

    public float getTextSize() {
        return this.osPaint.getTextSize();
    }

    public void setTextAlign(Align align) {
        if (align == Align.CENTER) {
            this.osPaint.setTextAlign(72);
        } else if (align == Align.LEFT) {
            this.osPaint.setTextAlign(4);
        } else if (align == Align.RIGHT) {
            this.osPaint.setTextAlign(16);
        }
    }

    public void setTextSize(float f2) {
        if (f2 <= 0.0f) {
            f2 = 1.0f;
        }
        this.osPaint.setTextSize((int)f2);
    }

    public void setColor(int n2) {
        this.osPaint.setColor(new Color(n2));
    }

    public void setAntiAlias(boolean bl2) {
        this.osPaint.setAntiAlias(bl2);
    }

    public void setFilterBitmap(boolean bl2) {
        this.osPaint.setFilterBitmap(bl2);
    }

    public void setTypeface(Typeface typeface) {
    }

    public FontMetrics getFontMetrics() {
        Paint.FontMetrics fontMetrics = this.osPaint.getFontMetrics();
        FontMetrics fontMetrics2 = new FontMetrics();
        fontMetrics2.ascent = fontMetrics.ascent;
        fontMetrics2.descent = fontMetrics.descent;
        fontMetrics2.top = fontMetrics.top;
        fontMetrics2.bottom = fontMetrics.bottom;
        fontMetrics2.leading = fontMetrics.leading;
        return fontMetrics2;
    }

    public void setStyle(Style style) {
        if (style == Style.STROKE) {
            this.osPaint.setStyle(Paint.Style.STROKE_STYLE);
        } else if (style == Style.FILL) {
            this.osPaint.setStyle(Paint.Style.FILL_STYLE);
        } else if (style == Style.FILL_AND_STROKE) {
            this.osPaint.setStyle(Paint.Style.FILLANDSTROKE_STYLE);
        }
    }

    public void setStrokeWidth(float f2) {
        this.osPaint.setStrokeWidth(f2);
    }

    public void getTextBounds(String string, int n2, int n3, Rect rect) {
        if ((n2 | n3 | n3 - n2 | string.length() - n3) < 0) {
            throw new IndexOutOfBoundsException();
        }
        String string2 = string.substring(n2, n3);
        ohos.agp.utils.Rect rect2 = this.osPaint.getTextBounds(string2);
        rect.left = rect2.left;
        rect.top = rect2.top;
        rect.right = rect2.right;
        rect.bottom = rect2.bottom;
    }

    public void setSubpixelText(boolean bl2) {
        this.osPaint.setSubpixelAntiAlias(bl2);
    }

    public void setStrokeCap(Cap cap) {
        if (cap == Cap.ROUND) {
            this.osPaint.setStrokeCap(Paint.StrokeCap.ROUND_CAP);
        } else if (cap == Cap.BUTT) {
            this.osPaint.setStrokeCap(Paint.StrokeCap.BUTT_CAP);
        } else if (cap == Cap.SQUARE) {
            this.osPaint.setStrokeCap(Paint.StrokeCap.SQUARE_CAP);
        }
    }

    public ohos.agp.render.Paint getOsPaint() {
        return this.osPaint;
    }

    public static class FontMetrics {
        public float top;
        public float ascent;
        public float descent;
        public float bottom;
        public float leading;
    }

    public static enum Align {
        LEFT(0),
        CENTER(1),
        RIGHT(2);

        final int nativeInt;

        private Align(int n3) {
            this.nativeInt = n3;
        }
    }

    public static enum Join {
        MITER(0),
        ROUND(1),
        BEVEL(2);

        final int nativeInt;

        private Join(int n3) {
            this.nativeInt = n3;
        }
    }

    public static enum Cap {
        BUTT(0),
        ROUND(1),
        SQUARE(2);

        final int nativeInt;

        private Cap(int n3) {
            this.nativeInt = n3;
        }
    }

    public static enum Style {
        FILL(0),
        STROKE(1),
        FILL_AND_STROKE(2);

        final int nativeInt;

        private Style(int n3) {
            this.nativeInt = n3;
        }
    }
}

