/*
 * Decompiled with CFR 0.152.
 */
package com.amap.adapter.json;

import com.amap.adapter.json.JSONArray;
import com.amap.adapter.json.JSONException;
import com.amap.adapter.json.JSONObject;

public class JSONTokener {
    private final String in;
    private int pos;

    public JSONTokener(String string) {
        if (string != null && string.startsWith("\ufeff")) {
            string = string.substring(1);
        }
        this.in = string;
    }

    public Object nextValue() throws JSONException {
        int n2 = this.nextCleanInternal();
        switch (n2) {
            case -1: {
                throw this.syntaxError("End of input");
            }
            case 123: {
                return this.readObject();
            }
            case 91: {
                return this.readArray();
            }
            case 34: 
            case 39: {
                return this.nextString((char)n2);
            }
        }
        --this.pos;
        return this.readLiteral();
    }

    private int nextCleanInternal() throws JSONException {
        block9: while (this.pos < this.in.length()) {
            char c2 = this.in.charAt(this.pos++);
            switch (c2) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    continue block9;
                }
                case '/': {
                    if (this.pos == this.in.length()) {
                        return c2;
                    }
                    char c3 = this.in.charAt(this.pos);
                    switch (c3) {
                        case '*': {
                            ++this.pos;
                            int n2 = this.in.indexOf("*/", this.pos);
                            if (n2 == -1) {
                                throw this.syntaxError("Unterminated comment");
                            }
                            this.pos = n2 + 2;
                            continue block9;
                        }
                        case '/': {
                            ++this.pos;
                            this.skipToEndOfLine();
                            continue block9;
                        }
                    }
                    return c2;
                }
                case '#': {
                    this.skipToEndOfLine();
                    continue block9;
                }
            }
            return c2;
        }
        return -1;
    }

    private void skipToEndOfLine() {
        while (this.pos < this.in.length()) {
            char c2 = this.in.charAt(this.pos);
            if (c2 == '\r' || c2 == '\n') {
                ++this.pos;
                break;
            }
            ++this.pos;
        }
    }

    public String nextString(char c2) throws JSONException {
        StringBuilder stringBuilder = null;
        int n2 = this.pos;
        while (this.pos < this.in.length()) {
            char c3;
            if ((c3 = this.in.charAt(this.pos++)) == c2) {
                if (stringBuilder == null) {
                    return new String(this.in.substring(n2, this.pos - 1));
                }
                stringBuilder.append(this.in, n2, this.pos - 1);
                return stringBuilder.toString();
            }
            if (c3 != '\\') continue;
            if (this.pos == this.in.length()) {
                throw this.syntaxError("Unterminated escape sequence");
            }
            if (stringBuilder == null) {
                stringBuilder = new StringBuilder();
            }
            stringBuilder.append(this.in, n2, this.pos - 1);
            stringBuilder.append(this.readEscapeCharacter());
            n2 = this.pos;
        }
        throw this.syntaxError("Unterminated string");
    }

    private char readEscapeCharacter() throws JSONException {
        char c2 = this.in.charAt(this.pos++);
        switch (c2) {
            case 'u': {
                if (this.pos + 4 > this.in.length()) {
                    throw this.syntaxError("Unterminated escape sequence");
                }
                String string = this.in.substring(this.pos, this.pos + 4);
                this.pos += 4;
                try {
                    return (char)Integer.parseInt(string, 16);
                }
                catch (NumberFormatException numberFormatException) {
                    throw this.syntaxError("Invalid escape sequence: " + string);
                }
            }
            case 't': {
                return '\t';
            }
            case 'b': {
                return '\b';
            }
            case 'n': {
                return '\n';
            }
            case 'r': {
                return '\r';
            }
            case 'f': {
                return '\f';
            }
        }
        return c2;
    }

    private Object readLiteral() throws JSONException {
        String string = this.nextToInternal("{}[]/\\:,=;# \t\f");
        if (string.length() == 0) {
            throw this.syntaxError("Expected literal value");
        }
        if ("null".equalsIgnoreCase(string)) {
            return JSONObject.NULL;
        }
        if ("true".equalsIgnoreCase(string)) {
            return Boolean.TRUE;
        }
        if ("false".equalsIgnoreCase(string)) {
            return Boolean.FALSE;
        }
        if (string.indexOf(46) == -1) {
            int n2 = 10;
            String string2 = string;
            if (string2.startsWith("0x") || string2.startsWith("0X")) {
                string2 = string2.substring(2);
                n2 = 16;
            } else if (string2.startsWith("0") && string2.length() > 1) {
                string2 = string2.substring(1);
                n2 = 8;
            }
            try {
                long l2 = Long.parseLong(string2, n2);
                if (l2 <= Integer.MAX_VALUE && l2 >= Integer.MIN_VALUE) {
                    return (int)l2;
                }
                return l2;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        try {
            return Double.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            return new String(string);
        }
    }

    private String nextToInternal(String string) {
        int n2 = this.pos;
        while (this.pos < this.in.length()) {
            char c2 = this.in.charAt(this.pos);
            if (c2 == '\r' || c2 == '\n' || string.indexOf(c2) != -1) {
                return this.in.substring(n2, this.pos);
            }
            ++this.pos;
        }
        return this.in.substring(n2);
    }

    private JSONObject readObject() throws JSONException {
        JSONObject jSONObject = new JSONObject();
        int n2 = this.nextCleanInternal();
        if (n2 == 125) {
            return jSONObject;
        }
        if (n2 != -1) {
            --this.pos;
        }
        block4: while (true) {
            Object object;
            if (!((object = this.nextValue()) instanceof String)) {
                if (object == null) {
                    throw this.syntaxError("Names cannot be null");
                }
                throw this.syntaxError("Names must be strings, but " + object + " is of type " + object.getClass().getName());
            }
            int n3 = this.nextCleanInternal();
            if (n3 != 58 && n3 != 61) {
                throw this.syntaxError("Expected ':' after " + object);
            }
            if (this.pos < this.in.length() && this.in.charAt(this.pos) == '>') {
                ++this.pos;
            }
            jSONObject.put((String)object, this.nextValue());
            switch (this.nextCleanInternal()) {
                case 125: {
                    return jSONObject;
                }
                case 44: 
                case 59: {
                    continue block4;
                }
            }
            break;
        }
        throw this.syntaxError("Unterminated object");
    }

    private JSONArray readArray() throws JSONException {
        JSONArray jSONArray = new JSONArray();
        boolean bl2 = false;
        block9: while (true) {
            switch (this.nextCleanInternal()) {
                case -1: {
                    throw this.syntaxError("Unterminated array");
                }
                case 93: {
                    if (bl2) {
                        jSONArray.put(null);
                    }
                    return jSONArray;
                }
                case 44: 
                case 59: {
                    jSONArray.put(null);
                    bl2 = true;
                    continue block9;
                }
            }
            --this.pos;
            jSONArray.put(this.nextValue());
            switch (this.nextCleanInternal()) {
                case 93: {
                    return jSONArray;
                }
                case 44: 
                case 59: {
                    bl2 = true;
                    continue block9;
                }
            }
            break;
        }
        throw this.syntaxError("Unterminated array");
    }

    public JSONException syntaxError(String string) {
        return new JSONException(string + this);
    }

    public String toString() {
        return " at character " + this.pos + " of " + this.in;
    }

    public boolean more() {
        return this.pos < this.in.length();
    }

    public char next() {
        return this.pos < this.in.length() ? this.in.charAt(this.pos++) : (char)'\u0000';
    }

    public char next(char c2) throws JSONException {
        char c3 = this.next();
        if (c3 != c2) {
            throw this.syntaxError("Expected " + c2 + " but was " + c3);
        }
        return c3;
    }

    public char nextClean() throws JSONException {
        int n2 = this.nextCleanInternal();
        return n2 == -1 ? (char)'\u0000' : (char)n2;
    }

    public String next(int n2) throws JSONException {
        if (this.pos + n2 > this.in.length()) {
            throw this.syntaxError(n2 + " is out of bounds");
        }
        String string = this.in.substring(this.pos, this.pos + n2);
        this.pos += n2;
        return string;
    }

    public String nextTo(String string) {
        if (string == null) {
            throw new NullPointerException("excluded == null");
        }
        return this.nextToInternal(string).trim();
    }

    public String nextTo(char c2) {
        return this.nextToInternal(String.valueOf(c2)).trim();
    }

    public void skipPast(String string) {
        int n2 = this.in.indexOf(string, this.pos);
        this.pos = n2 == -1 ? this.in.length() : n2 + string.length();
    }

    public char skipTo(char c2) {
        int n2 = this.in.indexOf(c2, this.pos);
        if (n2 != -1) {
            this.pos = n2;
            return c2;
        }
        return '\u0000';
    }

    public void back() {
        if (--this.pos == -1) {
            this.pos = 0;
        }
    }

    public static int dehexchar(char c2) {
        if (c2 >= '0' && c2 <= '9') {
            return c2 - 48;
        }
        if (c2 >= 'A' && c2 <= 'F') {
            return c2 - 65 + 10;
        }
        if (c2 >= 'a' && c2 <= 'f') {
            return c2 - 97 + 10;
        }
        return -1;
    }
}

