/*
 * Decompiled with CFR 0.152.
 */
package com.amap.adapter.net.wifi;

import com.amap.adapter.net.wifi.ScanResult;
import com.amap.adapter.net.wifi.WifiInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import ohos.app.Context;
import ohos.wifi.WifiDevice;
import ohos.wifi.WifiLinkedInfo;
import ohos.wifi.WifiScanInfo;

public class WifiManager {
    private Context mContext;
    private WifiDevice wifiDevice;
    private WifiLinkedInfo wifiLinkedInfo;

    public WifiManager(Context context) {
        this.mContext = context;
        this.wifiDevice = WifiDevice.getInstance((Context)this.mContext);
    }

    public boolean isWifiEnabled() {
        if (null != this.wifiDevice) {
            return this.wifiDevice.isWifiActive();
        }
        return false;
    }

    public WifiInfo getConnectionInfo() {
        Optional optional;
        if (null != this.wifiDevice && this.wifiDevice.isConnected() && null != (optional = this.wifiDevice.getLinkedInfo())) {
            return new WifiInfo((WifiLinkedInfo)optional.get());
        }
        return null;
    }

    public List<ScanResult> getScanResults() {
        List list;
        ArrayList<ScanResult> arrayList = new ArrayList<ScanResult>();
        if (null != this.wifiDevice && null != (list = this.wifiDevice.getScanInfoList()) && list.size() > 0) {
            for (WifiScanInfo wifiScanInfo : list) {
                ScanResult scanResult = new ScanResult(wifiScanInfo);
                arrayList.add(scanResult);
            }
        }
        return arrayList;
    }
}

