/*
 * Decompiled with CFR 0.152.
 */
package com.amap.api.maps;

import com.amap.adapter.content.Context;
import com.amap.api.mapcore.util.ag;
import com.amap.api.mapcore.util.el;
import com.amap.api.mapcore.util.eq;
import com.amap.api.mapcore.util.hd;
import com.amap.api.maps.model.LatLng;

public class CoordinateConverter {
    private static final String TAG = "CoordinateConverter";
    private Context ctx;
    private CoordType coordType = null;
    private LatLng sourceLatLng = null;

    public CoordinateConverter(Context context) {
        this.ctx = context;
    }

    public CoordinateConverter from(CoordType coordType) {
        this.coordType = coordType;
        return this;
    }

    public CoordinateConverter coord(LatLng latLng) {
        this.sourceLatLng = latLng;
        return this;
    }

    public LatLng convert() {
        if (this.coordType == null) {
            return null;
        }
        if (null == this.sourceLatLng) {
            return null;
        }
        LatLng latLng = null;
        try {
            String string = "";
            switch (this.coordType) {
                case BAIDU: {
                    latLng = ag.a(this.sourceLatLng);
                    string = "baidu";
                    break;
                }
                case MAPBAR: {
                    latLng = ag.b(this.ctx, this.sourceLatLng);
                    string = "mapbar";
                    break;
                }
                case MAPABC: {
                    string = "mapabc";
                    latLng = this.sourceLatLng;
                    break;
                }
                case SOSOMAP: {
                    string = "sosomap";
                    latLng = this.sourceLatLng;
                    break;
                }
                case ALIYUN: {
                    string = "aliyun";
                    latLng = this.sourceLatLng;
                    break;
                }
                case GOOGLE: {
                    string = "google";
                    latLng = this.sourceLatLng;
                    break;
                }
                case GPS: {
                    string = "gps";
                    latLng = ag.a(this.ctx, this.sourceLatLng);
                    break;
                }
            }
            eq.a(this.ctx, string);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            hd.c(throwable, TAG, "convert");
            latLng = this.sourceLatLng;
        }
        return latLng;
    }

    public static boolean isAMapDataAvailable(double d2, double d3) {
        return el.a(d2, d3);
    }

    public static enum CoordType {
        BAIDU,
        MAPBAR,
        GPS,
        MAPABC,
        SOSOMAP,
        ALIYUN,
        GOOGLE;

    }
}

