/*
 * Decompiled with CFR 0.152.
 */
package com.amap.api.maps.model;

import com.amap.adapter.os.Bundle;
import com.amap.adapter.os.Parcel;
import com.amap.adapter.os.Parcelable;
import com.amap.api.mapcore.util.es;
import com.amap.api.maps.model.BaseHoleOptions;
import com.amap.api.maps.model.BaseOptions;
import com.amap.api.maps.model.CircleHoleOptions;
import com.amap.api.maps.model.CircleOptionsCreator;
import com.amap.api.maps.model.LatLng;
import com.amap.api.maps.model.PolygonHoleOptions;
import com.autonavi.base.amap.mapcore.jbinding.JBindingExclude;
import com.autonavi.base.amap.mapcore.jbinding.JBindingInclude;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@JBindingInclude
public final class CircleOptions
extends BaseOptions
implements Parcelable,
Cloneable {
    @JBindingExclude
    public static final CircleOptionsCreator CREATOR = new CircleOptionsCreator();
    @JBindingExclude
    String a;
    private LatLng point = null;
    private double radius = 0.0;
    private float strokeWidth = 10.0f;
    private int strokeColor = -16777216;
    private int fillColor = 0;
    private float zIndex = 0.0f;
    private boolean isVisible = true;
    private List<BaseHoleOptions> holeOptions;
    private int dottedLineType = -1;
    private boolean isUsePolylineStroke = true;
    private CircleUpdateFlags updateFlags = new CircleUpdateFlags();

    public CircleOptions() {
        this.holeOptions = new ArrayList<BaseHoleOptions>();
        this.type = "CircleOptions";
    }

    @Override
    public void writeToParcel(Parcel parcel, int n2) {
        Bundle bundle = new Bundle();
        if (this.point != null) {
            bundle.putDouble("lat", this.point.latitude);
            bundle.putDouble("lng", this.point.longitude);
        }
        parcel.writeBundle(bundle);
        parcel.writeDouble(this.radius);
        parcel.writeFloat(this.strokeWidth);
        parcel.writeInt(this.strokeColor);
        parcel.writeInt(this.fillColor);
        parcel.writeFloat(this.zIndex);
        parcel.writeByte((byte)(this.isVisible ? 1 : 0));
        parcel.writeString(this.a);
        parcel.writeList(this.holeOptions);
        parcel.writeInt(this.dottedLineType);
        parcel.writeByte((byte)(this.isUsePolylineStroke ? 1 : 0));
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public CircleOptions center(LatLng latLng) {
        this.point = latLng;
        this.updateFlags.isCenterUpdated = true;
        this.a();
        return this;
    }

    public CircleOptions radius(double d2) {
        this.radius = d2;
        this.updateFlags.isRadiusUpdated = true;
        this.a();
        return this;
    }

    public CircleOptions strokeWidth(float f2) {
        this.strokeWidth = f2;
        return this;
    }

    public CircleOptions strokeColor(int n2) {
        this.strokeColor = n2;
        return this;
    }

    public CircleOptions fillColor(int n2) {
        this.fillColor = n2;
        return this;
    }

    public CircleOptions zIndex(float f2) {
        if (this.zIndex != f2) {
            this.updateFlags.zIndexUpdate = true;
        }
        this.zIndex = f2;
        return this;
    }

    public CircleOptions visible(boolean bl2) {
        this.isVisible = bl2;
        return this;
    }

    public LatLng getCenter() {
        return this.point;
    }

    public double getRadius() {
        return this.radius;
    }

    public float getStrokeWidth() {
        return this.strokeWidth;
    }

    public int getStrokeColor() {
        return this.strokeColor;
    }

    public int getFillColor() {
        return this.fillColor;
    }

    public float getZIndex() {
        return this.zIndex;
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    public CircleOptions addHoles(BaseHoleOptions ... baseHoleOptionsArray) {
        try {
            if (baseHoleOptionsArray != null) {
                this.holeOptions.addAll(Arrays.asList(baseHoleOptionsArray));
                this.a();
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return this;
    }

    public CircleOptions addHoles(Iterable<BaseHoleOptions> iterable) {
        try {
            if (iterable != null) {
                for (BaseHoleOptions baseHoleOptions : iterable) {
                    this.holeOptions.add(baseHoleOptions);
                }
                this.a();
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return this;
    }

    public List<BaseHoleOptions> getHoleOptions() {
        return this.holeOptions;
    }

    public CircleOptions setStrokeDottedLineType(int n2) {
        this.dottedLineType = n2;
        return this;
    }

    public int getStrokeDottedLineType() {
        return this.dottedLineType;
    }

    public CircleOptions usePolylineStroke(boolean bl2) {
        this.isUsePolylineStroke = bl2;
        return this;
    }

    public boolean isUsePolylineStroke() {
        return this.isUsePolylineStroke;
    }

    private void a() {
        if (this.holeOptions != null) {
            ArrayList<BaseHoleOptions> arrayList = new ArrayList<BaseHoleOptions>();
            List<BaseHoleOptions> list = this.holeOptions;
            for (int i2 = 0; i2 < list.size(); ++i2) {
                BaseHoleOptions baseHoleOptions;
                BaseHoleOptions baseHoleOptions2 = list.get(i2);
                if (baseHoleOptions2 instanceof PolygonHoleOptions) {
                    baseHoleOptions = (PolygonHoleOptions)baseHoleOptions2;
                    if (!es.a(this.getRadius(), this.getCenter(), arrayList, baseHoleOptions) || es.a(arrayList, baseHoleOptions)) continue;
                    arrayList.add(baseHoleOptions);
                    continue;
                }
                if (!(baseHoleOptions2 instanceof CircleHoleOptions)) continue;
                baseHoleOptions = (CircleHoleOptions)baseHoleOptions2;
                if (!es.a(this.getRadius(), this.getCenter(), (CircleHoleOptions)baseHoleOptions) || es.a(arrayList, (CircleHoleOptions)baseHoleOptions)) continue;
                arrayList.add(baseHoleOptions);
            }
            this.holeOptions.clear();
            this.holeOptions.addAll(arrayList);
            this.updateFlags.isHoleOptionsUpdated = true;
        }
    }

    public CircleOptions clone() {
        try {
            super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace();
        }
        CircleOptions circleOptions = new CircleOptions();
        circleOptions.a = this.a;
        circleOptions.point = this.point;
        circleOptions.radius = this.radius;
        circleOptions.strokeWidth = this.strokeWidth;
        circleOptions.strokeColor = this.strokeColor;
        circleOptions.fillColor = this.fillColor;
        circleOptions.zIndex = this.zIndex;
        circleOptions.isVisible = this.isVisible;
        circleOptions.holeOptions = this.holeOptions;
        circleOptions.dottedLineType = this.dottedLineType;
        circleOptions.isUsePolylineStroke = this.isUsePolylineStroke;
        circleOptions.updateFlags = this.updateFlags;
        return circleOptions;
    }

    @Override
    public void resetUpdateFlags() {
        this.updateFlags.reset();
    }

    @Override
    protected CircleUpdateFlags getUpdateFlags() {
        return this.updateFlags;
    }

    @JBindingInclude
    protected static class CircleUpdateFlags
    extends BaseOptions.BaseUpdateFlags {
        protected boolean isCenterUpdated = false;
        protected boolean isRadiusUpdated = false;
        protected boolean isHoleOptionsUpdated = false;

        protected CircleUpdateFlags() {
        }

        @Override
        public void reset() {
            super.reset();
            this.isCenterUpdated = false;
            this.isRadiusUpdated = false;
            this.isHoleOptionsUpdated = false;
        }
    }
}

