/*
 * Decompiled with CFR 0.152.
 */
package com.amap.api.maps.model;

import com.amap.adapter.os.Parcel;
import com.amap.adapter.os.Parcelable;
import com.amap.api.maps.model.BaseOptions;
import com.amap.api.maps.model.BitmapDescriptor;
import com.amap.api.maps.model.LatLng;
import com.amap.api.maps.model.MarkerOptionsCreator;
import com.autonavi.base.amap.mapcore.jbinding.JBindingExclude;
import com.autonavi.base.amap.mapcore.jbinding.JBindingInclude;
import com.autonavi.util.Shifting;
import java.util.ArrayList;
import java.util.List;

@JBindingInclude
public final class MarkerOptions
extends BaseOptions
implements Parcelable,
Cloneable {
    @JBindingExclude
    public static final MarkerOptionsCreator CREATOR = new MarkerOptionsCreator();
    private LatLng latLng;
    private LatLng gpsLatLng;
    private String title;
    private String snippet;
    private float anchorU = 0.5f;
    private float anchorV = 1.0f;
    private float zIndex = 0.0f;
    private boolean isDraggable = false;
    private boolean isVisible = true;
    @JBindingExclude
    String a;
    @JBindingExclude
    private boolean perspective = false;
    private int offsetX = 0;
    private int offsetY = 0;
    private List<BitmapDescriptor> bitmapDescriptors = new ArrayList<BitmapDescriptor>();
    private int period = 20;
    private boolean isGps = false;
    private boolean isFlat = false;
    private boolean isRotatingMode = false;
    private float angleOffset = 0.0f;
    private int screenX;
    private int screenY;
    private boolean isViewMode = false;
    private float alpha = 1.0f;
    private boolean autoOverturn = false;
    private boolean infoWindowEnabled = true;
    private int dispLevel = 5;
    private float rotate;
    private boolean isBelowMaskLayer;
    private MarkerUpdateFlags updateFlags = new MarkerUpdateFlags();

    public MarkerOptions icons(ArrayList<BitmapDescriptor> arrayList) {
        if (arrayList != null && arrayList.size() > 0) {
            this.bitmapDescriptors = arrayList;
            this.isRotatingMode = false;
            this.updateFlags.bitmapDescriptorsUpdate = true;
        }
        return this;
    }

    public MarkerOptions rotatingIcons(ArrayList<BitmapDescriptor> arrayList, float f2) {
        if (arrayList != null && arrayList.size() > 0) {
            this.bitmapDescriptors = arrayList;
            this.angleOffset = f2 != 0.0f ? f2 : 360.0f / (float)arrayList.size();
            this.isRotatingMode = true;
            this.updateFlags.bitmapDescriptorsUpdate = true;
        }
        return this;
    }

    protected MarkerOptions angleOffset(float f2) {
        this.angleOffset = f2;
        return this;
    }

    public float getAngleOffset() {
        return this.angleOffset;
    }

    protected MarkerOptions setRotatingMode(boolean bl2) {
        this.isRotatingMode = bl2;
        return this;
    }

    public boolean isRotatingMode() {
        return this.isRotatingMode;
    }

    public ArrayList<BitmapDescriptor> getIcons() {
        return (ArrayList)this.bitmapDescriptors;
    }

    public MarkerOptions period(int n2) {
        this.period = n2 <= 1 ? 1 : n2;
        return this;
    }

    public int getPeriod() {
        return this.period;
    }

    public boolean isPerspective() {
        return this.perspective;
    }

    public MarkerOptions perspective(boolean bl2) {
        this.perspective = bl2;
        return this;
    }

    public MarkerOptions() {
        this.type = "MarkerOptions";
    }

    public MarkerOptions position(LatLng latLng) {
        this.latLng = latLng;
        this.isViewMode = false;
        this.b();
        this.updateFlags.latlngUpdate = true;
        return this;
    }

    public MarkerOptions setFlat(boolean bl2) {
        this.isFlat = bl2;
        return this;
    }

    private void a() {
        if (this.bitmapDescriptors == null) {
            try {
                this.bitmapDescriptors = new ArrayList<BitmapDescriptor>();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    public MarkerOptions icon(BitmapDescriptor bitmapDescriptor) {
        try {
            this.a();
            this.bitmapDescriptors.clear();
            this.bitmapDescriptors.add(bitmapDescriptor);
            this.isRotatingMode = false;
            this.updateFlags.bitmapDescriptorsUpdate = true;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return this;
    }

    public MarkerOptions anchor(float f2, float f3) {
        this.anchorU = f2;
        this.anchorV = f3;
        return this;
    }

    public MarkerOptions setInfoWindowOffset(int n2, int n3) {
        this.offsetX = n2;
        this.offsetY = n3;
        return this;
    }

    public MarkerOptions title(String string) {
        this.title = string;
        return this;
    }

    public MarkerOptions snippet(String string) {
        this.snippet = string;
        return this;
    }

    public MarkerOptions draggable(boolean bl2) {
        this.isDraggable = bl2;
        return this;
    }

    public MarkerOptions visible(boolean bl2) {
        this.isVisible = bl2;
        return this;
    }

    public MarkerOptions setGps(boolean bl2) {
        this.isGps = bl2;
        this.b();
        return this;
    }

    public LatLng getPosition() {
        return this.latLng;
    }

    public String getTitle() {
        return this.title;
    }

    public String getSnippet() {
        return this.snippet;
    }

    public BitmapDescriptor getIcon() {
        if (this.bitmapDescriptors != null && this.bitmapDescriptors.size() != 0) {
            return this.bitmapDescriptors.get(0);
        }
        return null;
    }

    public float getAnchorU() {
        return this.anchorU;
    }

    public int getInfoWindowOffsetX() {
        return this.offsetX;
    }

    public int getInfoWindowOffsetY() {
        return this.offsetY;
    }

    public float getAnchorV() {
        return this.anchorV;
    }

    public boolean isDraggable() {
        return this.isDraggable;
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    public boolean isGps() {
        return this.isGps;
    }

    public boolean isFlat() {
        return this.isFlat;
    }

    public MarkerOptions zIndex(float f2) {
        if (this.zIndex != f2) {
            this.updateFlags.zIndexUpdate = true;
        }
        this.zIndex = f2;
        return this;
    }

    public float getZIndex() {
        return this.zIndex;
    }

    public MarkerOptions alpha(float f2) {
        this.alpha = f2;
        return this;
    }

    public float getAlpha() {
        return this.alpha;
    }

    public MarkerOptions autoOverturnInfoWindow(boolean bl2) {
        this.autoOverturn = bl2;
        return this;
    }

    public boolean isInfoWindowAutoOverturn() {
        return this.autoOverturn;
    }

    public MarkerOptions displayLevel(int n2) {
        this.dispLevel = n2;
        return this;
    }

    public int getDisplayLevel() {
        return this.dispLevel;
    }

    public MarkerOptions rotateAngle(float f2) {
        this.rotate = f2;
        return this;
    }

    public float getRotateAngle() {
        return this.rotate;
    }

    public MarkerOptions infoWindowEnable(boolean bl2) {
        this.infoWindowEnabled = bl2;
        return this;
    }

    public boolean isInfoWindowEnable() {
        return this.infoWindowEnabled;
    }

    public MarkerOptions belowMaskLayer(boolean bl2) {
        this.isBelowMaskLayer = bl2;
        return this;
    }

    public boolean isBelowMaskLayer() {
        return this.isBelowMaskLayer;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel parcel, int n2) {
        parcel.writeParcelable(this.latLng, n2);
        parcel.writeString(this.title);
        parcel.writeString(this.snippet);
        parcel.writeFloat(this.anchorU);
        parcel.writeFloat(this.anchorV);
        parcel.writeInt(this.offsetX);
        parcel.writeInt(this.offsetY);
        parcel.writeBooleanArray(new boolean[]{this.isVisible, this.isDraggable, this.isGps, this.isFlat, this.autoOverturn, this.infoWindowEnabled, this.isBelowMaskLayer, this.isRotatingMode});
        parcel.writeString(this.a);
        parcel.writeInt(this.period);
        parcel.writeList(this.bitmapDescriptors);
        parcel.writeFloat(this.zIndex);
        parcel.writeFloat(this.alpha);
        parcel.writeInt(this.dispLevel);
        parcel.writeFloat(this.rotate);
        parcel.writeFloat(this.angleOffset);
        parcel.writeInt(this.screenX);
        parcel.writeInt(this.screenY);
        if (this.bitmapDescriptors != null && this.bitmapDescriptors.size() != 0) {
            parcel.writeParcelable(this.bitmapDescriptors.get(0), n2);
        }
    }

    public MarkerOptions clone() {
        try {
            super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace();
        }
        MarkerOptions markerOptions = new MarkerOptions();
        markerOptions.latLng = this.latLng;
        markerOptions.gpsLatLng = this.gpsLatLng;
        markerOptions.title = this.title;
        markerOptions.snippet = this.snippet;
        markerOptions.anchorU = this.anchorU;
        markerOptions.anchorV = this.anchorV;
        markerOptions.zIndex = this.zIndex;
        markerOptions.isDraggable = this.isDraggable;
        markerOptions.isVisible = this.isVisible;
        markerOptions.a = this.a;
        markerOptions.perspective = this.perspective;
        markerOptions.offsetX = this.offsetX;
        markerOptions.offsetY = this.offsetY;
        markerOptions.bitmapDescriptors = this.bitmapDescriptors;
        markerOptions.period = this.period;
        markerOptions.isGps = this.isGps;
        markerOptions.isFlat = this.isFlat;
        markerOptions.isRotatingMode = this.isRotatingMode;
        markerOptions.angleOffset = this.angleOffset;
        markerOptions.screenX = this.screenX;
        markerOptions.screenY = this.screenY;
        markerOptions.isViewMode = this.isViewMode;
        markerOptions.alpha = this.alpha;
        markerOptions.autoOverturn = this.autoOverturn;
        markerOptions.infoWindowEnabled = this.infoWindowEnabled;
        markerOptions.dispLevel = this.dispLevel;
        markerOptions.rotate = this.rotate;
        markerOptions.isBelowMaskLayer = this.isBelowMaskLayer;
        markerOptions.updateFlags = this.updateFlags;
        return markerOptions;
    }

    protected void setScreenPosition(int n2, int n3) {
        this.screenX = n2;
        this.screenY = n3;
        this.isViewMode = true;
    }

    protected boolean isViewMode() {
        return this.isViewMode;
    }

    protected int getScreenX() {
        return this.screenX;
    }

    protected int getScreenY() {
        return this.screenY;
    }

    private void b() {
        try {
            if (this.isGps && this.latLng != null) {
                double[] dArray = Shifting.table_offset((double)this.latLng.longitude, (double)this.latLng.latitude);
                this.gpsLatLng = new LatLng(dArray[1], dArray[0]);
                this.updateFlags.gpsLatLngUpdate = true;
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    @Override
    public void resetUpdateFlags() {
        this.updateFlags.reset();
    }

    @Override
    public MarkerUpdateFlags getUpdateFlags() {
        return this.updateFlags;
    }

    @JBindingInclude
    protected static class MarkerUpdateFlags
    extends BaseOptions.BaseUpdateFlags {
        protected boolean latlngUpdate = false;
        protected boolean gpsLatLngUpdate = false;
        protected boolean bitmapDescriptorsUpdate = false;

        protected MarkerUpdateFlags() {
        }

        @Override
        public void reset() {
            super.reset();
            this.latlngUpdate = false;
            this.gpsLatLngUpdate = false;
            this.bitmapDescriptorsUpdate = false;
        }
    }
}

