/*
 * Decompiled with CFR 0.152.
 */
package com.amap.api.maps.utils;

import com.amap.adapter.util.Pair;
import com.amap.api.mapcore.util.es;
import com.amap.api.maps.AMapUtils;
import com.amap.api.maps.model.LatLng;
import com.autonavi.amap.mapcore.DPoint;
import java.util.ArrayList;
import java.util.List;

public class SpatialRelationUtil {
    public static final int MIN_POLYLINE_POINT_SIZE = 2;
    public static final int A_HALF_CIRCLE_DEGREE = 180;
    public static final int A_CIRCLE_DEGREE = 360;
    public static final int MIN_OFFSET_DEGREE = 50;

    public static Pair<Integer, LatLng> calShortestDistancePoint(List<LatLng> list, LatLng latLng, float f2, double d2) {
        try {
            if (list == null || latLng == null || list.size() == 0) {
                return null;
            }
            ArrayList<DPoint> arrayList = new ArrayList<DPoint>();
            int n2 = 0;
            for (LatLng pair2 : list) {
                arrayList.add(DPoint.obtain(pair2.latitude, pair2.longitude));
                if (pair2.equals(latLng)) {
                    return new Pair<Integer, LatLng>(n2, latLng);
                }
                ++n2;
            }
            DPoint dPoint = DPoint.obtain(latLng.latitude, latLng.longitude);
            Pair<Integer, DPoint> pair = SpatialRelationUtil.calShortestDistancePoint(arrayList, dPoint, f2);
            if (pair != null) {
                DPoint dPoint2 = (DPoint)pair.second;
                LatLng latLng2 = new LatLng(dPoint2.x, dPoint2.y);
                if ((double)AMapUtils.calculateLineDistance(latLng2, latLng) < d2) {
                    return new Pair<Integer, LatLng>((Integer)pair.first, new LatLng(((DPoint)pair.second).x, ((DPoint)pair.second).y));
                }
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return null;
    }

    public static Pair<Integer, LatLng> calShortestDistancePoint(List<LatLng> list, LatLng latLng) {
        try {
            if (list == null || latLng == null || list.size() == 0) {
                return null;
            }
            ArrayList<DPoint> arrayList = new ArrayList<DPoint>();
            int n2 = 0;
            for (LatLng pair2 : list) {
                arrayList.add(DPoint.obtain(pair2.latitude, pair2.longitude));
                if (pair2.equals(latLng)) {
                    return new Pair<Integer, LatLng>(n2, latLng);
                }
                ++n2;
            }
            DPoint dPoint = DPoint.obtain(latLng.latitude, latLng.longitude);
            Pair<Integer, DPoint> pair = SpatialRelationUtil.calShortestDistancePoint(arrayList, dPoint);
            if (pair != null) {
                return new Pair<Integer, LatLng>((Integer)pair.first, new LatLng(((DPoint)pair.second).x, ((DPoint)pair.second).y));
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return null;
    }

    public static Pair<Integer, DPoint> calShortestDistancePoint(List<DPoint> list, DPoint dPoint) {
        return SpatialRelationUtil.calShortestDistancePoint(list, dPoint, -1.0f);
    }

    public static Pair<Integer, DPoint> calShortestDistancePoint(List<DPoint> list, DPoint dPoint, float f2) {
        if (list == null || dPoint == null || list.size() == 0) {
            return null;
        }
        int n2 = list.size();
        if (n2 < 2) {
            return null;
        }
        Pair pair = null;
        DPoint dPoint2 = dPoint;
        DPoint dPoint3 = list.get(0);
        DPoint dPoint4 = null;
        double d2 = 0.0;
        int n3 = list.size();
        for (int i2 = 1; i2 <= n3 - 1; ++i2) {
            dPoint4 = list.get(i2);
            if (i2 == n3 - 1 && dPoint4.equals(dPoint)) {
                return new Pair<Integer, DPoint>(i2, dPoint);
            }
            boolean bl2 = SpatialRelationUtil.checkRotateIsMatch(dPoint3, dPoint4, f2);
            if (!bl2) {
                dPoint3 = dPoint4;
                continue;
            }
            if (dPoint3.equals(dPoint)) {
                return new Pair<Integer, DPoint>(i2 - 1, dPoint);
            }
            Pair<Double, DPoint> pair2 = SpatialRelationUtil.pointToSegDist(dPoint2.x, dPoint2.y, dPoint3.x, dPoint3.y, dPoint4.x, dPoint4.y);
            if (pair == null) {
                d2 = (Double)pair2.first;
                pair = new Pair(i2 - 1, pair2.second);
            } else if (d2 > (Double)pair2.first) {
                d2 = (Double)pair2.first;
                pair = new Pair(i2 - 1, pair2.second);
            }
            dPoint3 = dPoint4;
        }
        return pair;
    }

    private static boolean checkRotateIsMatch(DPoint dPoint, DPoint dPoint2, float f2) {
        if (f2 == -1.0f) {
            return true;
        }
        if (dPoint == null || dPoint2 == null) {
            return false;
        }
        float f3 = es.a(dPoint, dPoint2);
        float f4 = Math.abs((f3 += 360.0f) - f2) % 360.0f;
        if (f4 > 180.0f) {
            f4 = 360.0f - f4;
        }
        return f4 < 50.0f;
    }

    private static Pair<Double, DPoint> pointToSegDist(double d2, double d3, double d4, double d5, double d6, double d7) {
        double d8 = (d6 - d4) * (d2 - d4) + (d7 - d5) * (d3 - d5);
        if (d8 <= 0.0) {
            return new Pair<Double, DPoint>(Math.sqrt((d2 - d4) * (d2 - d4) + (d3 - d5) * (d3 - d5)), new DPoint(d4, d5));
        }
        double d9 = (d6 - d4) * (d6 - d4) + (d7 - d5) * (d7 - d5);
        if (d8 >= d9) {
            return new Pair<Double, DPoint>(Math.sqrt((d2 - d6) * (d2 - d6) + (d3 - d7) * (d3 - d7)), new DPoint(d6, d7));
        }
        double d10 = d8 / d9;
        double d11 = d4 + (d6 - d4) * d10;
        double d12 = d5 + (d7 - d5) * d10;
        double d13 = Math.sqrt((d2 - d11) * (d2 - d11) + (d12 - d3) * (d12 - d3));
        Pair<Double, DPoint> pair = new Pair<Double, DPoint>(d13, new DPoint(d11, d12));
        return pair;
    }
}

