/*
 * Decompiled with CFR 0.152.
 */
package com.amap.adapter.net;

import ohos.net.NetCapabilities;

public class NetworkInfo {
    private NetCapabilities netCapabilities;

    public NetworkInfo(NetCapabilities netCapabilities) {
        this.netCapabilities = netCapabilities;
    }

    public String getExtraInfo() {
        return "";
    }

    public int getType() {
        int n2 = -1;
        if (null != this.netCapabilities) {
            if (this.netCapabilities.hasBearer(1) || this.netCapabilities.hasBearer(5)) {
                n2 = 1;
            }
            if (this.netCapabilities.hasBearer(0)) {
                n2 = 0;
            }
        }
        return n2;
    }

    public String getTypeName() {
        int n2 = this.getType();
        String string = "UNKNOWN";
        switch (n2) {
            case 1: {
                string = "WIFI";
                break;
            }
            case 0: {
                string = "MOBILE";
                break;
            }
            default: {
                string = "UNKNOWN";
            }
        }
        return string;
    }

    public boolean isConnected() {
        if (null != this.netCapabilities) {
            return this.netCapabilities.hasCap(12);
        }
        return false;
    }

    public boolean isConnectedOrConnecting() {
        return !this.isConnected();
    }

    public State getState() {
        State state = State.UNKNOWN;
        if (null != this.netCapabilities) {
            state = this.netCapabilities.hasCap(16) || this.netCapabilities.hasCap(12) ? State.CONNECTED : State.DISCONNECTED;
        }
        return state;
    }

    public static enum State {
        CONNECTING,
        CONNECTED,
        SUSPENDED,
        DISCONNECTING,
        DISCONNECTED,
        UNKNOWN;

    }
}

