/*
 * Decompiled with CFR 0.152.
 */
package com.amap.adapter.view;

import com.amap.adapter.ClassPools;
import ohos.multimodalinput.event.TouchEvent;

public class MotionEvent {
    private TouchEvent touchEvent;
    private static final ClassPools.SynchronizedPool<MotionEvent> M_POOL = new ClassPools.SynchronizedPool(32);
    public static final int FLAG_IS_GENERATED_GESTURE = 1;
    public static final int ACTION_DOWN = 1;
    public static final int ACTION_UP = 2;
    public static final int ACTION_MASK = 255;
    public static final int ACTION_MOVE = 3;
    public static final int ACTION_POINTER_DOWN = 4;
    public static final int ACTION_POINTER_UP = 5;
    public static final int ACTION_CANCEL = 6;
    public static final int ACTION_POINTER_INDEX_MASK = 65280;
    public static final int ACTION_POINTER_INDEX_SHIFT = 8;
    private static final long TIME_MS = 1L;
    long EventTime;
    private int Flags;
    private int Action;
    private int PointerCount;
    private float[] Xs;
    private float[] Ys;
    private float RawX;
    private float RawY;
    private int[] PointerIds;
    private int ActionIndex;
    private long DownTime;

    public MotionEvent(TouchEvent touchEvent) {
        MotionEvent[] motionEventArray = new MotionEvent[]{this};
        MotionEvent.init(motionEventArray, touchEvent);
    }

    public void setTouchEvent(TouchEvent touchEvent) {
        MotionEvent[] motionEventArray = new MotionEvent[]{this};
        MotionEvent.init(motionEventArray, touchEvent);
    }

    public static MotionEvent obtain(MotionEvent motionEvent) {
        MotionEvent motionEvent2 = M_POOL.acquire();
        if (motionEvent2 == null) {
            motionEvent2 = new MotionEvent(motionEvent.touchEvent);
        } else {
            motionEvent2.touchEvent = motionEvent.touchEvent;
        }
        MotionEvent[] motionEventArray = new MotionEvent[]{motionEvent2};
        MotionEvent.init(motionEventArray, motionEvent.touchEvent);
        return motionEvent2;
    }

    private static void init(MotionEvent[] motionEventArray, TouchEvent touchEvent) {
        motionEventArray[0].touchEvent = touchEvent;
        motionEventArray[0].EventTime = touchEvent.getOccurredTime();
        motionEventArray[0].EventTime *= 1L;
        motionEventArray[0].Flags = touchEvent.getPhase();
        motionEventArray[0].Action = touchEvent.getAction();
        motionEventArray[0].PointerCount = touchEvent.getPointerCount();
        motionEventArray[0].Xs = new float[motionEventArray[0].PointerCount];
        motionEventArray[0].Ys = new float[motionEventArray[0].PointerCount];
        motionEventArray[0].PointerIds = new int[motionEventArray[0].PointerCount];
        for (int i2 = 0; i2 < motionEventArray[0].PointerCount; ++i2) {
            motionEventArray[0].Xs[i2] = touchEvent.getPointerPosition(i2).getX();
            motionEventArray[0].Ys[i2] = touchEvent.getPointerPosition(i2).getY();
            motionEventArray[0].PointerIds[i2] = touchEvent.getPointerId(i2);
        }
        motionEventArray[0].RawX = touchEvent.getPointerScreenPosition(0).getX();
        motionEventArray[0].RawY = touchEvent.getPointerScreenPosition(0).getY();
        motionEventArray[0].ActionIndex = touchEvent.getIndex();
        motionEventArray[0].DownTime = touchEvent.getStartTime();
        motionEventArray[0].DownTime *= 1L;
    }

    public float getX() {
        return this.Xs[0];
    }

    public float getY() {
        return this.Ys[0];
    }

    public long getEventTime() {
        return this.EventTime;
    }

    public int getFlags() {
        return this.Flags;
    }

    public int getAction() {
        return this.Action;
    }

    public int getPointerCount() {
        return this.PointerCount;
    }

    public float getX(int n2) {
        if (n2 < 0 || n2 >= this.PointerCount) {
            return -1.0f;
        }
        return this.Xs[n2];
    }

    public float getY(int n2) {
        if (n2 < 0 || n2 >= this.PointerCount) {
            return -1.0f;
        }
        return this.Ys[n2];
    }

    public float getRawX() {
        return this.RawX;
    }

    public float getRawY() {
        return this.RawY;
    }

    public int getPointerId(int n2) {
        return this.PointerIds[n2];
    }

    public void recycle() {
        M_POOL.release(this);
    }

    public int getActionIndex() {
        return (this.getAction() & 0xFF00) >> 8;
    }

    public int findPointerIndex(int n2) {
        for (int i2 = 0; i2 < this.PointerCount; ++i2) {
            if (n2 != this.PointerIds[i2]) continue;
            return i2;
        }
        return -1;
    }

    public float getPressure(int n2) {
        return 1.0f;
    }

    public long getDownTime() {
        return this.DownTime;
    }

    public String toString() {
        return "Action=" + this.Action + ",PointerCount=" + this.PointerCount + ",X=" + this.getX(0) + ",Y=" + this.getY(0) + ",EventTime=" + this.EventTime + ",DownTime=" + this.DownTime;
    }
}

