/*
 * Decompiled with CFR 0.152.
 */
package com.amap.api.maps.model;

import com.amap.adapter.graphics.Bitmap;
import com.amap.adapter.graphics.BitmapFactory;
import com.amap.adapter.os.Parcel;
import com.amap.adapter.os.Parcelable;
import com.amap.api.mapcore.util.es;
import com.amap.api.maps.model.BitmapDescriptor;
import com.amap.api.maps.model.BitmapDescriptorFactory;
import com.amap.api.maps.model.b;
import com.autonavi.ae.gmap.maploader.Pools;
import com.autonavi.base.amap.mapcore.jbinding.JBindingInclude;

@JBindingInclude
public final class Tile
implements Parcelable {
    public static final b CREATOR = new b();
    @JBindingInclude
    private final int mVersionCode;
    @JBindingInclude
    public final int width;
    @JBindingInclude
    public final int height;
    @JBindingInclude
    public final byte[] data;
    @JBindingInclude
    private BitmapDescriptor bitmapDescriptor;
    private static final Pools.SynchronizedPool<Tile> M_POOL = new Pools.SynchronizedPool(18);

    public static Tile obtain(int n2, int n3, byte[] byArray) {
        Tile tile = M_POOL.acquire();
        return tile != null ? tile : new Tile(n2, n3, byArray);
    }

    public static Tile obtain(int n2, int n3, byte[] byArray, Bitmap bitmap) {
        Tile tile = M_POOL.acquire();
        return tile != null ? tile : new Tile(n2, n3, byArray, bitmap);
    }

    public void recycle() {
        M_POOL.release(this);
    }

    Tile(int n2, int n3, int n4, byte[] byArray, Bitmap bitmap) {
        this.mVersionCode = n2;
        this.width = n3;
        this.height = n4;
        this.data = byArray;
        try {
            if (this.data != null) {
                Bitmap bitmap2 = new Bitmap(bitmap.getOsPixelMap());
                this.bitmapDescriptor = BitmapDescriptorFactory.fromBitmap(bitmap2);
                es.b(bitmap2);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    Tile(int n2, int n3, int n4, byte[] byArray) {
        this.mVersionCode = n2;
        this.width = n3;
        this.height = n4;
        this.data = byArray;
        try {
            if (this.data != null) {
                Bitmap bitmap = BitmapFactory.decodeByteArray(this.data, 0, this.data.length);
                this.bitmapDescriptor = BitmapDescriptorFactory.fromBitmap(bitmap);
                es.b(bitmap);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public Tile(int n2, int n3, byte[] byArray) {
        this(1, n2, n3, byArray);
    }

    public Tile(int n2, int n3, byte[] byArray, Bitmap bitmap) {
        this(1, n2, n3, byArray, bitmap);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel parcel, int n2) {
        parcel.writeInt(this.mVersionCode);
        parcel.writeInt(this.width);
        parcel.writeInt(this.height);
        parcel.writeByteArray(this.data);
    }
}

