/*
 * Decompiled with CFR 0.152.
 */
package com.autonavi.base.amap.mapcore.maploader;

import com.amap.adapter.content.Context;
import com.amap.adapter.text.TextUtils;
import com.amap.api.mapcore.util.dq;
import com.amap.api.mapcore.util.eq;
import com.amap.api.mapcore.util.es;
import com.amap.api.mapcore.util.ey;
import com.amap.api.mapcore.util.ez;
import com.amap.api.mapcore.util.fw;
import com.amap.api.mapcore.util.ga;
import com.amap.api.mapcore.util.gc;
import com.amap.api.mapcore.util.gi;
import com.amap.api.mapcore.util.hd;
import com.amap.api.mapcore.util.ia;
import com.amap.api.maps.MapsInitializer;
import com.autonavi.base.ae.gmap.GLMapEngine;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;

public class AMapLoader
implements ia.a {
    ADataRequestParam mDataRequestParam;
    GLMapEngine mGLMapEngine;
    private int mEngineID = 0;
    private static final int GET_METHOD = 0;
    private volatile boolean isCanceled = false;
    private static String mDiu;
    private boolean mRequestCancel = false;
    private ia downloadManager;
    private static final String NETWORK_RESPONSE_CODE_STRING = "\u7f51\u7edc\u5f02\u5e38\u72b6\u6001\u7801\uff1a";
    private long requestMapDataTimestamp = 0L;
    private long requestMapDataPackageSize = 0L;

    @Override
    public void onDownload(byte[] byArray, long l2) {
        if (byArray != null && this.mGLMapEngine != null && this.mDataRequestParam != null) {
            this.mGLMapEngine.receiveNetData(this.mEngineID, this.mDataRequestParam.handler, byArray, byArray.length);
        }
    }

    @Override
    public void onStop() {
        if (this.mGLMapEngine != null && this.mDataRequestParam != null) {
            this.mGLMapEngine.netStop(this.mEngineID, this.mDataRequestParam.handler, -1);
        }
        this.staticNetworkPerformance();
    }

    @Override
    public void onFinish() {
        if (this.mGLMapEngine != null && this.mDataRequestParam != null) {
            this.mGLMapEngine.finishDownLoad(this.mEngineID, this.mDataRequestParam.handler);
        }
        this.staticNetworkPerformance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onException(Throwable throwable) {
        int n2 = -1;
        try {
            int n3;
            String string = new String(throwable.getMessage().getBytes("UTF-8"), "UTF-8");
            if (!TextUtils.isEmpty(string) && (n3 = string.indexOf(NETWORK_RESPONSE_CODE_STRING)) != -1) {
                n2 = Integer.parseInt(string.substring(n3 + NETWORK_RESPONSE_CODE_STRING.length()));
            }
            if (this.mGLMapEngine != null && this.mDataRequestParam != null) {
                this.mGLMapEngine.netError(this.mEngineID, this.mDataRequestParam.handler, -1, n2);
            }
            if (this.mGLMapEngine != null) {
                eq.a(this.mGLMapEngine.getContext(), this.mGLMapEngine.hashCode(), this.mGLMapEngine.isNetworkConnected() ? 0 : 1, this.getNetworkFailedReason(throwable.getMessage()));
            }
        }
        catch (Throwable throwable2) {
            if (this.mGLMapEngine != null && this.mDataRequestParam != null) {
                this.mGLMapEngine.netError(this.mEngineID, this.mDataRequestParam.handler, -1, n2);
            }
            if (this.mGLMapEngine != null) {
                eq.a(this.mGLMapEngine.getContext(), this.mGLMapEngine.hashCode(), this.mGLMapEngine.isNetworkConnected() ? 0 : 1, this.getNetworkFailedReason(throwable.getMessage()));
            }
        }
        catch (Throwable throwable3) {
            if (this.mGLMapEngine != null && this.mDataRequestParam != null) {
                this.mGLMapEngine.netError(this.mEngineID, this.mDataRequestParam.handler, -1, n2);
            }
            if (this.mGLMapEngine != null) {
                eq.a(this.mGLMapEngine.getContext(), this.mGLMapEngine.hashCode(), this.mGLMapEngine.isNetworkConnected() ? 0 : 1, this.getNetworkFailedReason(throwable.getMessage()));
            }
            throw throwable3;
        }
        hd.c(throwable, "AMapLoader", "download onException");
        ez.b(ey.e, "map loader exception " + throwable.getMessage());
    }

    public AMapLoader(int n2, GLMapEngine gLMapEngine, ADataRequestParam aDataRequestParam) {
        this.mDataRequestParam = aDataRequestParam;
        this.mEngineID = n2;
        this.mGLMapEngine = gLMapEngine;
        this.mRequestCancel = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doRequest() {
        if (this.mRequestCancel) {
            return;
        }
        String string = this.mDataRequestParam.requestBaseUrl;
        String string2 = this.mDataRequestParam.requestUrl;
        boolean bl2 = true;
        if (!string.endsWith("?")) {
            string = string + "?";
        }
        if (bl2) {
            string2 = string2.replaceAll(";", this.getEncodeRequestParams(";").toString());
        }
        boolean bl3 = false;
        if (string != null && string.contains("http://m5.amap.com/")) {
            bl3 = true;
        }
        string2 = this.getRequestParams(string2, bl3, this.mDataRequestParam.nRequestType);
        StringBuffer stringBuffer = new StringBuffer();
        if (this.mDataRequestParam.nRequestType == 0) {
            stringBuffer.append(string2);
            stringBuffer.append("&csid=" + UUID.randomUUID().toString());
        } else {
            stringBuffer.append("csid=" + UUID.randomUUID().toString());
        }
        try {
            string = string + this.generateQueryString(this.mGLMapEngine.getContext(), stringBuffer.toString());
            AMapGridDownloadRequest aMapGridDownloadRequest = new AMapGridDownloadRequest(this.mGLMapEngine.getContext(), string, this.mGLMapEngine.getUserAgent());
            aMapGridDownloadRequest.setConnectionTimeout(30000);
            aMapGridDownloadRequest.setSoTimeout(30000);
            if (this.mDataRequestParam.nRequestType != 0) {
                byte[] byArray = string2.getBytes("UTF-8");
                aMapGridDownloadRequest.setPostEntityBytes(byArray);
            }
            this.requestMapDataTimestamp = System.currentTimeMillis();
            this.requestMapDataPackageSize = aMapGridDownloadRequest.getEntityBytes() == null ? 0L : (long)aMapGridDownloadRequest.getEntityBytes().length;
            this.downloadManager = new ia(aMapGridDownloadRequest, 0L, -1L, MapsInitializer.getProtocol() == 2);
            this.downloadManager.a(this);
        }
        catch (Throwable throwable) {
            this.onException(throwable);
        }
        finally {
            this.doCancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doCancel() {
        this.mRequestCancel = true;
        if (null != this.downloadManager && !this.isCanceled) {
            ia ia2 = this.downloadManager;
            synchronized (ia2) {
                try {
                    this.isCanceled = true;
                    this.downloadManager.a();
                    this.mGLMapEngine.setMapLoaderToTask(this.mEngineID, this.mDataRequestParam.handler, null);
                }
                catch (Throwable throwable) {
                    hd.c(throwable, "AMapLoader", "doCancel");
                }
            }
        }
    }

    private String getEncodeRequestParams(String string) {
        String string2 = null;
        try {
            string2 = URLEncoder.encode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
        return string2;
    }

    public String getDeviceId(Context context) {
        if (null != context) {
            return gc.w(context);
        }
        return null;
    }

    protected String getRequestParams(String string, boolean bl2, int n2) {
        if (null == mDiu) {
            mDiu = this.getDeviceId(this.mGLMapEngine.getContext());
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        if (bl2) {
            stringBuffer.append("&channel=amap7&div=GNaviMap");
            stringBuffer.append("&diu=").append(mDiu);
        } else {
            stringBuffer.append("&channel=amapapi");
            stringBuffer.append("&div=GNaviMap");
            stringBuffer.append("&diu=").append(mDiu);
        }
        return stringBuffer.toString();
    }

    private String generateQueryString(Context context, String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        String string2 = fw.g(this.mGLMapEngine.getContext());
        try {
            string2 = URLEncoder.encode(string2, "UTF-8");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        stringBuffer.append("&key=").append(string2);
        String string3 = this.sortReEncoderParams(stringBuffer.toString());
        String string4 = ga.a();
        stringBuffer.append("&ts=" + string4);
        stringBuffer.append("&scode=" + ga.a(context, string4, string3));
        stringBuffer.append("&dip=").append("16300");
        return stringBuffer.toString();
    }

    private String sortReEncoderParams(String string) {
        Object[] objectArray = string.split("&");
        Arrays.sort(objectArray);
        StringBuffer stringBuffer = new StringBuffer();
        for (Object object : objectArray) {
            String string2 = this.strReEncoder((String)object);
            stringBuffer.append(string2);
            stringBuffer.append("&");
        }
        Object object = stringBuffer.toString();
        if (((String)object).length() > 1) {
            object = (String)((String)object).subSequence(0, ((String)object).length() - 1);
            return object;
        }
        return string;
    }

    private String strReEncoder(String string) {
        if (string == null) {
            return string;
        }
        try {
            return URLDecoder.decode(string, "utf-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            hd.c(unsupportedEncodingException, "AbstractProtocalHandler", "strReEncoder");
        }
        catch (Exception exception) {
            hd.c(exception, "AbstractProtocalHandler", "strReEncoderException");
        }
        return "";
    }

    private String getNetworkFailedReason(String string) {
        return !this.mGLMapEngine.isNetworkConnected() ? "\u65e0\u7f51\u7edc" : string;
    }

    private void staticNetworkPerformance() {
        if (this.mGLMapEngine != null) {
            eq.a(this.mGLMapEngine.getContext(), this.mGLMapEngine.hashCode(), System.currentTimeMillis() - this.requestMapDataTimestamp, this.requestMapDataPackageSize);
        }
    }

    public static class AMapGridDownloadRequest
    extends dq {
        private final Context mContext;
        private String sUrl;
        private byte[] postEntityBytes;
        private String userAgent;

        public AMapGridDownloadRequest(Context context, String string, String string2) {
            this.mContext = context;
            this.sUrl = string;
            this.userAgent = string2;
        }

        @Override
        public Map<String, String> getRequestHead() {
            gi gi2 = es.e();
            String string = null;
            if (gi2 != null) {
                string = gi2.b();
            }
            String string2 = fw.g(this.mContext);
            try {
                string2 = URLEncoder.encode(string2, "UTF-8");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            Hashtable<String, String> hashtable = new Hashtable<String, String>(16);
            hashtable.put("User-Agent", this.userAgent);
            hashtable.put("platinfo", String.format(Locale.US, "platform=Android&sdkversion=%s&product=%s", string, "3dmap"));
            hashtable.put("x-INFO", ga.a(this.mContext));
            hashtable.put("key", string2);
            hashtable.put("logversion", "2.1");
            return hashtable;
        }

        @Override
        public Map<String, String> getParams() {
            return null;
        }

        @Override
        public String getURL() {
            return this.sUrl;
        }

        @Override
        public String getIPV6URL() {
            return es.a(this.getURL());
        }

        @Override
        public boolean isSupportIPV6() {
            return true;
        }

        public void setPostEntityBytes(byte[] byArray) {
            this.postEntityBytes = byArray;
        }

        @Override
        public byte[] getEntityBytes() {
            return this.postEntityBytes;
        }
    }

    public static class ADataRequestParam {
        public String requestUrl;
        public long handler;
        public int nRequestType;
        public byte[] enCodeString;
        public int nCompress;
        public String requestBaseUrl;
    }
}

