/*
 * Decompiled with CFR 0.152.
 */
package com.amap.adapter.graphics;

import com.amap.adapter.content.res.Resources;
import com.amap.adapter.graphics.Bitmap;
import java.io.File;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.InputStream;
import ohos.global.resource.NotExistException;
import ohos.media.image.ImageSource;

public class BitmapFactory {
    public static Bitmap decodeByteArray(byte[] byArray, int n2, int n3) {
        ImageSource.SourceOptions sourceOptions = new ImageSource.SourceOptions();
        ImageSource imageSource = ImageSource.create((byte[])byArray, (int)n2, (int)n3, (ImageSource.SourceOptions)sourceOptions);
        if (imageSource != null) {
            ImageSource.DecodingOptions decodingOptions = new ImageSource.DecodingOptions();
            return new Bitmap(imageSource.createPixelmap(decodingOptions));
        }
        return null;
    }

    public static Bitmap decodeStream(InputStream inputStream) {
        ImageSource.SourceOptions sourceOptions = new ImageSource.SourceOptions();
        ImageSource imageSource = ImageSource.create((InputStream)inputStream, (ImageSource.SourceOptions)sourceOptions);
        if (imageSource != null) {
            ImageSource.DecodingOptions decodingOptions = new ImageSource.DecodingOptions();
            return new Bitmap(imageSource.createPixelmap(decodingOptions));
        }
        return null;
    }

    public static Bitmap decodeResource(Resources resources, int n2, Options options) {
        if (resources == null) {
            return null;
        }
        ImageSource.SourceOptions sourceOptions = new ImageSource.SourceOptions();
        ImageSource imageSource = null;
        try {
            imageSource = ImageSource.create((InputStream)resources.openRawResource(n2), (ImageSource.SourceOptions)sourceOptions);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (NotExistException notExistException) {
            notExistException.printStackTrace();
        }
        if (imageSource != null) {
            ImageSource.DecodingOptions decodingOptions = new ImageSource.DecodingOptions();
            return new Bitmap(imageSource.createPixelmap(decodingOptions));
        }
        return null;
    }

    public static Bitmap decodeFileDescriptor(FileDescriptor fileDescriptor, Object object, Options options) {
        ImageSource.SourceOptions sourceOptions = new ImageSource.SourceOptions();
        ImageSource imageSource = ImageSource.create((FileDescriptor)fileDescriptor, (ImageSource.SourceOptions)sourceOptions);
        if (imageSource != null) {
            ImageSource.DecodingOptions decodingOptions = new ImageSource.DecodingOptions();
            return new Bitmap(imageSource.createPixelmap(decodingOptions));
        }
        return null;
    }

    public static Bitmap decodeFile(String string, Options options) {
        ImageSource.SourceOptions sourceOptions = new ImageSource.SourceOptions();
        ImageSource imageSource = ImageSource.create((File)new File(string), (ImageSource.SourceOptions)sourceOptions);
        if (imageSource != null) {
            ImageSource.DecodingOptions decodingOptions = new ImageSource.DecodingOptions();
            return new Bitmap(imageSource.createPixelmap(decodingOptions));
        }
        return null;
    }

    public static Bitmap decodeFile(String string) {
        ImageSource.SourceOptions sourceOptions = new ImageSource.SourceOptions();
        ImageSource imageSource = ImageSource.create((File)new File(string), (ImageSource.SourceOptions)sourceOptions);
        if (imageSource != null) {
            ImageSource.DecodingOptions decodingOptions = new ImageSource.DecodingOptions();
            return new Bitmap(imageSource.createPixelmap(decodingOptions));
        }
        return null;
    }

    public static Bitmap decodeStream(InputStream inputStream, Object object, Options options) {
        ImageSource.SourceOptions sourceOptions = new ImageSource.SourceOptions();
        ImageSource imageSource = ImageSource.create((InputStream)inputStream, (ImageSource.SourceOptions)sourceOptions);
        if (imageSource != null) {
            ImageSource.DecodingOptions decodingOptions = new ImageSource.DecodingOptions();
            return new Bitmap(imageSource.createPixelmap(decodingOptions));
        }
        return null;
    }

    public static class Options {
        public int inDensity;
        public boolean inJustDecodeBounds;
        public boolean inMutable;
        public int inSampleSize;
        public int inTargetDensity;
        public int outHeight;
        public int outWidth;
    }
}

