/*
 * Decompiled with CFR 0.152.
 */
package com.autonavi.base.ae.gmap.glanimation;

import com.amap.adapter.os.SystemClock;
import com.autonavi.amap.mapcore.IPoint;
import com.autonavi.base.ae.gmap.GLMapState;
import com.autonavi.base.ae.gmap.glanimation.AbstractAdglAnimation;
import com.autonavi.base.ae.gmap.glanimation.AbstractAdglAnimationParam2V;

public class AdglMapAnimFling
extends AbstractAdglAnimation {
    private float velocityX;
    private float velocityY;
    private IPoint fromCenter;
    private AbstractAdglAnimationParam2V moveParam;
    private boolean hasCheckParams;
    private boolean needMove;
    private int screenCenterX;
    private int screenCenterY;
    private int lastMoveX;
    private int lastMoveY;

    public AdglMapAnimFling(int n2, int n3, int n4) {
        this.screenCenterX = n3;
        this.screenCenterY = n4;
        this.lastMoveX = n3;
        this.lastMoveY = n4;
        this.moveParam = null;
        this.reset();
        this.duration = n2;
    }

    public void reset() {
        if (this.moveParam != null) {
            this.moveParam.reset();
        }
        this.velocityX = 0.0f;
        this.velocityY = 0.0f;
        this.needMove = false;
        this.hasCheckParams = false;
    }

    public void setPositionAndVelocity(float f2, float f3) {
        this.moveParam = null;
        this.velocityX = f2;
        this.velocityY = f3;
        this.moveParam = new AbstractAdglAnimationParam2V();
        this.moveParam.setInterpolatorType(2, 1.2f);
        this.needMove = false;
        this.hasCheckParams = false;
    }

    public void commitAnimationold(Object object) {
        GLMapState gLMapState = (GLMapState)object;
        if (gLMapState == null) {
            return;
        }
        this.hasCheckParams = false;
        this.isOver = true;
        float f2 = (float)Math.sqrt(this.velocityX * this.velocityX + this.velocityY * this.velocityY);
        float f3 = f2 / 1000.0f;
        if (f3 >= 0.1f) {
            float f4 = 0.02f * f3;
            if (this.fromCenter == null) {
                this.fromCenter = IPoint.obtain();
            }
            gLMapState.getMapGeoCenter(this.fromCenter);
            this.isOver = false;
            this.moveParam.setFromValue(this.screenCenterX, this.screenCenterY);
            this.moveParam.setToValue((float)this.screenCenterX - this.velocityX * f4, (float)this.screenCenterY - this.velocityY * f4);
            this.needMove = this.moveParam.needToCaculate();
        }
        if (this.needMove) {
            // empty if block
        }
        this.hasCheckParams = true;
        this.startTime = SystemClock.uptimeMillis();
    }

    public void commitAnimation(Object object) {
        GLMapState gLMapState = (GLMapState)object;
        if (gLMapState == null) {
            return;
        }
        this.hasCheckParams = false;
        this.isOver = true;
        int n2 = (int)(this.velocityX * (float)this.duration / 2000.0f);
        int n3 = (int)(this.velocityY * (float)this.duration / 2000.0f);
        if (Math.abs(n2) != 0 && Math.abs(n3) != 0) {
            if (this.fromCenter == null) {
                this.fromCenter = IPoint.obtain();
            }
            gLMapState.getMapGeoCenter(this.fromCenter);
            this.isOver = false;
            this.moveParam.setFromValue(this.screenCenterX, this.screenCenterY);
            this.moveParam.setToValue(this.screenCenterX - n2, this.screenCenterY - n3);
            this.needMove = this.moveParam.needToCaculate();
        }
        if (this.needMove) {
            // empty if block
        }
        this.hasCheckParams = true;
        this.startTime = SystemClock.uptimeMillis();
    }

    @Override
    public void doAnimation(Object object) {
        GLMapState gLMapState = (GLMapState)object;
        if (gLMapState == null) {
            return;
        }
        if (!this.hasCheckParams) {
            this.commitAnimation(object);
        }
        if (this.isOver) {
            return;
        }
        long l2 = SystemClock.uptimeMillis();
        this.offsetTime = l2 - this.startTime;
        float f2 = (float)this.offsetTime / (float)this.duration;
        if (f2 > 1.0f) {
            f2 = 1.0f;
            this.isOver = true;
        }
        if (f2 >= 0.0f && f2 <= 1.0f && this.needMove) {
            this.moveParam.setNormalizedTime(f2);
            int n2 = (int)this.moveParam.getCurXValue();
            int n3 = (int)this.moveParam.getCurYValue();
            IPoint iPoint = IPoint.obtain();
            gLMapState.screenToP20Point(this.screenCenterX + n2 - this.lastMoveX, this.screenCenterY + n3 - this.lastMoveY, iPoint);
            gLMapState.setMapGeoCenter(iPoint.x, iPoint.y);
            this.lastMoveX = n2;
            this.lastMoveY = n3;
            iPoint.recycle();
        }
    }
}

