/*
 * Decompiled with CFR 0.152.
 */
package com.amap.api.maps;

import com.amap.adapter.graphics.Point;
import com.amap.adapter.util.Log;
import com.amap.api.mapcore.util.af;
import com.amap.api.maps.CameraUpdate;
import com.amap.api.maps.model.CameraPosition;
import com.amap.api.maps.model.LatLng;
import com.amap.api.maps.model.LatLngBounds;
import com.autonavi.amap.mapcore.IPoint;
import com.autonavi.amap.mapcore.VirtualEarthProjection;

public final class CameraUpdateFactory {
    private static final String CLASSNAME = "CameraUpdateFactory";

    public static CameraUpdate zoomIn() {
        return new CameraUpdate(af.a());
    }

    public static CameraUpdate zoomOut() {
        return new CameraUpdate(af.b());
    }

    public static CameraUpdate scrollBy(float f2, float f3) {
        return new CameraUpdate(af.a(f2, f3));
    }

    public static CameraUpdate zoomTo(float f2) {
        return new CameraUpdate(af.a(f2));
    }

    public static CameraUpdate zoomBy(float f2) {
        return new CameraUpdate(af.b(f2));
    }

    public static CameraUpdate zoomBy(float f2, Point point) {
        return new CameraUpdate(af.a(f2, point));
    }

    public static CameraUpdate newCameraPosition(CameraPosition cameraPosition) {
        if (cameraPosition == null) {
            Log.w(CLASSNAME, "cameraPosition is null");
            return new CameraUpdate(af.c());
        }
        return new CameraUpdate(af.a(cameraPosition));
    }

    public static CameraUpdate newLatLng(LatLng latLng) {
        if (latLng == null) {
            Log.w(CLASSNAME, "latLng is null");
            return new CameraUpdate(af.c());
        }
        return new CameraUpdate(af.a(latLng));
    }

    public static CameraUpdate newLatLngZoom(LatLng latLng, float f2) {
        if (latLng == null) {
            Log.w(CLASSNAME, "target is null");
            return new CameraUpdate(af.c());
        }
        return new CameraUpdate(af.a(latLng, f2));
    }

    public static CameraUpdate newLatLngBounds(LatLngBounds latLngBounds, int n2) {
        if (latLngBounds == null) {
            Log.w(CLASSNAME, "bounds is null");
            return new CameraUpdate(af.c());
        }
        return new CameraUpdate(af.a(latLngBounds, n2));
    }

    public static CameraUpdate changeLatLng(LatLng latLng) {
        if (latLng == null) {
            Log.w(CLASSNAME, "target is null");
            return new CameraUpdate(af.c());
        }
        Point point = VirtualEarthProjection.latLongToPixels(latLng.latitude, latLng.longitude, 20);
        return new CameraUpdate(af.a(point));
    }

    public static CameraUpdate changeBearing(float f2) {
        return new CameraUpdate(af.d(f2 % 360.0f));
    }

    public static CameraUpdate changeBearingGeoCenter(float f2, IPoint iPoint) {
        if (iPoint == null) {
            Log.w(CLASSNAME, "geoPoint is null");
            return new CameraUpdate(af.c());
        }
        return new CameraUpdate(af.b(f2 % 360.0f, new Point(iPoint.x, iPoint.y)));
    }

    public static CameraUpdate changeTilt(float f2) {
        return new CameraUpdate(af.c(f2));
    }

    public static CameraUpdate newLatLngBounds(LatLngBounds latLngBounds, int n2, int n3, int n4) {
        if (latLngBounds == null) {
            Log.w(CLASSNAME, "bounds is null");
            return new CameraUpdate(af.c());
        }
        return new CameraUpdate(af.a(latLngBounds, n2, n3, n4));
    }

    public static CameraUpdate newLatLngBoundsRect(LatLngBounds latLngBounds, int n2, int n3, int n4, int n5) {
        if (latLngBounds == null) {
            Log.w(CLASSNAME, "bounds is null");
            return new CameraUpdate(af.c());
        }
        return new CameraUpdate(af.a(latLngBounds, n2, n3, n4, n5));
    }
}

