/*
 * Decompiled with CFR 0.152.
 */
package com.amap.api.maps.model;

import com.amap.adapter.os.Parcel;
import com.amap.adapter.os.Parcelable;
import com.amap.api.mapcore.util.es;
import com.amap.api.maps.model.AMapPara;
import com.amap.api.maps.model.BaseHoleOptions;
import com.amap.api.maps.model.BaseOptions;
import com.amap.api.maps.model.CircleHoleOptions;
import com.amap.api.maps.model.LatLng;
import com.amap.api.maps.model.PolygonHoleOptions;
import com.amap.api.maps.model.PolygonOptionsCreator;
import com.autonavi.base.amap.mapcore.jbinding.JBindingExclude;
import com.autonavi.base.amap.mapcore.jbinding.JBindingInclude;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@JBindingInclude
public final class PolygonOptions
extends BaseOptions
implements Parcelable,
Cloneable {
    @JBindingExclude
    public static final PolygonOptionsCreator CREATOR = new PolygonOptionsCreator();
    private final List<LatLng> points;
    private float strokeWidth = 10.0f;
    private int strokeColor = -16777216;
    private int fillColor = -16777216;
    private float zIndex = 0.0f;
    private boolean isVisible = true;
    private List<BaseHoleOptions> holeOptions;
    @JBindingExclude
    String a;
    private boolean isUsePolylineStroke = true;
    @JBindingExclude
    private AMapPara.LineJoinType lineJoinType = AMapPara.LineJoinType.LineJoinBevel;
    private int nLineCapType = 3;
    private int nLineJoinType = 0;
    private PolygonUpdateFlags updateFlags = new PolygonUpdateFlags();

    public PolygonOptions() {
        this.points = new ArrayList<LatLng>();
        this.holeOptions = new ArrayList<BaseHoleOptions>();
        this.type = "PolygonOptions";
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel parcel, int n2) {
        parcel.writeTypedList(this.points);
        parcel.writeFloat(this.strokeWidth);
        parcel.writeInt(this.strokeColor);
        parcel.writeInt(this.fillColor);
        parcel.writeFloat(this.zIndex);
        parcel.writeByte((byte)(this.isVisible ? 1 : 0));
        parcel.writeString(this.a);
        parcel.writeList(this.holeOptions);
        parcel.writeInt(this.lineJoinType.getTypeValue());
        parcel.writeByte((byte)(this.isUsePolylineStroke ? 1 : 0));
    }

    public PolygonOptions add(LatLng latLng) {
        try {
            this.points.add(latLng);
            this.updateFlags.isPointsUpdated = true;
            this.a();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return this;
    }

    public PolygonOptions add(LatLng ... latLngArray) {
        try {
            if (latLngArray != null) {
                this.points.addAll(Arrays.asList(latLngArray));
                this.updateFlags.isPointsUpdated = true;
                this.a();
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return this;
    }

    public PolygonOptions addAll(Iterable<LatLng> iterable) {
        try {
            if (iterable != null) {
                for (LatLng latLng : iterable) {
                    this.points.add(latLng);
                }
                this.a();
                this.updateFlags.isPointsUpdated = true;
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return this;
    }

    public void setPoints(List<LatLng> list) {
        try {
            this.points.clear();
            if (list == null) {
                return;
            }
            this.points.addAll(list);
            this.a();
            this.updateFlags.isPointsUpdated = true;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public void setHoleOptions(List<BaseHoleOptions> list) {
        try {
            this.holeOptions.clear();
            if (list != null) {
                this.holeOptions.addAll(list);
            }
            this.a();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    private void a() {
        if (this.holeOptions != null) {
            ArrayList<BaseHoleOptions> arrayList = new ArrayList<BaseHoleOptions>();
            List<BaseHoleOptions> list = this.holeOptions;
            for (int i2 = 0; i2 < list.size(); ++i2) {
                BaseHoleOptions baseHoleOptions;
                BaseHoleOptions baseHoleOptions2 = list.get(i2);
                if (baseHoleOptions2 instanceof PolygonHoleOptions) {
                    baseHoleOptions = (PolygonHoleOptions)baseHoleOptions2;
                    if (!es.b(this.getPoints(), baseHoleOptions) || es.a(arrayList, baseHoleOptions)) continue;
                    arrayList.add(baseHoleOptions);
                    continue;
                }
                if (!(baseHoleOptions2 instanceof CircleHoleOptions)) continue;
                baseHoleOptions = (CircleHoleOptions)baseHoleOptions2;
                if (!es.a(this.getPoints(), arrayList, (CircleHoleOptions)baseHoleOptions) || es.a(arrayList, (CircleHoleOptions)baseHoleOptions)) continue;
                arrayList.add(baseHoleOptions);
            }
            this.holeOptions.clear();
            this.holeOptions.addAll(arrayList);
            this.updateFlags.isHoleOptionsUpdated = true;
        }
    }

    public PolygonOptions addHoles(BaseHoleOptions ... baseHoleOptionsArray) {
        try {
            if (baseHoleOptionsArray == null) {
                return this;
            }
            this.holeOptions.addAll(Arrays.asList(baseHoleOptionsArray));
            this.a();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return this;
    }

    public PolygonOptions addHoles(Iterable<BaseHoleOptions> iterable) {
        try {
            if (iterable == null) {
                return this;
            }
            for (BaseHoleOptions baseHoleOptions : iterable) {
                this.holeOptions.add(baseHoleOptions);
            }
            this.a();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return this;
    }

    public PolygonOptions strokeWidth(float f2) {
        this.strokeWidth = f2;
        return this;
    }

    public PolygonOptions strokeColor(int n2) {
        this.strokeColor = n2;
        return this;
    }

    public PolygonOptions fillColor(int n2) {
        this.fillColor = n2;
        return this;
    }

    public PolygonOptions zIndex(float f2) {
        if (this.zIndex != this.zIndex) {
            this.updateFlags.zIndexUpdate = true;
        }
        this.zIndex = f2;
        return this;
    }

    public PolygonOptions visible(boolean bl2) {
        this.isVisible = bl2;
        return this;
    }

    public List<LatLng> getPoints() {
        return this.points;
    }

    public float getStrokeWidth() {
        return this.strokeWidth;
    }

    public int getStrokeColor() {
        return this.strokeColor;
    }

    public int getFillColor() {
        return this.fillColor;
    }

    public float getZIndex() {
        return this.zIndex;
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    public List<BaseHoleOptions> getHoleOptions() {
        return this.holeOptions;
    }

    public PolygonOptions lineJoinType(AMapPara.LineJoinType lineJoinType) {
        if (lineJoinType != null) {
            this.lineJoinType = lineJoinType;
            this.nLineJoinType = lineJoinType.getTypeValue();
        }
        return this;
    }

    public AMapPara.LineJoinType getLineJoinType() {
        return this.lineJoinType;
    }

    public PolygonOptions usePolylineStroke(boolean bl2) {
        this.isUsePolylineStroke = bl2;
        return this;
    }

    public boolean isUsePolylineStroke() {
        return this.isUsePolylineStroke;
    }

    public PolygonOptions clone() {
        try {
            super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace();
        }
        PolygonOptions polygonOptions = new PolygonOptions();
        polygonOptions.points.addAll(this.points);
        polygonOptions.strokeWidth = this.strokeWidth;
        polygonOptions.strokeColor = this.strokeColor;
        polygonOptions.fillColor = this.fillColor;
        polygonOptions.zIndex = this.zIndex;
        polygonOptions.isVisible = this.isVisible;
        polygonOptions.holeOptions = this.holeOptions;
        polygonOptions.a = this.a;
        polygonOptions.isUsePolylineStroke = this.isUsePolylineStroke;
        polygonOptions.lineJoinType = this.lineJoinType;
        polygonOptions.nLineCapType = this.nLineCapType;
        polygonOptions.nLineJoinType = this.nLineJoinType;
        polygonOptions.updateFlags = this.updateFlags;
        return polygonOptions;
    }

    @Override
    public void resetUpdateFlags() {
        this.updateFlags.reset();
    }

    @Override
    public PolygonUpdateFlags getUpdateFlags() {
        return this.updateFlags;
    }

    @JBindingInclude
    protected static class PolygonUpdateFlags
    extends BaseOptions.BaseUpdateFlags {
        protected boolean isPointsUpdated = false;
        protected boolean isHoleOptionsUpdated = false;

        protected PolygonUpdateFlags() {
        }

        @Override
        public void reset() {
            super.reset();
            this.isPointsUpdated = false;
            this.isHoleOptionsUpdated = false;
        }
    }
}

