/*
 * Decompiled with CFR 0.152.
 */
package com.autonavi.base.amap.mapcore.maploader;

import com.amap.adapter.content.BroadcastReceiver;
import com.amap.adapter.content.Context;
import com.amap.adapter.content.Intent;
import com.amap.adapter.content.IntentFilter;
import com.amap.adapter.net.ConnectivityManager;
import com.amap.adapter.net.NetworkInfo;
import java.lang.ref.WeakReference;

public class NetworkState {
    private boolean isNetReceiverRegistered = false;
    private NetworkChangeListener mNetworkListener;
    private MyBroadcastReceiver netChangeReceiver = null;

    public void setNetworkListener(NetworkChangeListener networkChangeListener) {
        this.mNetworkListener = networkChangeListener;
    }

    public void registerNetChangeReceiver(Context context, boolean bl2) {
        if (bl2) {
            if (!this.isNetReceiverRegistered) {
                IntentFilter intentFilter = new IntentFilter();
                intentFilter.addAction(2);
                if (this.netChangeReceiver == null) {
                    this.netChangeReceiver = new MyBroadcastReceiver(this.mNetworkListener);
                }
                context.registerReceiver(this.netChangeReceiver, intentFilter);
            }
        } else if (this.isNetReceiverRegistered && this.netChangeReceiver != null) {
            context.unregisterReceiver(this.netChangeReceiver);
            this.netChangeReceiver = null;
        }
        this.isNetReceiverRegistered = bl2;
    }

    public static boolean isNetworkConnected(Context context) {
        NetworkInfo networkInfo = NetworkState.getActiveNetworkInfo(context);
        return null != networkInfo && networkInfo.isConnected();
    }

    public static NetworkInfo getActiveNetworkInfo(Context context) {
        try {
            ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
            if (connectivityManager == null) {
                return null;
            }
            NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
            if (networkInfo != null && networkInfo.isConnected()) {
                return networkInfo;
            }
            NetworkInfo[] networkInfoArray = connectivityManager.getAllNetworkInfo();
            if (networkInfoArray == null) {
                return null;
            }
            for (int i2 = 0; i2 < networkInfoArray.length; ++i2) {
                if (networkInfoArray[i2] == null || !networkInfoArray[i2].isConnected()) continue;
                networkInfo = networkInfoArray[i2];
                break;
            }
            return networkInfo;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    static class MyBroadcastReceiver
    extends BroadcastReceiver {
        WeakReference<NetworkChangeListener> reference = null;

        public MyBroadcastReceiver(NetworkChangeListener networkChangeListener) {
            WeakReference<NetworkChangeListener> weakReference = new WeakReference<NetworkChangeListener>(networkChangeListener);
            this.reference = weakReference;
        }

        @Override
        public void onReceive(Context context, Intent intent) {
            if (null != this.reference && this.reference.get() != null) {
                ((NetworkChangeListener)this.reference.get()).networkStateChanged(context);
            }
        }
    }

    public static interface NetworkChangeListener {
        public void networkStateChanged(Context var1);
    }
}

