/*
 * Decompiled with CFR 0.152.
 */
package com.amap.api.maps.model;

import com.amap.adapter.graphics.Color;
import com.amap.adapter.os.Parcel;
import com.amap.adapter.os.Parcelable;
import com.amap.api.maps.model.BaseOptions;
import com.amap.api.maps.model.LatLng;
import com.amap.api.maps.model.NavigateArrowOptionsCreator;
import com.autonavi.base.amap.mapcore.jbinding.JBindingExclude;
import com.autonavi.base.amap.mapcore.jbinding.JBindingInclude;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@JBindingInclude
public final class NavigateArrowOptions
extends BaseOptions
implements Parcelable,
Cloneable {
    @JBindingExclude
    public static final NavigateArrowOptionsCreator CREATOR = new NavigateArrowOptionsCreator();
    private final List<LatLng> points;
    private float width = 10.0f;
    private int topColor = Color.argb(221, 87, 235, 204);
    private int sideColor = Color.argb(170, 0, 172, 146);
    private float zIndex = 0.0f;
    private boolean isVisible = true;
    private boolean is3DModel = false;
    @JBindingExclude
    String a;
    private int arrowLineInnerResId = 111;
    private int arrowLineOuterResId = 222;
    private int arrowLineShadowResId = 333;

    public NavigateArrowOptions() {
        this.points = new ArrayList<LatLng>();
        this.type = "NavigateArrowOptions";
    }

    public NavigateArrowOptions add(LatLng latLng) {
        this.points.add(latLng);
        return this;
    }

    public NavigateArrowOptions add(LatLng ... latLngArray) {
        this.points.addAll(Arrays.asList(latLngArray));
        return this;
    }

    public NavigateArrowOptions addAll(Iterable<LatLng> iterable) {
        for (LatLng latLng : iterable) {
            this.points.add(latLng);
        }
        return this;
    }

    public NavigateArrowOptions width(float f2) {
        this.width = f2;
        return this;
    }

    public NavigateArrowOptions topColor(int n2) {
        this.topColor = n2;
        return this;
    }

    public NavigateArrowOptions sideColor(int n2) {
        this.sideColor = n2;
        return this;
    }

    public NavigateArrowOptions zIndex(float f2) {
        this.zIndex = f2;
        return this;
    }

    public NavigateArrowOptions visible(boolean bl2) {
        this.isVisible = bl2;
        return this;
    }

    public NavigateArrowOptions set3DModel(boolean bl2) {
        this.is3DModel = bl2;
        return this;
    }

    public List<LatLng> getPoints() {
        return this.points;
    }

    public float getWidth() {
        return this.width;
    }

    public int getTopColor() {
        return this.topColor;
    }

    public int getSideColor() {
        return this.sideColor;
    }

    public float getZIndex() {
        return this.zIndex;
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    public boolean is3DModel() {
        return this.is3DModel;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel parcel, int n2) {
        parcel.writeTypedList(this.points);
        parcel.writeFloat(this.width);
        parcel.writeInt(this.topColor);
        parcel.writeInt(this.sideColor);
        parcel.writeFloat(this.zIndex);
        parcel.writeByte((byte)(this.isVisible ? 1 : 0));
        parcel.writeString(this.a);
        parcel.writeByte((byte)(this.is3DModel ? 1 : 0));
    }

    public void setPoints(List<LatLng> list) {
        if (list != null && this.points != list) {
            try {
                this.points.clear();
                this.points.addAll(list);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    public NavigateArrowOptions clone() {
        try {
            super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace();
        }
        NavigateArrowOptions navigateArrowOptions = new NavigateArrowOptions();
        navigateArrowOptions.points.addAll(this.points);
        navigateArrowOptions.width = this.width;
        navigateArrowOptions.topColor = this.topColor;
        navigateArrowOptions.sideColor = this.sideColor;
        navigateArrowOptions.zIndex = this.zIndex;
        navigateArrowOptions.isVisible = this.isVisible;
        navigateArrowOptions.is3DModel = this.is3DModel;
        navigateArrowOptions.a = this.a;
        navigateArrowOptions.arrowLineInnerResId = this.arrowLineInnerResId;
        navigateArrowOptions.arrowLineOuterResId = this.arrowLineOuterResId;
        navigateArrowOptions.arrowLineShadowResId = this.arrowLineShadowResId;
        return navigateArrowOptions;
    }
}

